#!/usr/bin/env bash



# set -e: exit on errors
# set -x: verbose logging

set -ex



# Configure bash globbing for recursive cp command

shopt -s globstar



# Set variables

PORT="_build/SM64 Reloaded (Dolphin)"

echo -n "Type dds if you converted the textures to that format, otherwise just press enter to use PNG (default): "
read VALUE

case "$VALUE" in

  dds)
    EXT=".dds"
    ;;

  *)
    EXT=".png"
    ;;
esac



# Remove and recreate work directories

rm -drf "$PORT"
rm -drf "_temp"

mkdir -p "$PORT"
mkdir -p "_temp"



# Copy textures to work directories

cp -r "Ports/Dolphin/"* "$PORT"
cp **"/SUPER MARIO 64"*"$EXT" "_temp"



# Create directories

mkdir -p "$PORT/Areas/Big Boo's Haunt"
mkdir -p "$PORT/Areas/Bob-omb Battlefield/Injects"
mkdir -p "$PORT/Areas/Bowser in the Dark World/Boss"
mkdir -p "$PORT/Areas/Bowser in the Fire Sea"
mkdir -p "$PORT/Areas/Bowser in the Sky/Boss"
mkdir -p "$PORT/Areas/Castle Inside/Injects"
mkdir -p "$PORT/Areas/Castle Outside/Window"
mkdir -p "$PORT/Areas/Cavern of the Metal Cap"
mkdir -p "$PORT/Areas/Cool Cool Mountain/unused"
mkdir -p "$PORT/Areas/Dire Dire Docks/Ship Room"
mkdir -p "$PORT/Areas/Hazy Maze Cave/Maps"
mkdir -p "$PORT/Areas/Jolly Roger Bay/Chest"
mkdir -p "$PORT/Areas/Jolly Roger Bay/Crate"
mkdir -p "$PORT/Areas/Jolly Roger Bay/Kelp"
mkdir -p "$PORT/Areas/Jolly Roger Bay/Ship"
mkdir -p "$PORT/Areas/Lethal Lava Land/Bowser"
mkdir -p "$PORT/Areas/Lethal Lava Land/unused"
mkdir -p "$PORT/Areas/Lethal Lava Land/Volcano"
mkdir -p "$PORT/Areas/Rainbow Ride"
mkdir -p "$PORT/Areas/Shifting Sand Land/Block"
mkdir -p "$PORT/Areas/Shifting Sand Land/Pyramid"
mkdir -p "$PORT/Areas/Shifting Sand Land/unused"
mkdir -p "$PORT/Areas/Snowman's Land"
mkdir -p "$PORT/Areas/Tall Tall Mountain/Slide"
mkdir -p "$PORT/Areas/Tall Tall Mountain/Slide Entrance"
mkdir -p "$PORT/Areas/The Princess's Secret Slide"
mkdir -p "$PORT/Areas/Tick Tock Clock"
mkdir -p "$PORT/Areas/Tiny-Huge Island/Wiggler's Cave"
mkdir -p "$PORT/Areas/Tower of the Wing Cap"
mkdir -p "$PORT/Areas/Vanish Cap Under the Moat"
mkdir -p "$PORT/Areas/Wet-Dry World"
mkdir -p "$PORT/Areas/Whomp's Fortress"
mkdir -p "$PORT/Areas/Wing Mario Over the Rainbow"
mkdir -p "$PORT/Boot/Logo"
mkdir -p "$PORT/Boot/File Select/Hand"
mkdir -p "$PORT/Boot/Press Start/Game Over"
mkdir -p "$PORT/Boot/Press Start/Grey Star"
mkdir -p "$PORT/Boot/Press Start/Hand"
mkdir -p "$PORT/Boot/Press Start/Red Star"
mkdir -p "$PORT/Boot/Press Start/Title"
mkdir -p "$PORT/Characters/Amp"
mkdir -p "$PORT/Characters/Bob-omb"
mkdir -p "$PORT/Characters/Boo"
mkdir -p "$PORT/Characters/Book"
mkdir -p "$PORT/Characters/Bowser"
mkdir -p "$PORT/Characters/Bubba"
mkdir -p "$PORT/Characters/Bullet Bill"
mkdir -p "$PORT/Characters/Bully"
mkdir -p "$PORT/Characters/Butterfly"
mkdir -p "$PORT/Characters/Chain Chomp/Injects"
mkdir -p "$PORT/Characters/Chilly Chief"
mkdir -p "$PORT/Characters/Chuckya"
mkdir -p "$PORT/Characters/Clam Shell"
mkdir -p "$PORT/Characters/Dorrie"
mkdir -p "$PORT/Characters/Eyerok"
mkdir -p "$PORT/Characters/Fish"
mkdir -p "$PORT/Characters/Flyguy"
mkdir -p "$PORT/Characters/Goomba"
mkdir -p "$PORT/Characters/Grindel"
mkdir -p "$PORT/Characters/Heave Ho"
mkdir -p "$PORT/Characters/Hoot"
mkdir -p "$PORT/Characters/Koopa"
mkdir -p "$PORT/Characters/King Bob-omb"
mkdir -p "$PORT/Characters/Klepto"
mkdir -p "$PORT/Characters/Lakitu/unused"
mkdir -p "$PORT/Characters/Mad Piano"
mkdir -p "$PORT/Characters/Manta Ray"
mkdir -p "$PORT/Characters/Mario/unused"
mkdir -p "$PORT/Characters/Mips"
mkdir -p "$PORT/Characters/Moneybag"
mkdir -p "$PORT/Characters/Monty Mole"
mkdir -p "$PORT/Characters/Mr. Blizzard"
mkdir -p "$PORT/Characters/Mr. I"
mkdir -p "$PORT/Characters/Peach/Letter"
mkdir -p "$PORT/Characters/Penguin/unused"
mkdir -p "$PORT/Characters/Piranha Plant"
mkdir -p "$PORT/Characters/Pokey"
mkdir -p "$PORT/Characters/Scuttlebug"
mkdir -p "$PORT/Characters/Skeeter"
mkdir -p "$PORT/Characters/Snufit"
mkdir -p "$PORT/Characters/Spindrift"
mkdir -p "$PORT/Characters/Sushi"
mkdir -p "$PORT/Characters/Swoop"
mkdir -p "$PORT/Characters/Thwomp"
mkdir -p "$PORT/Characters/Toad"
mkdir -p "$PORT/Characters/Ukiki"
mkdir -p "$PORT/Characters/Unagi"
mkdir -p "$PORT/Characters/Whomp"
mkdir -p "$PORT/Characters/Wiggler"
mkdir -p "$PORT/Characters/Yoshi"
mkdir -p "$PORT/Effects/Bubbles and Particles/Injects"
mkdir -p "$PORT/Effects/Burn Smoke"
mkdir -p "$PORT/Effects/Explosion"
mkdir -p "$PORT/Effects/Flame"
mkdir -p "$PORT/Effects/Flower (unused)"
mkdir -p "$PORT/Effects/Impact Ring"
mkdir -p "$PORT/Effects/Lava Bubble/unused"
mkdir -p "$PORT/Effects/Light/Big Boo's Haunt"
mkdir -p "$PORT/Effects/Metal"
mkdir -p "$PORT/Effects/Particles"
mkdir -p "$PORT/Effects/Pebble"
mkdir -p "$PORT/Effects/Run"
mkdir -p "$PORT/Effects/Shadow"
mkdir -p "$PORT/Effects/Sparkle/Animation"
mkdir -p "$PORT/Effects/Sparkle/Press Start/unused"
mkdir -p "$PORT/Effects/Stomp"
mkdir -p "$PORT/Effects/Swim"
mkdir -p "$PORT/Effects/Tornado/Injects"
mkdir -p "$PORT/Effects/Transitions"
mkdir -p "$PORT/Effects/Water Splash"
mkdir -p "$PORT/Effects/Bowser Explosion/00"
mkdir -p "$PORT/Effects/Bowser Explosion/01"
mkdir -p "$PORT/Effects/Bowser Explosion/02"
mkdir -p "$PORT/Effects/Bowser Explosion/03"
mkdir -p "$PORT/Effects/Bowser Explosion/04"
mkdir -p "$PORT/Effects/Bowser Explosion/05"
mkdir -p "$PORT/Effects/Bowser Explosion/06"
mkdir -p "$PORT/Effects/Bowser Explosion/07"
mkdir -p "$PORT/Effects/Bowser Explosion/08"
mkdir -p "$PORT/Effects/Bowser Explosion/09"
mkdir -p "$PORT/Effects/Bowser Explosion/10"
mkdir -p "$PORT/Effects/Bowser Explosion/11"
mkdir -p "$PORT/Effects/Bowser Explosion/12"
mkdir -p "$PORT/Effects/Bowser Explosion/13"
mkdir -p "$PORT/Ending/Europe/English"
mkdir -p "$PORT/Ending/Europe/French"
mkdir -p "$PORT/Ending/Europe/German"
mkdir -p "$PORT/Hacks/Italian/Boot"
mkdir -p "$PORT/Hacks/Italian/Game Over"
mkdir -p "$PORT/Hacks/Italian/Power Meter"
mkdir -p "$PORT/Hacks/Italian/Doors"
mkdir -p "$PORT/Hacks/Italian/Ending"
mkdir -p "$PORT/Hacks/Italian/File Select"
mkdir -p "$PORT/Hacks/Italian/Accents"
mkdir -p "$PORT/Hacks/Italian/Credits"
mkdir -p "$PORT/Hacks/Low Poly Promo Models/Bowser"
mkdir -p "$PORT/Hacks/Low Poly Promo Models/Luigi"
mkdir -p "$PORT/Hacks/Low Poly Promo Models/Mario"
mkdir -p "$PORT/Hacks/Low Poly Promo Models/Peach"
mkdir -p "$PORT/Hacks/Low Poly Promo Models/Toad"
mkdir -p "$PORT/Hacks/Multiplayer/v1.2"
mkdir -p "$PORT/Hacks/Multiplayer/v1.3"
mkdir -p "$PORT/Hacks/Multiplayer/v1.3.1"
mkdir -p "$PORT/Hacks/Shindou Improvement"
mkdir -p "$PORT/HUD/Course"
mkdir -p "$PORT/HUD/Font"
mkdir -p "$PORT/HUD/Icons"
mkdir -p "$PORT/HUD/Power Meter"
mkdir -p "$PORT/HUD/Course/Europe"
mkdir -p "$PORT/HUD/Course/Europe/English"
mkdir -p "$PORT/HUD/Course/Europe/French"
mkdir -p "$PORT/HUD/Course/Europe/German"
mkdir -p "$PORT/HUD/Font/Japanese"
mkdir -p "$PORT/Letters/16x8"
mkdir -p "$PORT/Letters/8x8"
mkdir -p "$PORT/Letters/Credits"
mkdir -p "$PORT/Letters/16x8/Buttons"
mkdir -p "$PORT/Letters/16x8/Capital"
mkdir -p "$PORT/Letters/16x8/Lowercase"
mkdir -p "$PORT/Letters/16x8/Numerals"
mkdir -p "$PORT/Letters/16x8/Punctuation"
mkdir -p "$PORT/Letters/16x8/Special"
mkdir -p "$PORT/Letters/16x8/Symbols"
mkdir -p "$PORT/Letters/16x8/Buttons/A"
mkdir -p "$PORT/Letters/16x8/Buttons/B"
mkdir -p "$PORT/Letters/16x8/Buttons/C"
mkdir -p "$PORT/Letters/16x8/Buttons/R"
mkdir -p "$PORT/Letters/16x8/Buttons/Z"
mkdir -p "$PORT/Letters/16x8/Capital/A"
mkdir -p "$PORT/Letters/16x8/Capital/B"
mkdir -p "$PORT/Letters/16x8/Capital/C"
mkdir -p "$PORT/Letters/16x8/Capital/D"
mkdir -p "$PORT/Letters/16x8/Capital/E"
mkdir -p "$PORT/Letters/16x8/Capital/F"
mkdir -p "$PORT/Letters/16x8/Capital/G"
mkdir -p "$PORT/Letters/16x8/Capital/H"
mkdir -p "$PORT/Letters/16x8/Capital/I"
mkdir -p "$PORT/Letters/16x8/Capital/J"
mkdir -p "$PORT/Letters/16x8/Capital/K"
mkdir -p "$PORT/Letters/16x8/Capital/L"
mkdir -p "$PORT/Letters/16x8/Capital/M"
mkdir -p "$PORT/Letters/16x8/Capital/N"
mkdir -p "$PORT/Letters/16x8/Capital/O"
mkdir -p "$PORT/Letters/16x8/Capital/P"
mkdir -p "$PORT/Letters/16x8/Capital/Q"
mkdir -p "$PORT/Letters/16x8/Capital/R"
mkdir -p "$PORT/Letters/16x8/Capital/S"
mkdir -p "$PORT/Letters/16x8/Capital/T"
mkdir -p "$PORT/Letters/16x8/Capital/U"
mkdir -p "$PORT/Letters/16x8/Capital/V"
mkdir -p "$PORT/Letters/16x8/Capital/W"
mkdir -p "$PORT/Letters/16x8/Capital/X"
mkdir -p "$PORT/Letters/16x8/Capital/Y"
mkdir -p "$PORT/Letters/16x8/Capital/Z"
mkdir -p "$PORT/Letters/16x8/Lowercase/a"
mkdir -p "$PORT/Letters/16x8/Lowercase/b"
mkdir -p "$PORT/Letters/16x8/Lowercase/c"
mkdir -p "$PORT/Letters/16x8/Lowercase/d"
mkdir -p "$PORT/Letters/16x8/Lowercase/e"
mkdir -p "$PORT/Letters/16x8/Lowercase/f"
mkdir -p "$PORT/Letters/16x8/Lowercase/g"
mkdir -p "$PORT/Letters/16x8/Lowercase/h"
mkdir -p "$PORT/Letters/16x8/Lowercase/i"
mkdir -p "$PORT/Letters/16x8/Lowercase/j"
mkdir -p "$PORT/Letters/16x8/Lowercase/k"
mkdir -p "$PORT/Letters/16x8/Lowercase/l"
mkdir -p "$PORT/Letters/16x8/Lowercase/m"
mkdir -p "$PORT/Letters/16x8/Lowercase/n"
mkdir -p "$PORT/Letters/16x8/Lowercase/o"
mkdir -p "$PORT/Letters/16x8/Lowercase/p"
mkdir -p "$PORT/Letters/16x8/Lowercase/q"
mkdir -p "$PORT/Letters/16x8/Lowercase/r"
mkdir -p "$PORT/Letters/16x8/Lowercase/s"
mkdir -p "$PORT/Letters/16x8/Lowercase/t"
mkdir -p "$PORT/Letters/16x8/Lowercase/u"
mkdir -p "$PORT/Letters/16x8/Lowercase/v"
mkdir -p "$PORT/Letters/16x8/Lowercase/w"
mkdir -p "$PORT/Letters/16x8/Lowercase/x"
mkdir -p "$PORT/Letters/16x8/Lowercase/y"
mkdir -p "$PORT/Letters/16x8/Lowercase/z"
mkdir -p "$PORT/Letters/16x8/Numerals/0"
mkdir -p "$PORT/Letters/16x8/Numerals/1"
mkdir -p "$PORT/Letters/16x8/Numerals/2"
mkdir -p "$PORT/Letters/16x8/Numerals/3"
mkdir -p "$PORT/Letters/16x8/Numerals/4"
mkdir -p "$PORT/Letters/16x8/Numerals/5"
mkdir -p "$PORT/Letters/16x8/Numerals/6"
mkdir -p "$PORT/Letters/16x8/Numerals/7"
mkdir -p "$PORT/Letters/16x8/Numerals/8"
mkdir -p "$PORT/Letters/16x8/Numerals/9"
mkdir -p "$PORT/Letters/8x8/Capital"
mkdir -p "$PORT/Letters/8x8/Numerals"
mkdir -p "$PORT/Letters/8x8/Punctuation"
mkdir -p "$PORT/Letters/8x8/Special"
mkdir -p "$PORT/Letters/8x8/Symbols"
mkdir -p "$PORT/Letters/8x8/Capital/A"
mkdir -p "$PORT/Letters/8x8/Capital/B"
mkdir -p "$PORT/Letters/8x8/Capital/C"
mkdir -p "$PORT/Letters/8x8/Capital/D (Europe)"
mkdir -p "$PORT/Letters/8x8/Capital/D (USA)"
mkdir -p "$PORT/Letters/8x8/Capital/E"
mkdir -p "$PORT/Letters/8x8/Capital/F"
mkdir -p "$PORT/Letters/8x8/Capital/G"
mkdir -p "$PORT/Letters/8x8/Capital/H"
mkdir -p "$PORT/Letters/8x8/Capital/I"
mkdir -p "$PORT/Letters/8x8/Capital/J"
mkdir -p "$PORT/Letters/8x8/Capital/K"
mkdir -p "$PORT/Letters/8x8/Capital/L"
mkdir -p "$PORT/Letters/8x8/Capital/M"
mkdir -p "$PORT/Letters/8x8/Capital/N"
mkdir -p "$PORT/Letters/8x8/Capital/O"
mkdir -p "$PORT/Letters/8x8/Capital/P"
mkdir -p "$PORT/Letters/8x8/Capital/Q"
mkdir -p "$PORT/Letters/8x8/Capital/R"
mkdir -p "$PORT/Letters/8x8/Capital/S"
mkdir -p "$PORT/Letters/8x8/Capital/T"
mkdir -p "$PORT/Letters/8x8/Capital/U"
mkdir -p "$PORT/Letters/8x8/Capital/V"
mkdir -p "$PORT/Letters/8x8/Capital/W"
mkdir -p "$PORT/Letters/8x8/Capital/X"
mkdir -p "$PORT/Letters/8x8/Capital/Y"
mkdir -p "$PORT/Letters/8x8/Capital/Z"
mkdir -p "$PORT/Letters/8x8/Numerals/0"
mkdir -p "$PORT/Letters/8x8/Numerals/1"
mkdir -p "$PORT/Letters/8x8/Numerals/2"
mkdir -p "$PORT/Letters/8x8/Numerals/3"
mkdir -p "$PORT/Letters/8x8/Numerals/4"
mkdir -p "$PORT/Letters/8x8/Numerals/5"
mkdir -p "$PORT/Letters/8x8/Numerals/6"
mkdir -p "$PORT/Letters/8x8/Numerals/7"
mkdir -p "$PORT/Letters/8x8/Numerals/8"
mkdir -p "$PORT/Letters/8x8/Numerals/9"
mkdir -p "$PORT/Letters/8x8/Punctuation/Europe"
mkdir -p "$PORT/Objects/1-UP"
mkdir -p "$PORT/Objects/Blue Coin Switch"
mkdir -p "$PORT/Objects/Bomb"
mkdir -p "$PORT/Objects/Boxes"
mkdir -p "$PORT/Objects/Breakable Box"
mkdir -p "$PORT/Objects/Cannon"
mkdir -p "$PORT/Objects/Cap Switch"
mkdir -p "$PORT/Objects/Chair/unused"
mkdir -p "$PORT/Objects/Checkerboard Platform"
mkdir -p "$PORT/Objects/Coin"
mkdir -p "$PORT/Objects/Doors/Injects"
mkdir -p "$PORT/Objects/Heart"
mkdir -p "$PORT/Objects/Lava"
mkdir -p "$PORT/Objects/Metal Box"
mkdir -p "$PORT/Objects/Pipe"
mkdir -p "$PORT/Objects/Poundable Pole"
mkdir -p "$PORT/Objects/Purple Switch"
mkdir -p "$PORT/Objects/Sign"
mkdir -p "$PORT/Objects/Star"
mkdir -p "$PORT/Objects/Trees"
mkdir -p "$PORT/Objects/Water"
mkdir -p "$PORT/Objects/Water Bubble"
mkdir -p "$PORT/Objects/Yellow Sphere"
mkdir -p "$PORT/Paintings/Bob-omb Battlefield"
mkdir -p "$PORT/Paintings/Bowser"
mkdir -p "$PORT/Paintings/Cool Cool Mountain"
mkdir -p "$PORT/Paintings/Dire Dire Docks"
mkdir -p "$PORT/Paintings/Jolly Roger Bay"
mkdir -p "$PORT/Paintings/Lethal Lava Land"
mkdir -p "$PORT/Paintings/Peach"
mkdir -p "$PORT/Paintings/Shifting Sand Land"
mkdir -p "$PORT/Paintings/Snowman's Land"
mkdir -p "$PORT/Paintings/Tall Tall Mountain"
mkdir -p "$PORT/Paintings/Tick Tock Clock"
mkdir -p "$PORT/Paintings/Tiny-Huge Island"
mkdir -p "$PORT/Paintings/Wet-Dry World"
mkdir -p "$PORT/Paintings/Whomp's Fortress"
mkdir -p "$PORT/Paintings/Jolly Roger Bay/Japan"
mkdir -p "$PORT/Skybox/Big Boo's Haunt"
mkdir -p "$PORT/Skybox/Bowser in the Dark World"
mkdir -p "$PORT/Skybox/Bowser in the Fire Sea"
mkdir -p "$PORT/Skybox/Bowser in the Sky"
mkdir -p "$PORT/Skybox/Cloud Floor"
mkdir -p "$PORT/Skybox/Clouds"
mkdir -p "$PORT/Skybox/Cool Cool Mountain"
mkdir -p "$PORT/Skybox/Shifting Sand Land"
mkdir -p "$PORT/Skybox/Water"
mkdir -p "$PORT/Skybox/Wet-Dry World"



# Copy and rename textures

cp "_temp/SUPER MARIO 64#0AD7A8F7#0#2_all$EXT" "$PORT/Areas/Big Boo's Haunt/tex1_32x32_1c720501c4c3132e_5$EXT"
cp "_temp/SUPER MARIO 64#0C8C45BA#0#2_all$EXT" "$PORT/Areas/Big Boo's Haunt/tex1_32x16_49f1947173969f7b_5$EXT"
cp "_temp/SUPER MARIO 64#1C62CC15#0#2_all$EXT" "$PORT/Areas/Big Boo's Haunt/tex1_32x32_c02fa597abc9e086_5$EXT"
cp "_temp/SUPER MARIO 64#4A4683BC#0#2_all$EXT" "$PORT/Areas/Big Boo's Haunt/tex1_32x32_7a83cf0b0ccb206e_5$EXT"
cp "_temp/SUPER MARIO 64#15D30589#0#2_all$EXT" "$PORT/Areas/Big Boo's Haunt/tex1_32x64_2deb1b41c3db7576_5$EXT"
cp "_temp/SUPER MARIO 64#042DEE1B#0#2_all$EXT" "$PORT/Areas/Big Boo's Haunt/tex1_32x64_70d1da4065ca9b23_5$EXT"
cp "_temp/SUPER MARIO 64#78AB0F9F#0#2_all$EXT" "$PORT/Areas/Big Boo's Haunt/tex1_64x32_786f6897cdec4de8_5$EXT"
cp "_temp/SUPER MARIO 64#381EA750#0#2_all$EXT" "$PORT/Areas/Big Boo's Haunt/tex1_32x64_bf5ffb664ec081f3_5$EXT"
cp "_temp/SUPER MARIO 64#3157CD18#0#2_all$EXT" "$PORT/Areas/Big Boo's Haunt/tex1_32x64_bef8ec65500a0859_5$EXT"
cp "_temp/SUPER MARIO 64#4443D529#0#2_all$EXT" "$PORT/Areas/Big Boo's Haunt/tex1_32x32_c00cc7a5331f3658_5$EXT"
cp "_temp/SUPER MARIO 64#24767D89#0#2_all$EXT" "$PORT/Areas/Big Boo's Haunt/tex1_32x32_0ffc51d6b5a67267_5$EXT"
cp "_temp/SUPER MARIO 64#222768FA#0#2_all$EXT" "$PORT/Areas/Big Boo's Haunt/tex1_32x32_b9ae587372271729_5$EXT"
cp "_temp/SUPER MARIO 64#8899587D#0#2_all$EXT" "$PORT/Areas/Big Boo's Haunt/tex1_32x64_161ae71fc7dcef49_5$EXT"
cp "_temp/SUPER MARIO 64#17405808#0#2_all$EXT" "$PORT/Areas/Big Boo's Haunt/tex1_32x64_140b91ba1263a024_5$EXT"
cp "_temp/SUPER MARIO 64#49313621#0#2_all$EXT" "$PORT/Areas/Big Boo's Haunt/tex1_32x16_491f13c5ccb0e7e8_5$EXT"
cp "_temp/SUPER MARIO 64#A4AF5230#0#2_all$EXT" "$PORT/Areas/Big Boo's Haunt/tex1_32x32_69eca38532ff9d73_5$EXT"
cp "_temp/SUPER MARIO 64#B5B2C148#0#2_all$EXT" "$PORT/Areas/Big Boo's Haunt/tex1_32x32_c4e8cbf65a953302_5$EXT"
cp "_temp/SUPER MARIO 64#B8F6006F#0#2_all$EXT" "$PORT/Areas/Big Boo's Haunt/tex1_32x32_90110c932141fa06_5$EXT"
cp "_temp/SUPER MARIO 64#BD28248A#0#2_all$EXT" "$PORT/Areas/Big Boo's Haunt/tex1_32x64_776f341d2e91f8e8_5$EXT"
cp "_temp/SUPER MARIO 64#C9E2883E#0#2_all$EXT" "$PORT/Areas/Big Boo's Haunt/tex1_32x32_fb046ad276c2f777_5$EXT"
cp "_temp/SUPER MARIO 64#C99707D9#0#2_all$EXT" "$PORT/Areas/Big Boo's Haunt/tex1_64x32_ee3dd6464b465272_5$EXT"
cp "_temp/SUPER MARIO 64#D950DA92#0#2_all$EXT" "$PORT/Areas/Big Boo's Haunt/tex1_32x16_6ca5e07058d4fa5c_5$EXT"
cp "_temp/SUPER MARIO 64#E559FC96#0#2_all$EXT" "$PORT/Areas/Big Boo's Haunt/tex1_32x64_994acc5a6993f6c8_5$EXT"
cp "_temp/SUPER MARIO 64#EDA45656#0#2_all$EXT" "$PORT/Areas/Big Boo's Haunt/tex1_32x16_7467f39a7b889ebe_5$EXT"
cp "_temp/SUPER MARIO 64#FFF8437E#0#2_all$EXT" "$PORT/Areas/Big Boo's Haunt/tex1_32x32_9bf17ef57956f748_5$EXT"

cp "_temp/SUPER MARIO 64#0DDBBC70#0#2_all$EXT" "$PORT/Areas/Bob-omb Battlefield/tex1_32x32_9ec60296a8f3b813_5$EXT"
cp "_temp/SUPER MARIO 64#4B070BC3#0#2_all$EXT" "$PORT/Areas/Bob-omb Battlefield/tex1_32x32_1674c9e902cc9fd1_5$EXT"
cp "_temp/SUPER MARIO 64#4D03386E#0#2_all$EXT" "$PORT/Areas/Bob-omb Battlefield/tex1_32x32_e61958d4af150fe5_5$EXT"
cp "_temp/SUPER MARIO 64#4D03386E#0#2_all$EXT" "$PORT/Areas/Bob-omb Battlefield/Injects/tex1_32x32_fb46370883a8bb81_5$EXT"
cp "_temp/SUPER MARIO 64#061A6C74#0#2_all$EXT" "$PORT/Areas/Bob-omb Battlefield/tex1_32x64_cfc036e466289bc2_5$EXT"
cp "_temp/SUPER MARIO 64#215CE254#0#2_all$EXT" "$PORT/Areas/Bob-omb Battlefield/tex1_32x32_e4b290211ed1a8fd_5$EXT"
cp "_temp/SUPER MARIO 64#245EA00F#0#2_all$EXT" "$PORT/Areas/Bob-omb Battlefield/tex1_32x32_2e753eebfb858787_5$EXT"
cp "_temp/SUPER MARIO 64#602EF33F#0#2_all$EXT" "$PORT/Areas/Bob-omb Battlefield/tex1_32x32_ff7c72327cb5c985_5$EXT"
cp "_temp/SUPER MARIO 64#1448C073#0#2_all$EXT" "$PORT/Areas/Bob-omb Battlefield/tex1_32x32_1a1b93fb39013600_5$EXT"
cp "_temp/SUPER MARIO 64#9026CBA3#0#2_all$EXT" "$PORT/Areas/Bob-omb Battlefield/tex1_32x32_26c0736b915c7597_5$EXT"
cp "_temp/SUPER MARIO 64#9026CBA3#0#2_all$EXT" "$PORT/Areas/Bob-omb Battlefield/Injects/tex1_32x32_100699d9817e53c7_5$EXT"
cp "_temp/SUPER MARIO 64#A2D48F6C#0#2_all$EXT" "$PORT/Areas/Bob-omb Battlefield/tex1_32x32_401f48fda1b143a9_5$EXT"
cp "_temp/SUPER MARIO 64#AE019762#0#2_all$EXT" "$PORT/Areas/Bob-omb Battlefield/tex1_32x32_1e0b497b7a40a48b_5$EXT"
cp "_temp/SUPER MARIO 64#AEC008C0#0#2_all$EXT" "$PORT/Areas/Bob-omb Battlefield/tex1_32x32_de2b800779065e28_5$EXT"
cp "_temp/SUPER MARIO 64#AEF22277#0#2_all$EXT" "$PORT/Areas/Bob-omb Battlefield/tex1_32x32_7d307905f3333f25_5$EXT"
cp "_temp/SUPER MARIO 64#B7B83492#0#2_all$EXT" "$PORT/Areas/Bob-omb Battlefield/tex1_32x32_f793410144b9dc26_5$EXT"
cp "_temp/SUPER MARIO 64#CBE026C4#0#2_all$EXT" "$PORT/Areas/Bob-omb Battlefield/tex1_32x32_5061427a93e2c5f2_5$EXT"
cp "_temp/SUPER MARIO 64#DD78FBD8#0#2_all$EXT" "$PORT/Areas/Bob-omb Battlefield/tex1_32x32_448c81a447f56d8a_5$EXT"
cp "_temp/SUPER MARIO 64#FDBCE221#0#2_all$EXT" "$PORT/Areas/Bob-omb Battlefield/tex1_32x32_ae0ebd941f207822_5$EXT"

cp "_temp/SUPER MARIO 64#60351310#0#2_all$EXT" "$PORT/Areas/Bowser in the Dark World/Boss/tex1_32x32_f6802383863aec47_5$EXT"
cp "_temp/SUPER MARIO 64#B017CFF7#0#2_all$EXT" "$PORT/Areas/Bowser in the Dark World/Boss/tex1_32x64_affc673fa84a8696_5$EXT"
cp "_temp/SUPER MARIO 64#CA7E41B1#0#2_all$EXT" "$PORT/Areas/Bowser in the Dark World/Boss/tex1_32x32_eb281a3005c042ea_5$EXT"
cp "_temp/SUPER MARIO 64#13132153#0#2_all$EXT" "$PORT/Areas/Bowser in the Dark World/tex1_32x32_a301c82d909e0fb3_5$EXT"
cp "_temp/SUPER MARIO 64#177D197C#0#2_all$EXT" "$PORT/Areas/Bowser in the Dark World/tex1_32x32_15edd2fa2be2e3bf_5$EXT"
cp "_temp/SUPER MARIO 64#50964858#0#2_all$EXT" "$PORT/Areas/Bowser in the Dark World/tex1_32x32_52cfc6be4f0b43c2_5$EXT"
cp "_temp/SUPER MARIO 64#54670BB6#0#2_all$EXT" "$PORT/Areas/Bowser in the Dark World/tex1_32x32_3c10c77ea8987e69_5$EXT"
cp "_temp/SUPER MARIO 64#59C3CDD9#0#2_all$EXT" "$PORT/Areas/Bowser in the Dark World/tex1_32x32_81df8a1717c14815_5$EXT"
cp "_temp/SUPER MARIO 64#5D5BB4D6#0#2_all$EXT" "$PORT/Areas/Bowser in the Dark World/tex1_32x32_88fd9e90eaafc5c0_5$EXT"
cp "_temp/SUPER MARIO 64#7A6AB5A7#0#2_all$EXT" "$PORT/Areas/Bowser in the Dark World/tex1_32x32_79b2c898d217aa66_5$EXT"
cp "_temp/SUPER MARIO 64#7E5C24F7#0#2_all$EXT" "$PORT/Areas/Bowser in the Dark World/tex1_32x32_e5310a2c9899ee83_5$EXT"
cp "_temp/SUPER MARIO 64#8FC7FAC2#0#2_all$EXT" "$PORT/Areas/Bowser in the Dark World/tex1_32x64_e9e769a2e96b9408_5$EXT"
cp "_temp/SUPER MARIO 64#A11B5CF3#0#2_all$EXT" "$PORT/Areas/Bowser in the Dark World/tex1_32x32_aa660bb87db5f072_5$EXT"
cp "_temp/SUPER MARIO 64#B114863B#0#2_all$EXT" "$PORT/Areas/Bowser in the Dark World/tex1_32x32_f44ac04a5e57eb2f_5$EXT"
cp "_temp/SUPER MARIO 64#B63A3055#0#2_all$EXT" "$PORT/Areas/Bowser in the Dark World/tex1_64x32_1db87a0242134a60_5$EXT"
cp "_temp/SUPER MARIO 64#CD71304B#0#2_all$EXT" "$PORT/Areas/Bowser in the Dark World/tex1_32x32_425f3dde18072697_5$EXT"
cp "_temp/SUPER MARIO 64#CF717C3C#0#2_all$EXT" "$PORT/Areas/Bowser in the Dark World/tex1_32x32_de17fc405086c452_5$EXT"
cp "_temp/SUPER MARIO 64#D872790D#0#2_all$EXT" "$PORT/Areas/Bowser in the Dark World/tex1_32x32_07e65fb15936fc5a_5$EXT"
cp "_temp/SUPER MARIO 64#E0C22A3C#0#2_all$EXT" "$PORT/Areas/Bowser in the Dark World/tex1_32x32_21d8cc670aeffbe2_5$EXT"

cp "_temp/SUPER MARIO 64#6D8CFA2F#0#2_all$EXT" "$PORT/Areas/Bowser in the Fire Sea/tex1_32x32_c9141410fc5a0fd0_5$EXT"
cp "_temp/SUPER MARIO 64#8E28628B#0#2_all$EXT" "$PORT/Areas/Bowser in the Fire Sea/tex1_32x32_c7c28abb729582c4_5$EXT"
cp "_temp/SUPER MARIO 64#91252367#0#2_all$EXT" "$PORT/Areas/Bowser in the Fire Sea/tex1_32x32_f6ede63852800294_5$EXT"
cp "_temp/SUPER MARIO 64#A7C43AFC#0#2_all$EXT" "$PORT/Areas/Bowser in the Fire Sea/tex1_64x32_3bbe0f95bc2e1d3b_5$EXT"
cp "_temp/SUPER MARIO 64#FE7EC2B3#0#2_all$EXT" "$PORT/Areas/Bowser in the Fire Sea/tex1_32x32_9e191bdfe70a1079_5$EXT"

cp "_temp/SUPER MARIO 64#204D81E4#0#2_all$EXT" "$PORT/Areas/Bowser in the Sky/Boss/tex1_32x64_62d781ea6929f261_5$EXT"
cp "_temp/SUPER MARIO 64#61C24B5E#0#2_all$EXT" "$PORT/Areas/Bowser in the Sky/Boss/tex1_32x32_73a4996d453b6617_5$EXT"
cp "_temp/SUPER MARIO 64#DF5317B2#0#2_all$EXT" "$PORT/Areas/Bowser in the Sky/Boss/tex1_32x32_152429f68b1b3e64_5$EXT"
cp "_temp/SUPER MARIO 64#6069E288#0#2_all$EXT" "$PORT/Areas/Bowser in the Sky/tex1_32x64_045ebf032acb9dff_5$EXT"
cp "_temp/SUPER MARIO 64#A290798B#0#2_all$EXT" "$PORT/Areas/Bowser in the Sky/tex1_64x32_4059a4690c5171fa_5$EXT"
cp "_temp/SUPER MARIO 64#B0CD69EF#0#2_all$EXT" "$PORT/Areas/Bowser in the Sky/tex1_32x32_35ad4d431ecffe97_5$EXT"

cp "_temp/SUPER MARIO 64#022F69E3#0#2_all$EXT" "$PORT/Areas/Castle Inside/tex1_32x32_d6c840342357d6d2_5$EXT"
cp "_temp/SUPER MARIO 64#0303136F#0#2_all$EXT" "$PORT/Areas/Castle Inside/tex1_64x32_68f77aa7a408bb2d_5$EXT"
cp "_temp/SUPER MARIO 64#0303136F#0#2_all$EXT" "$PORT/Areas/Castle Inside/Injects/tex1_64x32_f9c1162634f06ff9_5$EXT"
cp "_temp/SUPER MARIO 64#0D487556#0#2_all$EXT" "$PORT/Areas/Castle Inside/tex1_32x64_1b00c44d4aa43fbd_5$EXT"
cp "_temp/SUPER MARIO 64#1E520811#0#2_all$EXT" "$PORT/Areas/Castle Inside/tex1_64x32_705af2ba7c83535e_5$EXT"
cp "_temp/SUPER MARIO 64#1E520811#0#2_all$EXT" "$PORT/Areas/Castle Inside/Injects/tex1_64x32_13c0a3a24c51266b_5$EXT"
cp "_temp/SUPER MARIO 64#2DC59B5C#0#2_all$EXT" "$PORT/Areas/Castle Inside/tex1_32x64_0c977f66bf693cc9_5$EXT"
cp "_temp/SUPER MARIO 64#4EEEFE7D#0#2_all$EXT" "$PORT/Areas/Castle Inside/tex1_32x32_2ef407a63b65a120_5$EXT"
cp "_temp/SUPER MARIO 64#4EEEFE7D#0#2_all$EXT" "$PORT/Areas/Castle Inside/Injects/tex1_32x32_1b4ac09ee657547e_5$EXT"
cp "_temp/SUPER MARIO 64#54F2C81A#0#2_all$EXT" "$PORT/Areas/Castle Inside/tex1_32x32_10146af6ccaed382_5$EXT"
cp "_temp/SUPER MARIO 64#59D072F0#0#2_all$EXT" "$PORT/Areas/Castle Inside/tex1_64x32_c357c242a32fcca7_5$EXT"
cp "_temp/SUPER MARIO 64#6AA1BE26#0#2_all$EXT" "$PORT/Areas/Castle Inside/tex1_32x32_d8b04c5522190f5f_5$EXT"
cp "_temp/SUPER MARIO 64#6DA0B1B9#0#2_all$EXT" "$PORT/Areas/Castle Inside/tex1_32x64_e19be89115989bc9_5$EXT"
cp "_temp/SUPER MARIO 64#7134B6DD#0#2_all$EXT" "$PORT/Areas/Castle Inside/tex1_32x32_9864c228494d6559_5$EXT"
cp "_temp/SUPER MARIO 64#730DA5F2#0#2_all$EXT" "$PORT/Areas/Castle Inside/tex1_32x64_13fd80d0bd18fe78_5$EXT"
cp "_temp/SUPER MARIO 64#8EE5398C#0#2_all$EXT" "$PORT/Areas/Castle Inside/tex1_32x32_811709e9b3e956a5_5$EXT"
cp "_temp/SUPER MARIO 64#9BE30B6E#0#2_all$EXT" "$PORT/Areas/Castle Inside/tex1_32x32_2eb65991f5d707fe_5$EXT"
cp "_temp/SUPER MARIO 64#9FCDDCE1#0#2_all$EXT" "$PORT/Areas/Castle Inside/tex1_32x64_e744f53617811da9_5$EXT"
cp "_temp/SUPER MARIO 64#A6463A8D#0#2_all$EXT" "$PORT/Areas/Castle Inside/tex1_32x32_72765569e3e0c51d_5$EXT"
cp "_temp/SUPER MARIO 64#D10D7B85#0#2_all$EXT" "$PORT/Areas/Castle Inside/tex1_32x32_f3d48f8abf2f0295_5$EXT"
cp "_temp/SUPER MARIO 64#DBCA0482#0#2_all$EXT" "$PORT/Areas/Castle Inside/tex1_32x32_4822375a0398d5be_5$EXT"
cp "_temp/SUPER MARIO 64#FDB50546#0#2_all$EXT" "$PORT/Areas/Castle Inside/tex1_32x64_f5e5f31588d54df9_5$EXT"
cp "_temp/SUPER MARIO 64#0702FDE6#0#2_all$EXT" "$PORT/Areas/Castle Inside/tex1_32x32_80882ed9edd30e52_5$EXT"

cp "_temp/SUPER MARIO 64#09820848#0#2_all$EXT" "$PORT/Areas/Castle Outside/tex1_32x32_02d648becde2ebd3_5$EXT"
cp "_temp/SUPER MARIO 64#0C89D16B#0#2_all$EXT" "$PORT/Areas/Castle Outside/tex1_32x32_2b5bb6a554e37d6e_5$EXT"
cp "_temp/SUPER MARIO 64#146F813F#0#2_all$EXT" "$PORT/Areas/Castle Outside/tex1_32x64_aba32302d3bf364a_5$EXT"
cp "_temp/SUPER MARIO 64#22F743BF#0#2_all$EXT" "$PORT/Areas/Castle Outside/tex1_64x32_7680936ea5b03cc2_5$EXT"
cp "_temp/SUPER MARIO 64#27ECE31D#0#2_all$EXT" "$PORT/Areas/Castle Outside/tex1_32x32_2294dc844f93db89_5$EXT"
cp "_temp/SUPER MARIO 64#370FC06B#0#2_all$EXT" "$PORT/Areas/Castle Outside/tex1_32x32_48a6b6c357452a40_5$EXT"
cp "_temp/SUPER MARIO 64#4166F73D#0#2_all$EXT" "$PORT/Areas/Castle Outside/tex1_32x64_c38d0560464f7e2d_5$EXT"
cp "_temp/SUPER MARIO 64#5F328955#0#2_all$EXT" "$PORT/Areas/Castle Outside/tex1_32x32_0d7756d449e449a1_5$EXT"
cp "_temp/SUPER MARIO 64#726D3EFE#0#2_all$EXT" "$PORT/Areas/Castle Outside/tex1_32x64_bad698922329e04f_5$EXT"
cp "_temp/SUPER MARIO 64#8296D820#0#2_all$EXT" "$PORT/Areas/Castle Outside/tex1_32x32_abf35b4255695921_5$EXT"
cp "_temp/SUPER MARIO 64#968FA8CE#0#2_all$EXT" "$PORT/Areas/Castle Outside/tex1_32x32_1f70778ad2988cd3_5$EXT"
cp "_temp/SUPER MARIO 64#976DBC10#0#2_all$EXT" "$PORT/Areas/Castle Outside/tex1_32x32_2e892ee893e7603f_5$EXT"
cp "_temp/SUPER MARIO 64#A2C3484F#0#2_all$EXT" "$PORT/Areas/Castle Outside/tex1_32x16_d30dbef9d0fd9670_5$EXT"
cp "_temp/SUPER MARIO 64#A6E20840#0#2_all$EXT" "$PORT/Areas/Castle Outside/tex1_32x32_0023bfee3c60cd0a_5$EXT"
cp "_temp/SUPER MARIO 64#C55C829F#0#2_all$EXT" "$PORT/Areas/Castle Outside/tex1_32x32_5234cc956691eb61_5$EXT"
cp "_temp/SUPER MARIO 64#CC25CE0F#0#2_all$EXT" "$PORT/Areas/Castle Outside/tex1_32x32_6119edb6c0217f1d_5$EXT"
cp "_temp/SUPER MARIO 64#D5BD2CF3#0#2_all$EXT" "$PORT/Areas/Castle Outside/tex1_32x32_d523808d189f4f4f_5$EXT"
cp "_temp/SUPER MARIO 64#D7D14C92#0#2_all$EXT" "$PORT/Areas/Castle Outside/tex1_32x32_5fd2c343b58a1700_5$EXT"
cp "_temp/SUPER MARIO 64#E22B8125#0#2_all$EXT" "$PORT/Areas/Castle Outside/tex1_32x32_93b239ee6e4c1749_5$EXT"
cp "_temp/SUPER MARIO 64#E361666A#0#2_all$EXT" "$PORT/Areas/Castle Outside/tex1_32x32_559637de3244db9b_5$EXT"
cp "_temp/SUPER MARIO 64#F8303731#0#2_all$EXT" "$PORT/Areas/Castle Outside/tex1_64x32_4e469a8ab2afb442_5$EXT"
cp "_temp/SUPER MARIO 64#F92708AD#0#2_all$EXT" "$PORT/Areas/Castle Outside/tex1_32x32_1048b92cbf9da0d2_5$EXT"
cp "_temp/SUPER MARIO 64#0D09F13E#0#2_all$EXT" "$PORT/Areas/Castle Outside/Window/tex1_64x32_d96664dce78ff1a6_5$EXT"
cp "_temp/SUPER MARIO 64#0FDD80CA#0#2_all$EXT" "$PORT/Areas/Castle Outside/Window/tex1_64x32_ceb73c3910a50fee_5$EXT"

cp "_temp/SUPER MARIO 64#5AC90B8D#0#2_all$EXT" "$PORT/Areas/Cavern of the Metal Cap/tex1_64x16_4a1a4bda99f919fc_5$EXT"
cp "_temp/SUPER MARIO 64#A055E62E#0#2_all$EXT" "$PORT/Areas/Cavern of the Metal Cap/tex1_32x32_603bb2f0ff42ab3e_5$EXT"
cp "_temp/SUPER MARIO 64#A22A5A73#0#2_all$EXT" "$PORT/Areas/Cavern of the Metal Cap/tex1_64x32_0a2005c656ae08fd_5$EXT"
cp "_temp/SUPER MARIO 64#F22E4881#0#2_all$EXT" "$PORT/Areas/Cavern of the Metal Cap/tex1_32x32_382c59d2fabdb101_5$EXT"

cp "_temp/SUPER MARIO 64#FED5AB03#0#2_all$EXT" "$PORT/Areas/Cool Cool Mountain/unused/tex1_32x32_e42d43525748906b_5$EXT"
cp "_temp/SUPER MARIO 64#038BE28F#0#2_all$EXT" "$PORT/Areas/Cool Cool Mountain/tex1_64x32_9211d5c9bf3368a6_5$EXT"
cp "_temp/SUPER MARIO 64#130CA9A8#0#2_all$EXT" "$PORT/Areas/Cool Cool Mountain/tex1_32x32_660109e3bdcecf81_5$EXT"
cp "_temp/SUPER MARIO 64#15686BED#0#2_all$EXT" "$PORT/Areas/Cool Cool Mountain/tex1_32x4_e3b1f308a0c35ecc_5$EXT"
cp "_temp/SUPER MARIO 64#17EA3392#3#2_all$EXT" "$PORT/Areas/Cool Cool Mountain/tex1_32x32_85a57d2adb8d1925_3$EXT"
cp "_temp/SUPER MARIO 64#252A4B98#3#2_all$EXT" "$PORT/Areas/Cool Cool Mountain/tex1_32x32_9f112f5efca885e6_3$EXT"
cp "_temp/SUPER MARIO 64#266A1564#0#2_all$EXT" "$PORT/Areas/Cool Cool Mountain/tex1_32x32_d5732eb5f60dde41_5$EXT"
cp "_temp/SUPER MARIO 64#3909F67D#0#2_all$EXT" "$PORT/Areas/Cool Cool Mountain/tex1_32x64_bbab1ec353d92c9e_5$EXT"
cp "_temp/SUPER MARIO 64#3FF93DA3#0#2_all$EXT" "$PORT/Areas/Cool Cool Mountain/tex1_32x32_2919fb3bb22b1ee0_5$EXT"
cp "_temp/SUPER MARIO 64#4276DB5E#0#2_all$EXT" "$PORT/Areas/Cool Cool Mountain/tex1_32x32_4a9ce556cf2e9182_5$EXT"
cp "_temp/SUPER MARIO 64#56DA6B66#0#2_all$EXT" "$PORT/Areas/Cool Cool Mountain/tex1_32x32_c9bcfb1bbd361dcf_5$EXT"
cp "_temp/SUPER MARIO 64#611B82B3#0#2_all$EXT" "$PORT/Areas/Cool Cool Mountain/tex1_32x32_3984d4c10cef2228_5$EXT"
cp "_temp/SUPER MARIO 64#6543184D#0#2_all$EXT" "$PORT/Areas/Cool Cool Mountain/tex1_32x32_ff7cf50539ef8be7_5$EXT"
cp "_temp/SUPER MARIO 64#744A7D8E#0#2_all$EXT" "$PORT/Areas/Cool Cool Mountain/tex1_32x32_fb2d74f5d517ef0e_5$EXT"
cp "_temp/SUPER MARIO 64#8299C450#0#2_all$EXT" "$PORT/Areas/Cool Cool Mountain/tex1_32x32_9b948aee85815c20_5$EXT"
cp "_temp/SUPER MARIO 64#84FED0D8#0#2_all$EXT" "$PORT/Areas/Cool Cool Mountain/tex1_32x32_35a2a5f054f541c9_5$EXT"
cp "_temp/SUPER MARIO 64#8DB2E5CA#0#2_all$EXT" "$PORT/Areas/Cool Cool Mountain/tex1_32x32_1f6326f10d3fb86e_5$EXT"
cp "_temp/SUPER MARIO 64#9678001C#0#2_all$EXT" "$PORT/Areas/Cool Cool Mountain/tex1_32x32_43446773bd862b21_5$EXT"
cp "_temp/SUPER MARIO 64#9B6B4DBC#0#2_all$EXT" "$PORT/Areas/Cool Cool Mountain/tex1_32x32_8fa444e075c90922_5$EXT"
cp "_temp/SUPER MARIO 64#9CAB9C3A#0#2_all$EXT" "$PORT/Areas/Cool Cool Mountain/tex1_32x32_6905d28a44bd9fbe_5$EXT"
cp "_temp/SUPER MARIO 64#B2718DB8#0#2_all$EXT" "$PORT/Areas/Cool Cool Mountain/tex1_32x32_f08c3c0260980ea1_5$EXT"
cp "_temp/SUPER MARIO 64#D83419B2#0#2_all$EXT" "$PORT/Areas/Cool Cool Mountain/tex1_32x32_2c98a74e311fb9a8_5$EXT"
cp "_temp/SUPER MARIO 64#E1CA8B50#0#2_all$EXT" "$PORT/Areas/Cool Cool Mountain/tex1_32x32_1ba0830e483a0567_5$EXT"
cp "_temp/SUPER MARIO 64#E8E37186#0#2_all$EXT" "$PORT/Areas/Cool Cool Mountain/tex1_32x32_e7ddd23f04ea5e19_5$EXT"
cp "_temp/SUPER MARIO 64#E9E0C62A#0#2_all$EXT" "$PORT/Areas/Cool Cool Mountain/tex1_32x32_7da9ae86c12a3df0_5$EXT"
cp "_temp/SUPER MARIO 64#F831589E#0#2_all$EXT" "$PORT/Areas/Cool Cool Mountain/tex1_32x32_e8d9a13c78e6362b_5$EXT"
cp "_temp/SUPER MARIO 64#FE55B4F9#3#2_all$EXT" "$PORT/Areas/Cool Cool Mountain/tex1_32x32_614122c35c1eff83_3$EXT"

cp "_temp/SUPER MARIO 64#164FBE11#0#2_all$EXT" "$PORT/Areas/Dire Dire Docks/Ship Room/tex1_32x32_78e4c7196bd2602e_5$EXT"
cp "_temp/SUPER MARIO 64#1D6FCB73#0#2_all$EXT" "$PORT/Areas/Dire Dire Docks/Ship Room/tex1_32x32_29b56c52dbe4de25_5$EXT"
cp "_temp/SUPER MARIO 64#7B8E447D#0#2_all$EXT" "$PORT/Areas/Dire Dire Docks/Ship Room/tex1_64x32_73ed4ad861f0e417_5$EXT"
cp "_temp/SUPER MARIO 64#F6C53A3C#0#2_all$EXT" "$PORT/Areas/Dire Dire Docks/Ship Room/tex1_32x64_f556ac16a73ca260_5$EXT"
cp "_temp/SUPER MARIO 64#1A808DA7#0#2_all$EXT" "$PORT/Areas/Dire Dire Docks/tex1_64x32_4127402062a756a8_5$EXT"
cp "_temp/SUPER MARIO 64#53C1213E#0#2_all$EXT" "$PORT/Areas/Dire Dire Docks/tex1_64x32_7e26bd5b07d14fcc_5$EXT"
cp "_temp/SUPER MARIO 64#9C0E821E#0#2_all$EXT" "$PORT/Areas/Dire Dire Docks/tex1_64x32_e17d915ebc04d05e_5$EXT"
cp "_temp/SUPER MARIO 64#C3459917#0#2_all$EXT" "$PORT/Areas/Dire Dire Docks/tex1_64x32_773fd0b23ffddcae_5$EXT"

cp "_temp/SUPER MARIO 64#65BFA19A#0#2_all$EXT" "$PORT/Areas/Hazy Maze Cave/Maps/tex1_32x64_289ac0182f79dd34_5$EXT"
cp "_temp/SUPER MARIO 64#829B7107#0#2_all$EXT" "$PORT/Areas/Hazy Maze Cave/Maps/tex1_32x64_418e5eda38ed1c6a_5$EXT"
cp "_temp/SUPER MARIO 64#FE1AB8D0#0#2_all$EXT" "$PORT/Areas/Hazy Maze Cave/Maps/tex1_32x64_e6eb5830d2f17a97_5$EXT"
cp "_temp/SUPER MARIO 64#06682E2E#0#2_all$EXT" "$PORT/Areas/Hazy Maze Cave/tex1_32x32_1eb9469cf14035e5_5$EXT"
cp "_temp/SUPER MARIO 64#304306E0#0#2_all$EXT" "$PORT/Areas/Hazy Maze Cave/tex1_32x64_7b530209b927fc19_5$EXT"
cp "_temp/SUPER MARIO 64#33C58D86#0#2_all$EXT" "$PORT/Areas/Hazy Maze Cave/tex1_32x64_cc4440cdabbd9353_5$EXT"
cp "_temp/SUPER MARIO 64#36F00556#0#2_all$EXT" "$PORT/Areas/Hazy Maze Cave/tex1_32x64_a467c0806c62f433_5$EXT"
cp "_temp/SUPER MARIO 64#3E40E693#0#2_all$EXT" "$PORT/Areas/Hazy Maze Cave/tex1_32x64_8a6bba1d9e1ddd4b_5$EXT"
cp "_temp/SUPER MARIO 64#40FA0DCA#0#2_all$EXT" "$PORT/Areas/Hazy Maze Cave/tex1_32x64_af0a69f1bc0b046a_5$EXT"
cp "_temp/SUPER MARIO 64#4E6ECA8D#0#2_all$EXT" "$PORT/Areas/Hazy Maze Cave/tex1_32x32_abd8aa5d567e6d14_5$EXT"
cp "_temp/SUPER MARIO 64#4ED23BE0#0#2_all$EXT" "$PORT/Areas/Hazy Maze Cave/tex1_32x64_3f962fc6241ab998_5$EXT"
cp "_temp/SUPER MARIO 64#6A925357#0#2_all$EXT" "$PORT/Areas/Hazy Maze Cave/tex1_32x32_2990fcf419933a7d_5$EXT"
cp "_temp/SUPER MARIO 64#6BEFEDB8#0#2_all$EXT" "$PORT/Areas/Hazy Maze Cave/tex1_32x32_6de9ce691cb036ff_5$EXT"
cp "_temp/SUPER MARIO 64#7F9CCD83#0#2_all$EXT" "$PORT/Areas/Hazy Maze Cave/tex1_32x32_9030a0fae68c997e_5$EXT"
cp "_temp/SUPER MARIO 64#8D2F37B0#0#2_all$EXT" "$PORT/Areas/Hazy Maze Cave/tex1_32x32_f6b486fcf34c40c0_5$EXT"
cp "_temp/SUPER MARIO 64#92F79940#0#2_all$EXT" "$PORT/Areas/Hazy Maze Cave/tex1_32x32_d6198e2b22647ea9_5$EXT"
cp "_temp/SUPER MARIO 64#97E53259#0#2_all$EXT" "$PORT/Areas/Hazy Maze Cave/tex1_32x64_02ce95b4d8e6c7ed_5$EXT"
cp "_temp/SUPER MARIO 64#9B4BEFB8#0#2_all$EXT" "$PORT/Areas/Hazy Maze Cave/tex1_64x32_07696a2e59ca7882_5$EXT"
cp "_temp/SUPER MARIO 64#BE04CE2E#0#2_all$EXT" "$PORT/Areas/Hazy Maze Cave/tex1_32x32_73a92c4c13903a74_5$EXT"
cp "_temp/SUPER MARIO 64#C199118A#0#2_all$EXT" "$PORT/Areas/Hazy Maze Cave/tex1_32x64_15bdb0dc5a8b7703_5$EXT"
cp "_temp/SUPER MARIO 64#D951B3DA#0#2_all$EXT" "$PORT/Areas/Hazy Maze Cave/tex1_32x32_5d4977dfa8472c2a_5$EXT"
cp "_temp/SUPER MARIO 64#E56F0BBF#0#2_all$EXT" "$PORT/Areas/Hazy Maze Cave/tex1_32x32_463eae65d5cd8569_5$EXT"

cp "_temp/SUPER MARIO 64#1B6ACD5E#0#2_all$EXT" "$PORT/Areas/Jolly Roger Bay/Chest/tex1_64x32_ac1e0c8baa9f7a0d_5$EXT"
cp "_temp/SUPER MARIO 64#87D447AF#0#2_all$EXT" "$PORT/Areas/Jolly Roger Bay/Chest/tex1_32x32_7250f5c2b3dea285_5$EXT"
cp "_temp/SUPER MARIO 64#8F698CC1#0#2_all$EXT" "$PORT/Areas/Jolly Roger Bay/Chest/tex1_32x32_325b893320af4bc0_5$EXT"
cp "_temp/SUPER MARIO 64#E60FFD91#0#2_all$EXT" "$PORT/Areas/Jolly Roger Bay/Chest/tex1_32x32_9faf7efc7b01a1d6_5$EXT"
cp "_temp/SUPER MARIO 64#4010BAE8#0#2_all$EXT" "$PORT/Areas/Jolly Roger Bay/Crate/tex1_32x32_7607ee3ab250cf61_5$EXT"
cp "_temp/SUPER MARIO 64#49997119#0#2_all$EXT" "$PORT/Areas/Jolly Roger Bay/Crate/tex1_32x32_d0622eb60dde43fa_5$EXT"
cp "_temp/SUPER MARIO 64#20E1EA4D#0#2_all$EXT" "$PORT/Areas/Jolly Roger Bay/Kelp/tex1_32x32_856f4a7208595b55_5$EXT"
cp "_temp/SUPER MARIO 64#513BD6B7#0#2_all$EXT" "$PORT/Areas/Jolly Roger Bay/Kelp/tex1_32x32_db81ccb9315e0ef2_5$EXT"
cp "_temp/SUPER MARIO 64#C989266F#0#2_all$EXT" "$PORT/Areas/Jolly Roger Bay/Kelp/tex1_32x32_1eb850b2c53846f1_5$EXT"
cp "_temp/SUPER MARIO 64#D53A754E#0#2_all$EXT" "$PORT/Areas/Jolly Roger Bay/Kelp/tex1_32x32_2bafd4b3d47dc508_5$EXT"
cp "_temp/SUPER MARIO 64#428BEF9C#0#2_all$EXT" "$PORT/Areas/Jolly Roger Bay/Ship/tex1_64x32_0400d62556c943c3_5$EXT"
cp "_temp/SUPER MARIO 64#579C53ED#0#2_all$EXT" "$PORT/Areas/Jolly Roger Bay/Ship/tex1_32x32_5a70a5af5f7e625f_5$EXT"
cp "_temp/SUPER MARIO 64#6108550A#0#2_all$EXT" "$PORT/Areas/Jolly Roger Bay/Ship/tex1_32x32_07139e6193dc18de_5$EXT"
cp "_temp/SUPER MARIO 64#6879F1F6#0#2_all$EXT" "$PORT/Areas/Jolly Roger Bay/Ship/tex1_64x32_fa383592e2e9deef_5$EXT"
cp "_temp/SUPER MARIO 64#B5135C61#0#2_all$EXT" "$PORT/Areas/Jolly Roger Bay/Ship/tex1_32x32_0717eaf8bbaf3368_5$EXT"
cp "_temp/SUPER MARIO 64#2B644522#0#2_all$EXT" "$PORT/Areas/Jolly Roger Bay/tex1_64x32_096c4bf5900cf822_5$EXT"
cp "_temp/SUPER MARIO 64#4A0AF053#3#2_all$EXT" "$PORT/Areas/Jolly Roger Bay/tex1_32x32_612ff9b88ed4ee9f_3$EXT"
cp "_temp/SUPER MARIO 64#5C403031#0#2_all$EXT" "$PORT/Areas/Jolly Roger Bay/tex1_64x32_bf6f98e4e4daec9c_5$EXT"
cp "_temp/SUPER MARIO 64#775A5057#0#2_all$EXT" "$PORT/Areas/Jolly Roger Bay/tex1_64x32_6f2a35efb1533ded_5$EXT"
cp "_temp/SUPER MARIO 64#7E28666B#0#2_all$EXT" "$PORT/Areas/Jolly Roger Bay/tex1_64x32_671c0a2a29c585e1_5$EXT"
cp "_temp/SUPER MARIO 64#A1AE1A01#0#2_all$EXT" "$PORT/Areas/Jolly Roger Bay/tex1_64x32_ee8c5d057ca2b6b3_5$EXT"
cp "_temp/SUPER MARIO 64#C5E87355#0#2_all$EXT" "$PORT/Areas/Jolly Roger Bay/tex1_64x32_a57768fc79b64fb2_5$EXT"
cp "_temp/SUPER MARIO 64#E3C3F224#0#2_all$EXT" "$PORT/Areas/Jolly Roger Bay/tex1_32x32_725faf20e5db716a_5$EXT"
cp "_temp/SUPER MARIO 64#FEBEDAE8#0#2_all$EXT" "$PORT/Areas/Jolly Roger Bay/tex1_32x32_45514ae7919b0390_5$EXT"

cp "_temp/SUPER MARIO 64#36FC4C04#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/Bowser/tex1_32x32_bfafd949f101c6c7_5$EXT"
cp "_temp/SUPER MARIO 64#46A556F1#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/Bowser/tex1_32x32_60e9dec55487e331_5$EXT"
cp "_temp/SUPER MARIO 64#4A750285#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/Bowser/tex1_32x32_e2e84f3fe860cc1d_5$EXT"
cp "_temp/SUPER MARIO 64#4E0A3338#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/Bowser/tex1_32x32_6dcb8ec952d15b01_5$EXT"
cp "_temp/SUPER MARIO 64#6541DD48#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/Bowser/tex1_32x32_f4ded582fb66d31b_5$EXT"
cp "_temp/SUPER MARIO 64#7323E612#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/Bowser/tex1_32x32_6ce4d2a8c90dd003_5$EXT"
cp "_temp/SUPER MARIO 64#A804C734#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/Bowser/tex1_32x32_a8491685ef7a17b2_5$EXT"
cp "_temp/SUPER MARIO 64#BBCA6538#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/Bowser/tex1_32x32_a46cb040535b6f27_5$EXT"
cp "_temp/SUPER MARIO 64#C64AD046#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/Bowser/tex1_32x32_70a5771b610810ef_5$EXT"
cp "_temp/SUPER MARIO 64#CCFDAE7D#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/Bowser/tex1_32x32_088575b00c14b13c_5$EXT"
cp "_temp/SUPER MARIO 64#D9E8F2F0#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/Bowser/tex1_32x32_97361c1b722a1aee_5$EXT"
cp "_temp/SUPER MARIO 64#EA11FB10#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/Bowser/tex1_32x32_5818f0fc0222a10c_5$EXT"
cp "_temp/SUPER MARIO 64#F6AFFEC8#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/Bowser/tex1_32x32_58b5e6ac4a21c29d_5$EXT"
cp "_temp/SUPER MARIO 64#F71BCBCA#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/Bowser/tex1_32x32_ccec014fe6f711e5_5$EXT"
cp "_temp/SUPER MARIO 64#E3F0759B#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/unused/tex1_32x32_d76624a951a19345_5$EXT"
cp "_temp/SUPER MARIO 64#144C8CF3#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/Volcano/tex1_32x32_3975fe0b5f436ee3_5$EXT"
cp "_temp/SUPER MARIO 64#1541A06E#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/Volcano/tex1_32x32_036db11fbe6eec88_5$EXT"
cp "_temp/SUPER MARIO 64#63F6E568#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/Volcano/tex1_16x16_bfbda3d2c11b472c_5$EXT"
cp "_temp/SUPER MARIO 64#6A748651#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/Volcano/tex1_32x32_24e73f9fd6044701_5$EXT"
cp "_temp/SUPER MARIO 64#7AE8E843#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/Volcano/tex1_32x32_3cfb8a2e95cc70ee_5$EXT"
cp "_temp/SUPER MARIO 64#7CFB23B0#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/Volcano/tex1_32x32_a7e2b31d7b899233_5$EXT"
cp "_temp/SUPER MARIO 64#8F25C650#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/Volcano/tex1_64x16_3c435d6ccc589e1e_5$EXT"
cp "_temp/SUPER MARIO 64#0B962372#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/tex1_32x32_c8032571eff608c8_5$EXT"
cp "_temp/SUPER MARIO 64#10675A01#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/tex1_32x32_5470ac88b6348e9f_5$EXT"
cp "_temp/SUPER MARIO 64#10E452C9#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/tex1_32x32_80c878848856532c_5$EXT"
cp "_temp/SUPER MARIO 64#1ECB06AF#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/tex1_32x32_a02efc296e702b7a_5$EXT"
cp "_temp/SUPER MARIO 64#2A83D55A#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/tex1_32x32_846ae8cb4d892738_5$EXT"
cp "_temp/SUPER MARIO 64#2EA7C781#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/tex1_32x32_a962901cdad4f58e_5$EXT"
cp "_temp/SUPER MARIO 64#3A9A3561#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/tex1_32x32_da929b0260bc07ab_5$EXT"
cp "_temp/SUPER MARIO 64#40568542#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/tex1_32x32_08eff707ab610dce_5$EXT"
cp "_temp/SUPER MARIO 64#508E888F#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/tex1_32x32_659501bfc26e2716_5$EXT"
cp "_temp/SUPER MARIO 64#52BC0E5E#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/tex1_32x32_4d5b50c7890f9ba2_5$EXT"
cp "_temp/SUPER MARIO 64#5996660E#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/tex1_32x32_9559169e0291e56a_5$EXT"
cp "_temp/SUPER MARIO 64#5D3DF26F#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/tex1_32x32_e27bbb774a0a53c1_5$EXT"
cp "_temp/SUPER MARIO 64#6626C09A#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/tex1_32x32_4a462ffea9667a6e_5$EXT"
cp "_temp/SUPER MARIO 64#6FA30457#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/tex1_32x32_a0238fcf41e4fb54_5$EXT"
cp "_temp/SUPER MARIO 64#746A5D31#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/tex1_32x32_d74c8c35e14ecb17_5$EXT"
cp "_temp/SUPER MARIO 64#7ECF9E44#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/tex1_32x32_836646481e2b0829_5$EXT"
cp "_temp/SUPER MARIO 64#810A6136#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/tex1_32x32_7a5e503b352bcc30_5$EXT"
cp "_temp/SUPER MARIO 64#82B146CD#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/tex1_32x32_3f4ad91c61213485_5$EXT"
cp "_temp/SUPER MARIO 64#945943B1#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/tex1_32x32_925df9675d5f4c17_5$EXT"
cp "_temp/SUPER MARIO 64#9A729C51#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/tex1_32x32_784d684137fdb981_5$EXT"
cp "_temp/SUPER MARIO 64#A808D20A#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/tex1_32x32_da8463cd70be5313_5$EXT"
cp "_temp/SUPER MARIO 64#B1386A2E#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/tex1_32x32_c22c8c1d3175b552_5$EXT"
cp "_temp/SUPER MARIO 64#B50DE959#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/tex1_32x32_01f4bd143739041d_5$EXT"
cp "_temp/SUPER MARIO 64#BA6D7331#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/tex1_32x32_50e4190295559d42_5$EXT"
cp "_temp/SUPER MARIO 64#C0BCCCF4#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/tex1_32x32_e87fbeb6cf5493b1_5$EXT"
cp "_temp/SUPER MARIO 64#C518BF93#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/tex1_32x32_5eb36dc314a43012_5$EXT"
cp "_temp/SUPER MARIO 64#C6B026AA#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/tex1_32x32_1a5584b3c2bdacbb_5$EXT"
cp "_temp/SUPER MARIO 64#D494EB3B#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/tex1_32x32_000c094e5b976eaf_5$EXT"
cp "_temp/SUPER MARIO 64#E2E864A2#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/tex1_32x32_3742716d6d9b76eb_5$EXT"
cp "_temp/SUPER MARIO 64#E42D6AA8#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/tex1_32x32_5409790f3212ec99_5$EXT"
cp "_temp/SUPER MARIO 64#E49DCFB8#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/tex1_32x32_c7af5c421f85e7df_5$EXT"
cp "_temp/SUPER MARIO 64#F4D429FD#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/tex1_32x32_5210d964c8ee620a_5$EXT"

cp "_temp/SUPER MARIO 64#32169E73#0#2_all$EXT" "$PORT/Areas/Rainbow Ride/tex1_64x32_b92262c9b2676b54_5$EXT"
cp "_temp/SUPER MARIO 64#4676F47D#0#2_all$EXT" "$PORT/Areas/Rainbow Ride/tex1_32x32_3beb2ab87d336dca_5$EXT"
cp "_temp/SUPER MARIO 64#83101FA2#0#2_all$EXT" "$PORT/Areas/Rainbow Ride/tex1_32x32_1fdf3df1c59359f2_5$EXT"

cp "_temp/SUPER MARIO 64#1CB6E388#0#2_all$EXT" "$PORT/Areas/Shifting Sand Land/Block/tex1_32x64_ff63808ac4c41d7b_5$EXT"
cp "_temp/SUPER MARIO 64#325A3830#0#2_all$EXT" "$PORT/Areas/Shifting Sand Land/Block/tex1_32x32_c0eadfd4441e0c6d_5$EXT"
cp "_temp/SUPER MARIO 64#D5B932A2#0#2_all$EXT" "$PORT/Areas/Shifting Sand Land/Block/tex1_32x64_01337cb17dbe226e_5$EXT"
cp "_temp/SUPER MARIO 64#ECE06C79#0#2_all$EXT" "$PORT/Areas/Shifting Sand Land/Block/tex1_32x64_25ed538804f5972c_5$EXT"
cp "_temp/SUPER MARIO 64#5AF9DFDE#0#2_all$EXT" "$PORT/Areas/Shifting Sand Land/Pyramid/tex1_32x32_1b1065fc133aa305_5$EXT"
cp "_temp/SUPER MARIO 64#85204772#0#2_all$EXT" "$PORT/Areas/Shifting Sand Land/Pyramid/tex1_32x32_02dd4dc8476dceb0_5$EXT"
cp "_temp/SUPER MARIO 64#F3CC9E98#0#2_all$EXT" "$PORT/Areas/Shifting Sand Land/Pyramid/tex1_32x32_a39648c67b7d0a13_5$EXT"
cp "_temp/SUPER MARIO 64#3ECBD5D1#0#2_all$EXT" "$PORT/Areas/Shifting Sand Land/unused/tex1_32x32_7d29c79fc4e6c98a_5$EXT"
cp "_temp/SUPER MARIO 64#B99A9F71#0#2_all$EXT" "$PORT/Areas/Shifting Sand Land/unused/tex1_32x32_60c8441780e31096_5$EXT"
cp "_temp/SUPER MARIO 64#04A35759#0#2_all$EXT" "$PORT/Areas/Shifting Sand Land/tex1_32x32_4b53e846d14461ea_5$EXT"
cp "_temp/SUPER MARIO 64#09208466#0#2_all$EXT" "$PORT/Areas/Shifting Sand Land/tex1_32x32_8509937029a8cff3_5$EXT"
cp "_temp/SUPER MARIO 64#1F6DA0F2#3#2_all$EXT" "$PORT/Areas/Shifting Sand Land/tex1_32x32_525fd5a871aba14f_3$EXT"
cp "_temp/SUPER MARIO 64#60AA80AA#0#2_all$EXT" "$PORT/Areas/Shifting Sand Land/tex1_32x32_a96b67a5cd152949_5$EXT"
cp "_temp/SUPER MARIO 64#6DCA9CD5#0#2_all$EXT" "$PORT/Areas/Shifting Sand Land/tex1_32x32_40e042d4a9c7fda5_5$EXT"
cp "_temp/SUPER MARIO 64#7F832C86#0#2_all$EXT" "$PORT/Areas/Shifting Sand Land/tex1_32x32_b43de75be4111b4d_5$EXT"
cp "_temp/SUPER MARIO 64#8B50E442#0#2_all$EXT" "$PORT/Areas/Shifting Sand Land/tex1_32x32_fb5c8668cfdecd56_5$EXT"
cp "_temp/SUPER MARIO 64#A3DA7F18#0#2_all$EXT" "$PORT/Areas/Shifting Sand Land/tex1_32x32_7ff8f6a4f70682d7_5$EXT"
cp "_temp/SUPER MARIO 64#C6028757#0#2_all$EXT" "$PORT/Areas/Shifting Sand Land/tex1_32x32_d10284e3e8e0b1ff_5$EXT"

cp "_temp/SUPER MARIO 64#1FC70576#0#2_all$EXT" "$PORT/Areas/Snowman's Land/tex1_32x32_d26df8a0ce166df5_5$EXT"
cp "_temp/SUPER MARIO 64#6CF04010#0#2_all$EXT" "$PORT/Areas/Snowman's Land/tex1_32x32_69893ccc1650d2f3_5$EXT"
cp "_temp/SUPER MARIO 64#783B816B#0#2_all$EXT" "$PORT/Areas/Snowman's Land/tex1_32x32_a8018033869c3b9a_5$EXT"
cp "_temp/SUPER MARIO 64#DA375BA5#0#2_all$EXT" "$PORT/Areas/Snowman's Land/tex1_32x32_88381370ad741fb2_5$EXT"

cp "_temp/SUPER MARIO 64#07CF15A6#0#2_all$EXT" "$PORT/Areas/Tall Tall Mountain/Slide/tex1_32x32_f1bf73dfd432409e_5$EXT"
cp "_temp/SUPER MARIO 64#27B29129#0#2_all$EXT" "$PORT/Areas/Tall Tall Mountain/Slide/tex1_64x32_1666fb01895b22c0_5$EXT"
cp "_temp/SUPER MARIO 64#5CFEB1DB#0#2_all$EXT" "$PORT/Areas/Tall Tall Mountain/Slide/tex1_64x32_aa27d8dd68690b23_5$EXT"
cp "_temp/SUPER MARIO 64#76E8D87C#0#2_all$EXT" "$PORT/Areas/Tall Tall Mountain/Slide/tex1_32x32_e7a09bb87e4eaf26_5$EXT"
cp "_temp/SUPER MARIO 64#8F523EF1#0#2_all$EXT" "$PORT/Areas/Tall Tall Mountain/Slide/tex1_32x32_7ed12a7fde49d2f1_5$EXT"
cp "_temp/SUPER MARIO 64#D1C5DE12#0#2_all$EXT" "$PORT/Areas/Tall Tall Mountain/Slide/tex1_32x32_16b3eac6f271ed76_5$EXT"
cp "_temp/SUPER MARIO 64#D4E4F405#0#2_all$EXT" "$PORT/Areas/Tall Tall Mountain/Slide/tex1_32x32_de23539348f8a749_5$EXT"
cp "_temp/SUPER MARIO 64#E383FD85#0#2_all$EXT" "$PORT/Areas/Tall Tall Mountain/Slide/tex1_32x32_2501a9c9df8e5657_5$EXT"
cp "_temp/SUPER MARIO 64#B4CAD4F7#0#2_all$EXT" "$PORT/Areas/Tall Tall Mountain/Slide/tex1_32x32_c775af6fb37df9c1_5$EXT"
cp "_temp/SUPER MARIO 64#167CAC52#0#2_all$EXT" "$PORT/Areas/Tall Tall Mountain/Slide Entrance/tex1_64x32_fe020ddfbaf73f8a_5$EXT"
cp "_temp/SUPER MARIO 64#69553F79#0#2_all$EXT" "$PORT/Areas/Tall Tall Mountain/Slide Entrance/tex1_64x32_d4074d78e236fc9a_5$EXT"
cp "_temp/SUPER MARIO 64#08758CDE#0#2_all$EXT" "$PORT/Areas/Tall Tall Mountain/tex1_32x32_75c14c80f02c0db4_5$EXT"
cp "_temp/SUPER MARIO 64#13E4332A#0#2_all$EXT" "$PORT/Areas/Tall Tall Mountain/tex1_32x32_a92379568690290b_5$EXT"
cp "_temp/SUPER MARIO 64#1660C971#3#2_all$EXT" "$PORT/Areas/Tall Tall Mountain/tex1_32x32_c2582bee641a1295_3$EXT"
cp "_temp/SUPER MARIO 64#1F3B7ABC#0#2_all$EXT" "$PORT/Areas/Tall Tall Mountain/tex1_32x32_29e1e1452a4dba9e_5$EXT"
cp "_temp/SUPER MARIO 64#28061018#0#2_all$EXT" "$PORT/Areas/Tall Tall Mountain/tex1_32x32_676b9d4f031600eb_5$EXT"
cp "_temp/SUPER MARIO 64#51762E4C#0#2_all$EXT" "$PORT/Areas/Tall Tall Mountain/tex1_32x32_2bc2bf66bf3e5c58_5$EXT"
cp "_temp/SUPER MARIO 64#B401E19F#0#2_all$EXT" "$PORT/Areas/Tall Tall Mountain/tex1_32x32_21b6904e440de82c_5$EXT"
cp "_temp/SUPER MARIO 64#B59D468A#0#2_all$EXT" "$PORT/Areas/Tall Tall Mountain/tex1_32x32_da60f2ded72fdd03_5$EXT"
cp "_temp/SUPER MARIO 64#C072C80F#0#2_all$EXT" "$PORT/Areas/Tall Tall Mountain/tex1_32x32_c422978459c75e6c_5$EXT"
cp "_temp/SUPER MARIO 64#D41593D8#0#2_all$EXT" "$PORT/Areas/Tall Tall Mountain/tex1_32x32_4aee52996542c71b_5$EXT"
cp "_temp/SUPER MARIO 64#DD432C19#3#2_all$EXT" "$PORT/Areas/Tall Tall Mountain/tex1_32x32_ee77865476502ec5_3$EXT"
cp "_temp/SUPER MARIO 64#F8D78296#0#2_all$EXT" "$PORT/Areas/Tall Tall Mountain/tex1_32x32_3e7e8778a688e819_5$EXT"

cp "_temp/SUPER MARIO 64#403C6122#0#2_all$EXT" "$PORT/Areas/The Princess's Secret Slide/tex1_32x32_d43ac0cc47fae959_5$EXT"
cp "_temp/SUPER MARIO 64#4C001AD4#0#2_all$EXT" "$PORT/Areas/The Princess's Secret Slide/tex1_32x32_269cb714d9f66c7a_5$EXT"
cp "_temp/SUPER MARIO 64#7A1B62B1#0#2_all$EXT" "$PORT/Areas/The Princess's Secret Slide/tex1_32x32_e015f9c5744f8847_5$EXT"
cp "_temp/SUPER MARIO 64#9FA96B1F#0#2_all$EXT" "$PORT/Areas/The Princess's Secret Slide/tex1_32x64_9860cfc63b58c327_5$EXT"
cp "_temp/SUPER MARIO 64#D0AB7F94#0#2_all$EXT" "$PORT/Areas/The Princess's Secret Slide/tex1_32x64_a7e1ad22f7376ae1_5$EXT"
cp "_temp/SUPER MARIO 64#D1F883F5#0#2_all$EXT" "$PORT/Areas/The Princess's Secret Slide/tex1_32x32_3c09aa7a0f1068c8_5$EXT"
cp "_temp/SUPER MARIO 64#D795FE9F#0#2_all$EXT" "$PORT/Areas/The Princess's Secret Slide/tex1_32x32_ce2a6215c3c5c6ff_5$EXT"
cp "_temp/SUPER MARIO 64#F902B80B#0#2_all$EXT" "$PORT/Areas/The Princess's Secret Slide/tex1_32x32_bec77e487bd3737a_5$EXT"

cp "_temp/SUPER MARIO 64#0110314C#0#2_all$EXT" "$PORT/Areas/Tick Tock Clock/tex1_32x32_b696e6d24a5cc4e0_5$EXT"
cp "_temp/SUPER MARIO 64#19BB64C1#0#2_all$EXT" "$PORT/Areas/Tick Tock Clock/tex1_32x32_d86adf76f6bcd12e_5$EXT"
cp "_temp/SUPER MARIO 64#1C3B41CF#0#2_all$EXT" "$PORT/Areas/Tick Tock Clock/tex1_32x32_5539c3dc05a7447c_5$EXT"
cp "_temp/SUPER MARIO 64#1F5B1636#0#2_all$EXT" "$PORT/Areas/Tick Tock Clock/tex1_32x32_76dfd001ab64189d_5$EXT"
cp "_temp/SUPER MARIO 64#39E470DD#0#2_all$EXT" "$PORT/Areas/Tick Tock Clock/tex1_32x32_190eecbef69c87da_5$EXT"
cp "_temp/SUPER MARIO 64#41304ACC#0#2_all$EXT" "$PORT/Areas/Tick Tock Clock/tex1_16x64_3f4c6f1c0156acc3_5$EXT"
cp "_temp/SUPER MARIO 64#48B717EE#0#2_all$EXT" "$PORT/Areas/Tick Tock Clock/tex1_16x64_2b43d57f74eb886a_5$EXT"
cp "_temp/SUPER MARIO 64#4C26A305#0#2_all$EXT" "$PORT/Areas/Tick Tock Clock/tex1_32x32_c0f5e70176afe72a_5$EXT"
cp "_temp/SUPER MARIO 64#52F9E748#0#2_all$EXT" "$PORT/Areas/Tick Tock Clock/tex1_32x32_973d1d18a0841b13_5$EXT"
cp "_temp/SUPER MARIO 64#57C29C7D#0#2_all$EXT" "$PORT/Areas/Tick Tock Clock/tex1_32x32_68010143410f2020_5$EXT"
cp "_temp/SUPER MARIO 64#6E3243F8#0#2_all$EXT" "$PORT/Areas/Tick Tock Clock/tex1_32x32_3146ae46c3959f6e_5$EXT"
cp "_temp/SUPER MARIO 64#79D25AFB#0#2_all$EXT" "$PORT/Areas/Tick Tock Clock/tex1_32x32_b685357c67dc7eef_5$EXT"
cp "_temp/SUPER MARIO 64#83D5BA14#0#2_all$EXT" "$PORT/Areas/Tick Tock Clock/tex1_32x64_e32f516308007519_5$EXT"
cp "_temp/SUPER MARIO 64#86FB0C9F#0#2_all$EXT" "$PORT/Areas/Tick Tock Clock/tex1_32x32_c880f7adff9344a5_5$EXT"
cp "_temp/SUPER MARIO 64#88654139#0#2_all$EXT" "$PORT/Areas/Tick Tock Clock/tex1_32x32_9589d8148434a278_5$EXT"
cp "_temp/SUPER MARIO 64#933C8F9C#0#2_all$EXT" "$PORT/Areas/Tick Tock Clock/tex1_32x32_c832ad31259d3cc6_5$EXT"
cp "_temp/SUPER MARIO 64#C9524EEE#0#2_all$EXT" "$PORT/Areas/Tick Tock Clock/tex1_64x8_cd8b3adb1aa003f3_5$EXT"
cp "_temp/SUPER MARIO 64#D872CF6B#0#2_all$EXT" "$PORT/Areas/Tick Tock Clock/tex1_32x32_1f90d82d47e14f43_5$EXT"
cp "_temp/SUPER MARIO 64#FF00D1BF#0#2_all$EXT" "$PORT/Areas/Tick Tock Clock/tex1_32x32_696fdc737737b65b_5$EXT"

cp "_temp/SUPER MARIO 64#5C3873C6#0#2_all$EXT" "$PORT/Areas/Tiny-Huge Island/tex1_32x32_5d26e2796463377d_5$EXT"
cp "_temp/SUPER MARIO 64#60DD36F6#0#2_all$EXT" "$PORT/Areas/Tiny-Huge Island/tex1_32x32_36d521aaf3b67f19_5$EXT"
cp "_temp/SUPER MARIO 64#6F5155BA#0#2_all$EXT" "$PORT/Areas/Tiny-Huge Island/Wiggler's Cave/tex1_32x32_fc189cf5f253cf82_5$EXT"
cp "_temp/SUPER MARIO 64#6F5155BA#3#2_all$EXT" "$PORT/Areas/Tiny-Huge Island/tex1_32x32_cd837721c1a691f6_3$EXT"
cp "_temp/SUPER MARIO 64#CF52A490#0#2_all$EXT" "$PORT/Areas/Tiny-Huge Island/tex1_32x32_e863f29fa58b55c5_5$EXT"
cp "_temp/SUPER MARIO 64#D91DA963#0#2_all$EXT" "$PORT/Areas/Tiny-Huge Island/tex1_32x32_1c285b28ac745e70_5$EXT"
cp "_temp/SUPER MARIO 64#EB37A9B8#0#2_all$EXT" "$PORT/Areas/Tiny-Huge Island/tex1_32x32_b9fa8b6b7a6d2a1d_5$EXT"

cp "_temp/SUPER MARIO 64#20167DE7#0#2_all$EXT" "$PORT/Areas/Tower of the Wing Cap/tex1_32x64_1855f5b323c83370_5$EXT"
cp "_temp/SUPER MARIO 64#2B08F032#0#2_all$EXT" "$PORT/Areas/Tower of the Wing Cap/tex1_32x32_0ab14acbcbae7dc5_5$EXT"
cp "_temp/SUPER MARIO 64#3163AA92#0#2_all$EXT" "$PORT/Areas/Tower of the Wing Cap/tex1_32x32_4b1c6405b9bd6f0e_5$EXT"
cp "_temp/SUPER MARIO 64#A7C0A6EB#3#2_all$EXT" "$PORT/Areas/Tower of the Wing Cap/tex1_32x32_4c3e50603c760964_3$EXT"
cp "_temp/SUPER MARIO 64#E473FB5D#0#2_all$EXT" "$PORT/Areas/Tower of the Wing Cap/tex1_32x32_fecc8c0a3f9c4ca4_5$EXT"
cp "_temp/SUPER MARIO 64#EC819D1B#0#2_all$EXT" "$PORT/Areas/Tower of the Wing Cap/tex1_32x32_2d919fd01b89869d_5$EXT"

cp "_temp/SUPER MARIO 64#094B9235#0#2_all$EXT" "$PORT/Areas/Vanish Cap Under the Moat/tex1_32x64_ce78f71d41ec7fdd_5$EXT"
cp "_temp/SUPER MARIO 64#7E7433A6#0#2_all$EXT" "$PORT/Areas/Vanish Cap Under the Moat/tex1_32x32_15d38ea4f22f69da_5$EXT"
cp "_temp/SUPER MARIO 64#9066E92B#0#2_all$EXT" "$PORT/Areas/Vanish Cap Under the Moat/tex1_32x32_a3d60e8763895608_5$EXT"
cp "_temp/SUPER MARIO 64#A2F695A8#0#2_all$EXT" "$PORT/Areas/Vanish Cap Under the Moat/tex1_64x32_ced3a62dc2f737b7_5$EXT"

cp "_temp/SUPER MARIO 64#73505869#0#2_all$EXT" "$PORT/Areas/Wet-Dry World/tex1_32x32_43e8cfb2b9574774_5$EXT"
cp "_temp/SUPER MARIO 64#74141022#0#2_all$EXT" "$PORT/Areas/Wet-Dry World/tex1_32x32_621562656c1cd2cb_5$EXT"
cp "_temp/SUPER MARIO 64#9DF06E15#0#2_all$EXT" "$PORT/Areas/Wet-Dry World/tex1_32x32_e99c53f06c0fbc52_5$EXT"
cp "_temp/SUPER MARIO 64#AF89C8F8#0#2_all$EXT" "$PORT/Areas/Wet-Dry World/tex1_32x32_7f89fe1dd2bde452_5$EXT"
cp "_temp/SUPER MARIO 64#CC57ADE9#0#2_all$EXT" "$PORT/Areas/Wet-Dry World/tex1_32x32_192376452f66632c_5$EXT"
cp "_temp/SUPER MARIO 64#DCF4DE07#0#2_all$EXT" "$PORT/Areas/Wet-Dry World/tex1_32x32_2c67eb6c534562c6_5$EXT"

cp "_temp/SUPER MARIO 64#01755B95#0#2_all$EXT" "$PORT/Areas/Whomp's Fortress/tex1_32x32_56be96bd1d40bbd3_5$EXT"
cp "_temp/SUPER MARIO 64#13C541EA#0#2_all$EXT" "$PORT/Areas/Whomp's Fortress/tex1_32x32_1b3027202e8c7640_5$EXT"
cp "_temp/SUPER MARIO 64#1EFFD4E0#0#2_all$EXT" "$PORT/Areas/Whomp's Fortress/tex1_32x32_2716663657570a26_5$EXT"
cp "_temp/SUPER MARIO 64#2BC420F5#0#2_all$EXT" "$PORT/Areas/Whomp's Fortress/tex1_32x32_d951d9fe509ecdd0_5$EXT"
cp "_temp/SUPER MARIO 64#49A3631E#0#2_all$EXT" "$PORT/Areas/Whomp's Fortress/tex1_32x32_27bb446586c0f26f_5$EXT"
cp "_temp/SUPER MARIO 64#4F265622#0#2_all$EXT" "$PORT/Areas/Whomp's Fortress/tex1_32x32_7d2c958f13f2e697_5$EXT"
cp "_temp/SUPER MARIO 64#53405A73#0#2_all$EXT" "$PORT/Areas/Whomp's Fortress/tex1_32x32_0f231ddbd0b2c4e9_5$EXT"
cp "_temp/SUPER MARIO 64#742FD706#0#2_all$EXT" "$PORT/Areas/Whomp's Fortress/tex1_32x32_201848ed9141c518_5$EXT"
cp "_temp/SUPER MARIO 64#79D8C749#0#2_all$EXT" "$PORT/Areas/Whomp's Fortress/tex1_32x32_088254d778b126dd_5$EXT"
cp "_temp/SUPER MARIO 64#81F9D9F5#0#2_all$EXT" "$PORT/Areas/Whomp's Fortress/tex1_32x32_0935ff75a397400c_5$EXT"
cp "_temp/SUPER MARIO 64#861DC3CF#0#2_all$EXT" "$PORT/Areas/Whomp's Fortress/tex1_32x32_86623c0a11ebda24_5$EXT"
cp "_temp/SUPER MARIO 64#93AE5517#0#2_all$EXT" "$PORT/Areas/Whomp's Fortress/tex1_32x32_7e42e6356e176016_5$EXT"
cp "_temp/SUPER MARIO 64#9B61A230#0#2_all$EXT" "$PORT/Areas/Whomp's Fortress/tex1_32x32_9bf6352431c7b108_5$EXT"
cp "_temp/SUPER MARIO 64#B1F1CC42#0#2_all$EXT" "$PORT/Areas/Whomp's Fortress/tex1_32x32_6abfb9478a726aac_5$EXT"
cp "_temp/SUPER MARIO 64#BD423336#0#2_all$EXT" "$PORT/Areas/Whomp's Fortress/tex1_32x32_c173f2a8333c66da_5$EXT"
cp "_temp/SUPER MARIO 64#D4291CF0#0#2_all$EXT" "$PORT/Areas/Whomp's Fortress/tex1_32x32_249d33fbc8f8aa62_5$EXT"
cp "_temp/SUPER MARIO 64#DC7BDE10#0#2_all$EXT" "$PORT/Areas/Whomp's Fortress/tex1_32x32_87ee59227cc2d6b1_5$EXT"
cp "_temp/SUPER MARIO 64#E61E849B#0#2_all$EXT" "$PORT/Areas/Whomp's Fortress/tex1_32x32_a18fc96683c2d2db_5$EXT"
cp "_temp/SUPER MARIO 64#E944A81B#0#2_all$EXT" "$PORT/Areas/Whomp's Fortress/tex1_32x32_61883a458206569c_5$EXT"
cp "_temp/SUPER MARIO 64#F3B23497#0#2_all$EXT" "$PORT/Areas/Whomp's Fortress/tex1_32x32_bd4c438eaf6b9b40_5$EXT"
cp "_temp/SUPER MARIO 64#F5A3113C#0#2_all$EXT" "$PORT/Areas/Whomp's Fortress/tex1_32x32_ffa0f911b0cfbb27_5$EXT"

cp "_temp/SUPER MARIO 64#04F846F7#0#2_all$EXT" "$PORT/Areas/Wing Mario Over the Rainbow/tex1_8x32_82112d7af9d46814_5$EXT"
cp "_temp/SUPER MARIO 64#2CDB87DE#0#2_all$EXT" "$PORT/Areas/Wing Mario Over the Rainbow/tex1_32x32_96a97b4a49e528ee_5$EXT"
cp "_temp/SUPER MARIO 64#33B314AF#0#2_all$EXT" "$PORT/Areas/Wing Mario Over the Rainbow/tex1_32x16_ad625984ae61313d_5$EXT"
cp "_temp/SUPER MARIO 64#51D4DA7F#0#2_all$EXT" "$PORT/Areas/Wing Mario Over the Rainbow/tex1_32x32_43b0e8b25e8e86da_5$EXT"
cp "_temp/SUPER MARIO 64#BD4BA854#0#2_all$EXT" "$PORT/Areas/Wing Mario Over the Rainbow/tex1_32x8_6bd236fac28f94fe_5$EXT"

cp "_temp/SUPER MARIO 64#1056B1F2#0#2_all$EXT" "$PORT/Boot/File Select/Hand/tex1_32x32_15545dc76904e18d_5$EXT"
cp "_temp/SUPER MARIO 64#66799DCC#0#2_all$EXT" "$PORT/Boot/File Select/Hand/tex1_32x32_c6db82e5e9af217d_5$EXT"
cp "_temp/SUPER MARIO 64#3C99819F#0#2_all$EXT" "$PORT/Boot/File Select/tex1_32x32_836def1d275880af_5$EXT"
cp "_temp/SUPER MARIO 64#431E1944#0#2_all$EXT" "$PORT/Boot/File Select/tex1_32x32_db76146c3bd8e732_5$EXT"
cp "_temp/SUPER MARIO 64#474F8A1B#0#2_all$EXT" "$PORT/Boot/File Select/tex1_32x32_450d0af584846fb0_5$EXT"
cp "_temp/SUPER MARIO 64#72CB8C7F#0#2_all$EXT" "$PORT/Boot/File Select/tex1_32x32_648061dbde0dbf89_5$EXT"
cp "_temp/SUPER MARIO 64#A34F223C#0#2_all$EXT" "$PORT/Boot/File Select/tex1_64x32_5885132439ccfb25_5$EXT"
cp "_temp/SUPER MARIO 64#E5D87CD6#0#2_all$EXT" "$PORT/Boot/File Select/tex1_32x32_9c4a47bbea55bece_5$EXT"
cp "_temp/SUPER MARIO 64#EC60ED0C#0#2_all$EXT" "$PORT/Boot/File Select/tex1_32x32_68ad9045f3246d81_5$EXT"
cp "_temp/SUPER MARIO 64#FAE4A688#0#2_all$EXT" "$PORT/Boot/File Select/tex1_64x32_2a7982a9a34d4209_5$EXT"
cp "_temp/SUPER MARIO 64#FBCB7598#0#2_all$EXT" "$PORT/Boot/File Select/tex1_32x32_fab08e74b7a04be8_5$EXT"

cp "_temp/SUPER MARIO 64#1298CA11#0#2_all$EXT" "$PORT/Boot/Logo/tex1_16x16_135953edfcfb4305_5$EXT"
cp "_temp/SUPER MARIO 64#3BA40EE9#0#2_all$EXT" "$PORT/Boot/Logo/tex1_32x32_f2953e1db7af0311_5$EXT"
cp "_temp/SUPER MARIO 64#3D51E423#0#2_all$EXT" "$PORT/Boot/Logo/tex1_16x16_7b7e01051ba82fa7_5$EXT"
cp "_temp/SUPER MARIO 64#610B81D3#0#2_all$EXT" "$PORT/Boot/Logo/tex1_128x16_084a9e6315091ad3_5$EXT"
cp "_temp/SUPER MARIO 64#B1A11E42#0#2_all$EXT" "$PORT/Boot/Logo/tex1_128x16_bed487c29312e1fa_5$EXT"
cp "_temp/SUPER MARIO 64#B2E16417#0#2_all$EXT" "$PORT/Boot/Logo/tex1_16x16_74f3c8fab7872b68_5$EXT"
cp "_temp/SUPER MARIO 64#B7C38322#0#2_all$EXT" "$PORT/Boot/Logo/tex1_32x32_7d1193da46a4b7c2_5$EXT"

cp "_temp/SUPER MARIO 64#563280BD#0#2_all$EXT" "$PORT/Boot/Press Start/Game Over/tex1_80x20_13568291b0e4860b_5$EXT"
cp "_temp/SUPER MARIO 64#75701F22#0#2_all$EXT" "$PORT/Boot/Press Start/Game Over/tex1_80x20_41958cc1e93d4107_5$EXT"
cp "_temp/SUPER MARIO 64#8ECFFABB#0#2_all$EXT" "$PORT/Boot/Press Start/Game Over/tex1_80x20_bb7b047d271b5407_5$EXT"
cp "_temp/SUPER MARIO 64#BB980031#0#2_all$EXT" "$PORT/Boot/Press Start/Game Over/tex1_80x20_8f5b14785c8b86e8_5$EXT"
cp "_temp/SUPER MARIO 64#087F8F7B#0#2_all$EXT" "$PORT/Boot/Press Start/Grey Star/tex1_32x32_af15622afcdd28f6_5$EXT"
cp "_temp/SUPER MARIO 64#188B6465#0#2_all$EXT" "$PORT/Boot/Press Start/Grey Star/tex1_32x32_c676b6833926e505_5$EXT"
cp "_temp/SUPER MARIO 64#A15FB7B8#0#2_all$EXT" "$PORT/Boot/Press Start/Grey Star/tex1_32x32_171958fc2f26db70_5$EXT"
cp "_temp/SUPER MARIO 64#D816C431#0#2_all$EXT" "$PORT/Boot/Press Start/Grey Star/tex1_32x32_5ae6cb9f9980dc44_5$EXT"
cp "_temp/SUPER MARIO 64#DEE37E88#0#2_all$EXT" "$PORT/Boot/Press Start/Grey Star/tex1_32x32_1f3f30ba13c9a3d2_5$EXT"
cp "_temp/SUPER MARIO 64#DF22EBFF#0#2_all$EXT" "$PORT/Boot/Press Start/Grey Star/tex1_32x32_f2c455e095e94648_5$EXT"
cp "_temp/SUPER MARIO 64#DFF2A421#0#2_all$EXT" "$PORT/Boot/Press Start/Grey Star/tex1_32x32_a285bfc27c109757_5$EXT"
cp "_temp/SUPER MARIO 64#E7F503AC#0#2_all$EXT" "$PORT/Boot/Press Start/Grey Star/tex1_32x32_d0309af675f01026_5$EXT"
cp "_temp/SUPER MARIO 64#0D821DF9#0#2_all$EXT" "$PORT/Boot/Press Start/Hand/tex1_32x32_325a12f6b63de2f0_5$EXT"
cp "_temp/SUPER MARIO 64#C61400EB#0#2_all$EXT" "$PORT/Boot/Press Start/Hand/tex1_32x32_bed2dd059ecfc044_5$EXT"
cp "_temp/SUPER MARIO 64#01BF1983#0#2_all$EXT" "$PORT/Boot/Press Start/Red Star/tex1_32x32_370a4a17c6419edc_5$EXT"
cp "_temp/SUPER MARIO 64#02040B88#0#2_all$EXT" "$PORT/Boot/Press Start/Red Star/tex1_32x32_ddbe2370432d3df4_5$EXT"
cp "_temp/SUPER MARIO 64#1F31633F#0#2_all$EXT" "$PORT/Boot/Press Start/Red Star/tex1_32x32_cfe6f21a62c6cabf_5$EXT"
cp "_temp/SUPER MARIO 64#531BEBD4#0#2_all$EXT" "$PORT/Boot/Press Start/Red Star/tex1_32x32_06a15d0cc854cbea_5$EXT"
cp "_temp/SUPER MARIO 64#686C2F97#0#2_all$EXT" "$PORT/Boot/Press Start/Red Star/tex1_32x32_564d28e207308669_5$EXT"
cp "_temp/SUPER MARIO 64#934DC3B3#0#2_all$EXT" "$PORT/Boot/Press Start/Red Star/tex1_32x32_51a30c76998fc9e7_5$EXT"
cp "_temp/SUPER MARIO 64#D04A00D5#0#2_all$EXT" "$PORT/Boot/Press Start/Red Star/tex1_32x32_7fb18b96c954e32a_5$EXT"
cp "_temp/SUPER MARIO 64#D314E722#0#2_all$EXT" "$PORT/Boot/Press Start/Red Star/tex1_32x32_3f35ff0448551b6b_5$EXT"
cp "_temp/SUPER MARIO 64#17EB8CF3#0#2_all$EXT" "$PORT/Boot/Press Start/Title/tex1_80x20_b3d75304120bd87c_5$EXT"
cp "_temp/SUPER MARIO 64#530A2CF4#0#2_all$EXT" "$PORT/Boot/Press Start/Title/tex1_80x20_9f2a1fd8c14af3b5_5$EXT"
cp "_temp/SUPER MARIO 64#57A58C22#0#2_all$EXT" "$PORT/Boot/Press Start/Title/tex1_80x20_098fa545e203581f_5$EXT"
cp "_temp/SUPER MARIO 64#8B826DF7#0#2_all$EXT" "$PORT/Boot/Press Start/Title/tex1_80x20_61c1994c6c0c93b7_5$EXT"
cp "_temp/SUPER MARIO 64#16CE5DC5#3#1_all$EXT" "$PORT/Boot/Press Start/tex1_32x32_872eb13b54bd6d56_2$EXT"
cp "_temp/SUPER MARIO 64#D1500155#0#2_all$EXT" "$PORT/Boot/Press Start/tex1_80x24_f9b4c2ced4d48072_5$EXT"

cp "_temp/SUPER MARIO 64#31764A00#0#2_all$EXT" "$PORT/Characters/Amp/tex1_32x32_af4817f23a277304_5$EXT"
cp "_temp/SUPER MARIO 64#6F7DF292#0#2_all$EXT" "$PORT/Characters/Amp/tex1_32x32_e40a2801aab3cc2a_5$EXT"
cp "_temp/SUPER MARIO 64#86712A04#0#2_all$EXT" "$PORT/Characters/Amp/tex1_16x32_91122eb1badf5453_5$EXT"
cp "_temp/SUPER MARIO 64#88DC2D34#0#2_all$EXT" "$PORT/Characters/Amp/tex1_32x32_46ca0baf690bc2aa_5$EXT"

cp "_temp/SUPER MARIO 64#292E5FD8#0#2_all$EXT" "$PORT/Characters/Bob-omb/tex1_32x64_49c1b1c7cf75c389_5$EXT"
cp "_temp/SUPER MARIO 64#2ED4BA24#0#2_all$EXT" "$PORT/Characters/Bob-omb/tex1_32x32_16e3337c4c1eecc7_5$EXT"
cp "_temp/SUPER MARIO 64#35456B51#0#2_all$EXT" "$PORT/Characters/Bob-omb/tex1_32x32_d3882cb83e87832a_5$EXT"
cp "_temp/SUPER MARIO 64#38894888#0#2_all$EXT" "$PORT/Characters/Bob-omb/tex1_32x64_1fb503bc514d56d9_5$EXT"
cp "_temp/SUPER MARIO 64#585285D7#0#2_all$EXT" "$PORT/Characters/Bob-omb/tex1_32x64_d7b2bcbbfbfee396_5$EXT"
cp "_temp/SUPER MARIO 64#A71D06B9#0#2_all$EXT" "$PORT/Characters/Bob-omb/tex1_32x64_573637fa585b8832_5$EXT"

cp "_temp/SUPER MARIO 64#070E836F#0#2_all$EXT" "$PORT/Characters/Boo/tex1_32x32_2d788ddbb4a6f87d_5$EXT"
cp "_temp/SUPER MARIO 64#B11FDC36#0#2_all$EXT" "$PORT/Characters/Boo/tex1_64x32_95940093e5ed257d_5$EXT"

cp "_temp/SUPER MARIO 64#37F10A8C#0#2_all$EXT" "$PORT/Characters/Book/tex1_16x32_52c9804d955346ba_5$EXT"
cp "_temp/SUPER MARIO 64#3E5AF02C#0#2_all$EXT" "$PORT/Characters/Book/tex1_16x32_ebe957e0776b56d5_5$EXT"
cp "_temp/SUPER MARIO 64#6D083A48#0#2_all$EXT" "$PORT/Characters/Book/tex1_16x32_3ae47478f72922b9_5$EXT"
cp "_temp/SUPER MARIO 64#8073DE72#0#2_all$EXT" "$PORT/Characters/Book/tex1_32x32_fffdf23eab3dfb57_5$EXT"
cp "_temp/SUPER MARIO 64#F6BEEB24#0#2_all$EXT" "$PORT/Characters/Book/tex1_16x32_97492fe19b8fe55a_5$EXT"

cp "_temp/SUPER MARIO 64#2E0C1E02#0#2_all$EXT" "$PORT/Characters/Bowser/tex1_64x32_5f38700b4770b612_5$EXT"
cp "_temp/SUPER MARIO 64#374E253A#0#2_all$EXT" "$PORT/Characters/Bowser/tex1_64x32_79d65fe46ead1055_5$EXT"
cp "_temp/SUPER MARIO 64#386A9785#0#2_all$EXT" "$PORT/Characters/Bowser/tex1_32x32_0eebf580498022d8_5$EXT"
cp "_temp/SUPER MARIO 64#39CC9592#0#2_all$EXT" "$PORT/Characters/Bowser/tex1_64x32_ace4ac14f1f5484c_5$EXT"
cp "_temp/SUPER MARIO 64#514A29BC#0#2_all$EXT" "$PORT/Characters/Bowser/tex1_32x32_2a773323f407f99b_5$EXT"
cp "_temp/SUPER MARIO 64#55620576#0#2_all$EXT" "$PORT/Characters/Bowser/tex1_32x32_18041de1f3059844_5$EXT"
cp "_temp/SUPER MARIO 64#61AFCDD5#0#2_all$EXT" "$PORT/Characters/Bowser/tex1_32x32_790de613a47ef1ba_5$EXT"
cp "_temp/SUPER MARIO 64#6AF6B17F#0#2_all$EXT" "$PORT/Characters/Bowser/tex1_64x32_c8521fd298ecc6b1_5$EXT"
cp "_temp/SUPER MARIO 64#6B3A40A5#0#2_all$EXT" "$PORT/Characters/Bowser/tex1_64x32_3494db8e406a0474_5$EXT"
cp "_temp/SUPER MARIO 64#6E6A49EF#0#2_all$EXT" "$PORT/Characters/Bowser/tex1_32x32_e6e96fb1f6e583db_5$EXT"
cp "_temp/SUPER MARIO 64#7B84A495#0#2_all$EXT" "$PORT/Characters/Bowser/tex1_64x32_2c88e8c5424c63d3_5$EXT"
cp "_temp/SUPER MARIO 64#7EB3FE85#0#2_all$EXT" "$PORT/Characters/Bowser/tex1_32x32_3e9bf5350672b394_5$EXT"
cp "_temp/SUPER MARIO 64#8D6B1DF6#0#2_all$EXT" "$PORT/Characters/Bowser/tex1_32x64_6d92dd4577a83769_5$EXT"
cp "_temp/SUPER MARIO 64#9759DCD0#0#2_all$EXT" "$PORT/Characters/Bowser/tex1_32x64_dfc546edd4a79b40_5$EXT"
cp "_temp/SUPER MARIO 64#A0869522#0#2_all$EXT" "$PORT/Characters/Bowser/tex1_64x32_db40f006dcc4edb3_5$EXT"
cp "_temp/SUPER MARIO 64#D405BFC1#0#2_all$EXT" "$PORT/Characters/Bowser/tex1_64x32_104219a38b6259a8_5$EXT"
cp "_temp/SUPER MARIO 64#D813A5E5#0#2_all$EXT" "$PORT/Characters/Bowser/tex1_32x32_6bb53256e0c3a11c_5$EXT"
cp "_temp/SUPER MARIO 64#DAD0C429#0#2_all$EXT" "$PORT/Characters/Bowser/tex1_32x64_02eb1fa2922ca9e4_5$EXT"
cp "_temp/SUPER MARIO 64#E351CFF2#0#2_all$EXT" "$PORT/Characters/Bowser/tex1_32x64_197152ac523d7f20_5$EXT"
cp "_temp/SUPER MARIO 64#F148AE1E#0#2_all$EXT" "$PORT/Characters/Bowser/tex1_64x32_30c0790fd02cb8e9_5$EXT"

cp "_temp/SUPER MARIO 64#2DEC812E#0#2_all$EXT" "$PORT/Characters/Bubba/tex1_64x32_99c9b0262eb95416_5$EXT"
cp "_temp/SUPER MARIO 64#761B53E2#0#2_all$EXT" "$PORT/Characters/Bubba/tex1_32x32_1fcac3f8fcf679d7_5$EXT"
cp "_temp/SUPER MARIO 64#A11454A9#0#2_all$EXT" "$PORT/Characters/Bubba/tex1_32x32_b79e530a6319c451_5$EXT"
cp "_temp/SUPER MARIO 64#BF952514#0#2_all$EXT" "$PORT/Characters/Bubba/tex1_16x32_01c7fb13466ee21a_5$EXT"
cp "_temp/SUPER MARIO 64#FC53C33B#0#2_all$EXT" "$PORT/Characters/Bubba/tex1_64x32_34c61cda7d02a132_5$EXT"

cp "_temp/SUPER MARIO 64#03298536#0#2_all$EXT" "$PORT/Characters/Bullet Bill/tex1_64x32_a601c46e321bae5b_5$EXT"
cp "_temp/SUPER MARIO 64#35BBD200#0#2_all$EXT" "$PORT/Characters/Bullet Bill/tex1_64x32_908347dfc6482d3b_5$EXT"

cp "_temp/SUPER MARIO 64#09CABB08#0#2_all$EXT" "$PORT/Characters/Bully/tex1_32x64_089d0d712cb42aa4_5$EXT"
cp "_temp/SUPER MARIO 64#21247806#0#2_all$EXT" "$PORT/Characters/Bully/tex1_32x32_2ce9dc9fdefe0ae3_5$EXT"
cp "_temp/SUPER MARIO 64#36D9C81E#0#2_all$EXT" "$PORT/Characters/Bully/tex1_32x64_85e95676865dabc2_5$EXT"
cp "_temp/SUPER MARIO 64#D35575D6#0#2_all$EXT" "$PORT/Characters/Bully/tex1_16x16_79ef58e9ca83cdca_5$EXT"

cp "_temp/SUPER MARIO 64#26DFC97D#0#2_all$EXT" "$PORT/Characters/Butterfly/tex1_32x64_8f9df45cc2ee7f8a_5$EXT"

cp "_temp/SUPER MARIO 64#01A60CCD#0#2_all$EXT" "$PORT/Characters/Chain Chomp/tex1_32x32_f2693aea9e981579_5$EXT"
cp "_temp/SUPER MARIO 64#09740389#0#2_all$EXT" "$PORT/Characters/Chain Chomp/tex1_32x32_b065b91c88986f3b_5$EXT"
cp "_temp/SUPER MARIO 64#09740389#0#2_all$EXT" "$PORT/Characters/Chain Chomp/Injects/tex1_32x32_96e589e8f8b9149e_5$EXT"
cp "_temp/SUPER MARIO 64#354089BB#0#2_all$EXT" "$PORT/Characters/Chain Chomp/tex1_32x32_bd941649c2aba6b0_5$EXT"
cp "_temp/SUPER MARIO 64#354089BB#0#2_all$EXT" "$PORT/Characters/Chain Chomp/Injects/tex1_32x32_b71c9691bcca203c_5$EXT"
cp "_temp/SUPER MARIO 64#8AC74230#0#2_all$EXT" "$PORT/Characters/Chain Chomp/tex1_32x32_bfa6efd32809347d_5$EXT"
cp "_temp/SUPER MARIO 64#B267FDF0#0#2_all$EXT" "$PORT/Characters/Chain Chomp/tex1_32x32_dbe06402cd2761dd_5$EXT"
cp "_temp/SUPER MARIO 64#CB4982B2#0#2_all$EXT" "$PORT/Characters/Chain Chomp/tex1_32x32_0b09eebd795168d3_5$EXT"

cp "_temp/SUPER MARIO 64#00866B3F#0#2_all$EXT" "$PORT/Characters/Chilly Chief/tex1_32x64_4bd4d8381b134354_5$EXT"
cp "_temp/SUPER MARIO 64#B4AA0E1C#0#2_all$EXT" "$PORT/Characters/Chilly Chief/tex1_32x64_66db3a6193fa91f3_5$EXT"

cp "_temp/SUPER MARIO 64#1501AD26#0#2_all$EXT" "$PORT/Characters/Chuckya/tex1_32x64_b62e5b55779f1fb9_5$EXT"
cp "_temp/SUPER MARIO 64#33EA5D90#0#2_all$EXT" "$PORT/Characters/Chuckya/tex1_32x64_643a911ddb0cd293_5$EXT"
cp "_temp/SUPER MARIO 64#7B7A6AD1#0#2_all$EXT" "$PORT/Characters/Chuckya/tex1_32x32_b5b6d9bf545cf3ea_5$EXT"

cp "_temp/SUPER MARIO 64#679A4C71#0#2_all$EXT" "$PORT/Characters/Clam Shell/tex1_32x32_a65050be8fefdf69_5$EXT"
cp "_temp/SUPER MARIO 64#F97DC072#0#2_all$EXT" "$PORT/Characters/Clam Shell/tex1_32x32_7f9a50a240861d67_5$EXT"

cp "_temp/SUPER MARIO 64#6C902269#0#2_all$EXT" "$PORT/Characters/Dorrie/tex1_32x64_61f140f6d5220847_5$EXT"
cp "_temp/SUPER MARIO 64#FD57EA27#0#2_all$EXT" "$PORT/Characters/Dorrie/tex1_16x16_0f65cfad78524e36_5$EXT"

cp "_temp/SUPER MARIO 64#2C14636C#0#2_all$EXT" "$PORT/Characters/Eyerok/tex1_32x32_1f87bbd81805e6b8_5$EXT"
cp "_temp/SUPER MARIO 64#761E51A0#0#2_all$EXT" "$PORT/Characters/Eyerok/tex1_32x32_6cfd87e49c4aa220_5$EXT"
cp "_temp/SUPER MARIO 64#93944D54#0#2_all$EXT" "$PORT/Characters/Eyerok/tex1_32x32_f374547313f6737d_5$EXT"
cp "_temp/SUPER MARIO 64#B9299E61#0#2_all$EXT" "$PORT/Characters/Eyerok/tex1_32x32_9d9a97eaf0ee6102_5$EXT"

cp "_temp/SUPER MARIO 64#2563BF4C#0#2_all$EXT" "$PORT/Characters/Fish/tex1_32x32_f54e40caea690c01_5$EXT"
cp "_temp/SUPER MARIO 64#FD9AA14E#0#2_all$EXT" "$PORT/Characters/Fish/tex1_32x32_dadac57607924e58_5$EXT"

cp "_temp/SUPER MARIO 64#20725250#3#2_all$EXT" "$PORT/Characters/Flyguy/tex1_32x32_723ab6e9fa5fbd11_3$EXT"
cp "_temp/SUPER MARIO 64#923C687E#0#2_all$EXT" "$PORT/Characters/Flyguy/tex1_32x32_6176cd436c7626ba_5$EXT"
cp "_temp/SUPER MARIO 64#C833EF43#0#2_all$EXT" "$PORT/Characters/Flyguy/tex1_64x32_afdda9dc45785eae_5$EXT"

cp "_temp/SUPER MARIO 64#384E2A31#0#2_all$EXT" "$PORT/Characters/Goomba/tex1_32x32_4f51d31fff7fc8f3_5$EXT"
cp "_temp/SUPER MARIO 64#C6A1C158#0#2_all$EXT" "$PORT/Characters/Goomba/tex1_32x32_b48ffe3d496da4cf_5$EXT"
cp "_temp/SUPER MARIO 64#FD83B121#0#2_all$EXT" "$PORT/Characters/Goomba/tex1_32x32_42384a9d8587e2f1_5$EXT"

cp "_temp/SUPER MARIO 64#2E1EB8AA#0#2_all$EXT" "$PORT/Characters/Grindel/tex1_32x64_84fd2163d2ac7d83_5$EXT"
cp "_temp/SUPER MARIO 64#38AFCCEE#0#2_all$EXT" "$PORT/Characters/Grindel/tex1_32x32_9393c51464907f69_5$EXT"

cp "_temp/SUPER MARIO 64#0E40FA10#0#2_all$EXT" "$PORT/Characters/Heave Ho/tex1_16x16_a71d24d30fe5e0b7_5$EXT"
cp "_temp/SUPER MARIO 64#3B111D77#0#2_all$EXT" "$PORT/Characters/Heave Ho/tex1_32x32_39307025bda4147f_5$EXT"
cp "_temp/SUPER MARIO 64#6C5CC56F#0#2_all$EXT" "$PORT/Characters/Heave Ho/tex1_32x32_4205003ddba04064_5$EXT"
cp "_temp/SUPER MARIO 64#6E489603#0#2_all$EXT" "$PORT/Characters/Heave Ho/tex1_32x32_1c0961d0032d153c_5$EXT"
cp "_temp/SUPER MARIO 64#890B9632#0#2_all$EXT" "$PORT/Characters/Heave Ho/tex1_32x32_96d5c70c87abe49d_5$EXT"
cp "_temp/SUPER MARIO 64#9B650ED0#0#2_all$EXT" "$PORT/Characters/Heave Ho/tex1_64x32_cfff1609678e31a6_5$EXT"

cp "_temp/SUPER MARIO 64#0CE27CD0#0#2_all$EXT" "$PORT/Characters/Hoot/tex1_32x32_e781c39e707a47f7_5$EXT"
cp "_temp/SUPER MARIO 64#1F8B71CA#0#2_all$EXT" "$PORT/Characters/Hoot/tex1_32x32_6e062c9cf9d4de10_5$EXT"
cp "_temp/SUPER MARIO 64#9DF33CC7#0#2_all$EXT" "$PORT/Characters/Hoot/tex1_32x32_b665fee9ee972fd7_5$EXT"

cp "_temp/SUPER MARIO 64#2996CA88#0#2_all$EXT" "$PORT/Characters/King Bob-omb/tex1_16x32_332eb7baeb21a800_5$EXT"
cp "_temp/SUPER MARIO 64#808C10C2#0#2_all$EXT" "$PORT/Characters/King Bob-omb/tex1_32x64_7f16dda507258148_5$EXT"
cp "_temp/SUPER MARIO 64#886B2FF9#0#2_all$EXT" "$PORT/Characters/King Bob-omb/tex1_32x64_587893213dcacd28_5$EXT"
cp "_temp/SUPER MARIO 64#F7844A94#0#2_all$EXT" "$PORT/Characters/King Bob-omb/tex1_32x32_b6b0266d9a4147f9_5$EXT"

cp "_temp/SUPER MARIO 64#0E7107E3#0#2_all$EXT" "$PORT/Characters/Klepto/tex1_32x64_040f39cf15e9c81c_5$EXT"
cp "_temp/SUPER MARIO 64#6ABEBFF0#0#2_all$EXT" "$PORT/Characters/Klepto/tex1_32x32_06cbe3715fad93c7_5$EXT"
cp "_temp/SUPER MARIO 64#89B90233#0#2_all$EXT" "$PORT/Characters/Klepto/tex1_64x32_2c501affb06765f3_5$EXT"
cp "_temp/SUPER MARIO 64#90581231#0#2_all$EXT" "$PORT/Characters/Klepto/tex1_32x32_9c5bf0595546f9e5_5$EXT"
cp "_temp/SUPER MARIO 64#C3F5C275#0#2_all$EXT" "$PORT/Characters/Klepto/tex1_32x32_b7a0019e4dd2280e_5$EXT"

cp "_temp/SUPER MARIO 64#0D9FD7E4#0#2_all$EXT" "$PORT/Characters/Koopa/tex1_64x32_b61591ff852a5762_5$EXT"
cp "_temp/SUPER MARIO 64#29C0C7D2#0#2_all$EXT" "$PORT/Characters/Koopa/tex1_32x32_f1837aeabde19866_5$EXT"
cp "_temp/SUPER MARIO 64#3B0D1E46#0#2_all$EXT" "$PORT/Characters/Koopa/tex1_32x32_0fca3d3d3680663a_5$EXT"
cp "_temp/SUPER MARIO 64#5F035EC5#0#2_all$EXT" "$PORT/Characters/Koopa/tex1_32x32_61a669b05836988e_5$EXT"
cp "_temp/SUPER MARIO 64#62C94802#0#2_all$EXT" "$PORT/Characters/Koopa/tex1_32x32_4042e4980b5bdf61_5$EXT"
cp "_temp/SUPER MARIO 64#852361B6#0#2_all$EXT" "$PORT/Characters/Koopa/tex1_32x32_fcbea4a25bb03fe5_5$EXT"
cp "_temp/SUPER MARIO 64#86FB2F22#0#2_all$EXT" "$PORT/Characters/Koopa/tex1_32x32_23d67601b2d99cc5_5$EXT"
cp "_temp/SUPER MARIO 64#CBBC8294#0#2_all$EXT" "$PORT/Characters/Koopa/tex1_32x32_d1414920e7beb91c_5$EXT"
cp "_temp/SUPER MARIO 64#D8903B0B#0#2_all$EXT" "$PORT/Characters/Koopa/tex1_32x32_5f021b8932f1db4f_5$EXT"

cp "_temp/SUPER MARIO 64#85C9CDA3#0#2_all$EXT" "$PORT/Characters/Lakitu/unused/tex1_32x32_51d4824d5f8b72ab_5$EXT"
cp "_temp/SUPER MARIO 64#0993E63E#0#2_all$EXT" "$PORT/Characters/Lakitu/tex1_16x16_7e790ab29a2938c2_5$EXT"
cp "_temp/SUPER MARIO 64#5D617EA0#0#2_all$EXT" "$PORT/Characters/Lakitu/tex1_32x32_1ba87a699e04cceb_5$EXT"
cp "_temp/SUPER MARIO 64#77290EB2#0#2_all$EXT" "$PORT/Characters/Lakitu/tex1_32x32_de02144d660c159e_5$EXT"
cp "_temp/SUPER MARIO 64#7CE8869D#3#2_all$EXT" "$PORT/Characters/Lakitu/tex1_32x32_615516788f711d32_3$EXT"
cp "_temp/SUPER MARIO 64#DB6C3044#0#2_all$EXT" "$PORT/Characters/Lakitu/tex1_64x32_dd2bbaa13cc74f6a_5$EXT"
cp "_temp/SUPER MARIO 64#EAA27132#0#2_all$EXT" "$PORT/Characters/Lakitu/tex1_64x32_45fd2c74acdde5a0_5$EXT"

cp "_temp/SUPER MARIO 64#8213677C#0#2_all$EXT" "$PORT/Characters/Mad Piano/tex1_32x16_15379691e41074f3_5$EXT"
cp "_temp/SUPER MARIO 64#A3C0D76F#0#2_all$EXT" "$PORT/Characters/Mad Piano/tex1_32x16_e85f592be09e1ff3_5$EXT"
cp "_temp/SUPER MARIO 64#C9A1F57E#0#2_all$EXT" "$PORT/Characters/Mad Piano/tex1_32x16_e908a076d490b603_5$EXT"
cp "_temp/SUPER MARIO 64#FB38796A#0#2_all$EXT" "$PORT/Characters/Mad Piano/tex1_16x32_5c095798be8c1031_5$EXT"
cp "_temp/SUPER MARIO 64#FD6AF08F#0#2_all$EXT" "$PORT/Characters/Mad Piano/tex1_16x32_c1139d12f8ea8efd_5$EXT"

cp "_temp/SUPER MARIO 64#1203BAA7#0#2_all$EXT" "$PORT/Characters/Manta Ray/tex1_32x32_ba24c15e7d2acdaa_5$EXT"
cp "_temp/SUPER MARIO 64#8C1EBB7F#0#2_all$EXT" "$PORT/Characters/Manta Ray/tex1_32x32_0de600087450a92c_5$EXT"
cp "_temp/SUPER MARIO 64#9B42ABEA#0#2_all$EXT" "$PORT/Characters/Manta Ray/tex1_64x32_adf5b6b8e0528ad2_5$EXT"
cp "_temp/SUPER MARIO 64#D2EBC589#0#2_all$EXT" "$PORT/Characters/Manta Ray/tex1_32x64_ee3ecc02db1699a5_5$EXT"

cp "_temp/SUPER MARIO 64#BFA0470C#0#2_all$EXT" "$PORT/Characters/Mario/unused/tex1_32x64_2815373f21915307_5$EXT"
cp "_temp/SUPER MARIO 64#5F995294#0#2_all$EXT" "$PORT/Characters/Mario/unused/tex1_32x64_4af20dfd7f69bcaa_5$EXT"
cp "_temp/SUPER MARIO 64#17C50CF2#0#2_all$EXT" "$PORT/Characters/Mario/tex1_32x64_17f45136b877df68_5$EXT"
cp "_temp/SUPER MARIO 64#19442FC9#0#2_all$EXT" "$PORT/Characters/Mario/tex1_32x32_313678d4f56d8d22_5$EXT"
cp "_temp/SUPER MARIO 64#28964B59#0#2_all$EXT" "$PORT/Characters/Mario/tex1_32x32_7a4fbf52ec282373_5$EXT"
cp "_temp/SUPER MARIO 64#2BEA0A29#0#2_all$EXT" "$PORT/Characters/Mario/tex1_32x32_589c85366d329d9b_5$EXT"
cp "_temp/SUPER MARIO 64#387D6D33#0#2_all$EXT" "$PORT/Characters/Mario/tex1_32x64_a4a4bc45399ac863_5$EXT"
cp "_temp/SUPER MARIO 64#5D6B0678#0#2_all$EXT" "$PORT/Characters/Mario/tex1_32x32_a9761f89aeff28b9_5$EXT"
cp "_temp/SUPER MARIO 64#6B8D43C4#0#2_all$EXT" "$PORT/Characters/Mario/tex1_32x32_ffe2f755ca653f48_5$EXT"
cp "_temp/SUPER MARIO 64#905D3214#0#2_all$EXT" "$PORT/Characters/Mario/tex1_32x32_7f421f6fbc67e886_5$EXT"
cp "_temp/SUPER MARIO 64#9FBECEF9#0#2_all$EXT" "$PORT/Characters/Mario/tex1_32x32_134652a052a4248d_5$EXT"
cp "_temp/SUPER MARIO 64#E9FCBF74#0#2_all$EXT" "$PORT/Characters/Mario/tex1_32x32_f7a15430d7ded326_5$EXT"

cp "_temp/SUPER MARIO 64#4944D2C9#0#2_all$EXT" "$PORT/Characters/Mips/tex1_32x32_ae5fd8d0e9e83934_5$EXT"

cp "_temp/SUPER MARIO 64#968EC1C4#0#2_all$EXT" "$PORT/Characters/Moneybag/tex1_32x32_8a66b904f79115b4_5$EXT"
cp "_temp/SUPER MARIO 64#E3548182#0#2_all$EXT" "$PORT/Characters/Moneybag/tex1_64x32_f8c4e9dc1d20843f_5$EXT"

cp "_temp/SUPER MARIO 64#04A6FFC8#0#2_all$EXT" "$PORT/Characters/Monty Mole/tex1_32x32_79537607e73804ad_5$EXT"
cp "_temp/SUPER MARIO 64#06343AFC#0#2_all$EXT" "$PORT/Characters/Monty Mole/tex1_32x32_5ed0cb77ea2985d8_5$EXT"
cp "_temp/SUPER MARIO 64#21F3A705#0#2_all$EXT" "$PORT/Characters/Monty Mole/tex1_32x32_43166f1356fc019f_5$EXT"
cp "_temp/SUPER MARIO 64#3902D1B8#0#2_all$EXT" "$PORT/Characters/Monty Mole/tex1_32x32_760bb7b32d2a8d7e_5$EXT"
cp "_temp/SUPER MARIO 64#81B554A7#3#2_all$EXT" "$PORT/Characters/Monty Mole/tex1_32x32_903f4089fe1f3505_3$EXT"
cp "_temp/SUPER MARIO 64#D6096833#0#2_all$EXT" "$PORT/Characters/Monty Mole/tex1_32x32_2657c0fa52d42f9a_5$EXT"

cp "_temp/SUPER MARIO 64#2395DA7B#0#2_all$EXT" "$PORT/Characters/Mr. Blizzard/tex1_32x64_20bd35078a86d668_5$EXT"
cp "_temp/SUPER MARIO 64#5B8676CF#0#2_all$EXT" "$PORT/Characters/Mr. Blizzard/tex1_16x16_43bf398b06f77cc8_5$EXT"
cp "_temp/SUPER MARIO 64#6A4BEF91#0#2_all$EXT" "$PORT/Characters/Mr. Blizzard/tex1_32x32_0072fd0e863fb537_5$EXT"
cp "_temp/SUPER MARIO 64#88C0CCF9#0#2_all$EXT" "$PORT/Characters/Mr. Blizzard/tex1_32x64_678ce98434658646_5$EXT"
cp "_temp/SUPER MARIO 64#9D15E307#0#2_all$EXT" "$PORT/Characters/Mr. Blizzard/tex1_32x32_e20bc1c6c93c57c9_5$EXT"
cp "_temp/SUPER MARIO 64#E48F835F#0#2_all$EXT" "$PORT/Characters/Mr. Blizzard/tex1_32x32_0e8f009b4d6a1c41_5$EXT"
cp "_temp/SUPER MARIO 64#E52EE127#0#2_all$EXT" "$PORT/Characters/Mr. Blizzard/tex1_32x32_692ce0c0426176a9_5$EXT"

cp "_temp/SUPER MARIO 64#02CFD740#0#2_all$EXT" "$PORT/Characters/Mr. I/tex1_32x64_e483b7667eaeb657_5$EXT"
cp "_temp/SUPER MARIO 64#2A93AFC0#0#2_all$EXT" "$PORT/Characters/Mr. I/tex1_32x32_f8f76f00eae6b9f8_5$EXT"
cp "_temp/SUPER MARIO 64#5CC4BED3#0#2_all$EXT" "$PORT/Characters/Mr. I/tex1_32x32_a85a209934070b1d_5$EXT"
cp "_temp/SUPER MARIO 64#5DFA73AC#0#2_all$EXT" "$PORT/Characters/Mr. I/tex1_32x32_ee867b4fd1f740d9_5$EXT"
cp "_temp/SUPER MARIO 64#78A6DB75#0#2_all$EXT" "$PORT/Characters/Mr. I/tex1_32x32_97fff55c8c3f13f7_5$EXT"
cp "_temp/SUPER MARIO 64#87786913#0#2_all$EXT" "$PORT/Characters/Mr. I/tex1_32x64_3d32f4c21a733294_5$EXT"
cp "_temp/SUPER MARIO 64#A833E954#0#2_all$EXT" "$PORT/Characters/Mr. I/tex1_32x32_cef41aa58b7a9e36_5$EXT"

cp "_temp/SUPER MARIO 64#064B5C5F#0#2_all$EXT" "$PORT/Characters/Peach/Letter/tex1_32x64_3cd686a6d3eb5ecf_5$EXT"
cp "_temp/SUPER MARIO 64#AC05A9FF#3#1_all$EXT" "$PORT/Characters/Peach/Letter/tex1_64x32_638ae5c81e30ff58_2$EXT"
cp "_temp/SUPER MARIO 64#C4845A3E#0#2_all$EXT" "$PORT/Characters/Peach/Letter/tex1_32x64_d715c5e8bfc7cfe9_5$EXT"
cp "_temp/SUPER MARIO 64#03DAF3D5#0#2_all$EXT" "$PORT/Characters/Peach/tex1_32x32_f69e6c2cbee11234_5$EXT"
cp "_temp/SUPER MARIO 64#4FE1A0ED#0#2_all$EXT" "$PORT/Characters/Peach/tex1_32x32_c8a863fa8fa97684_5$EXT"
cp "_temp/SUPER MARIO 64#723EDCD4#0#2_all$EXT" "$PORT/Characters/Peach/tex1_32x32_a4b68e2fef1dc28e_5$EXT"
cp "_temp/SUPER MARIO 64#7B8E4AC2#0#2_all$EXT" "$PORT/Characters/Peach/tex1_32x32_84bb9b99f70f18d6_5$EXT"
cp "_temp/SUPER MARIO 64#7E216E16#0#2_all$EXT" "$PORT/Characters/Peach/tex1_16x16_84c9f48bb6123579_5$EXT"
cp "_temp/SUPER MARIO 64#B7C60055#0#2_all$EXT" "$PORT/Characters/Peach/tex1_16x16_563be5c249f9d571_5$EXT"
cp "_temp/SUPER MARIO 64#CC4FE796#0#2_all$EXT" "$PORT/Characters/Peach/tex1_32x32_f3e83e4409fefa90_5$EXT"
cp "_temp/SUPER MARIO 64#DBF4274C#0#2_all$EXT" "$PORT/Characters/Peach/tex1_16x16_2721c250b64509f5_5$EXT"
cp "_temp/SUPER MARIO 64#ECACF737#0#2_all$EXT" "$PORT/Characters/Peach/tex1_32x32_8238eeda8de86ee7_5$EXT"
cp "_temp/SUPER MARIO 64#F8775564#0#2_all$EXT" "$PORT/Characters/Peach/tex1_32x32_49e389725f0d488a_5$EXT"

cp "_temp/SUPER MARIO 64#6D8F004D#0#2_all$EXT" "$PORT/Characters/Penguin/unused/tex1_32x32_f9873fb963aaded9_5$EXT"
cp "_temp/SUPER MARIO 64#180BDE92#0#2_all$EXT" "$PORT/Characters/Penguin/tex1_32x32_9ed0f7cd3a1df5ba_5$EXT"
cp "_temp/SUPER MARIO 64#578AA0E9#0#2_all$EXT" "$PORT/Characters/Penguin/tex1_32x32_8c609ebec0b2707f_5$EXT"
cp "_temp/SUPER MARIO 64#6C131FEF#0#2_all$EXT" "$PORT/Characters/Penguin/tex1_32x32_1a794c5c2d921ca5_5$EXT"
cp "_temp/SUPER MARIO 64#78B59E82#0#2_all$EXT" "$PORT/Characters/Penguin/tex1_32x32_2a52a5b33bd0865c_5$EXT"
cp "_temp/SUPER MARIO 64#B2DBCCAE#0#2_all$EXT" "$PORT/Characters/Penguin/tex1_32x32_88255e81d40b0518_5$EXT"

cp "_temp/SUPER MARIO 64#29F15A68#0#2_all$EXT" "$PORT/Characters/Piranha Plant/tex1_32x32_17b47572869fc2db_5$EXT"
cp "_temp/SUPER MARIO 64#373DF028#0#2_all$EXT" "$PORT/Characters/Piranha Plant/tex1_32x32_5f0a13d2b9a592cf_5$EXT"
cp "_temp/SUPER MARIO 64#5AEA7079#0#2_all$EXT" "$PORT/Characters/Piranha Plant/tex1_32x32_7cfd50f4f70ec55a_5$EXT"
cp "_temp/SUPER MARIO 64#5BC5CA75#0#2_all$EXT" "$PORT/Characters/Piranha Plant/tex1_32x64_e0138708de598605_5$EXT"
cp "_temp/SUPER MARIO 64#85887EE4#0#2_all$EXT" "$PORT/Characters/Piranha Plant/tex1_32x32_f4d48dc697a1ee11_5$EXT"
cp "_temp/SUPER MARIO 64#C20FC383#0#2_all$EXT" "$PORT/Characters/Piranha Plant/tex1_32x32_294c8103a85bf1c9_5$EXT"
cp "_temp/SUPER MARIO 64#F66CA88B#0#2_all$EXT" "$PORT/Characters/Piranha Plant/tex1_32x64_487ec0a0bfc66522_5$EXT"

cp "_temp/SUPER MARIO 64#2F25120F#0#2_all$EXT" "$PORT/Characters/Pokey/tex1_32x32_85194df1be65233d_5$EXT"
cp "_temp/SUPER MARIO 64#36B1482F#0#2_all$EXT" "$PORT/Characters/Pokey/tex1_32x32_8de4e9d461059a83_5$EXT"
cp "_temp/SUPER MARIO 64#B8A77D4D#0#2_all$EXT" "$PORT/Characters/Pokey/tex1_32x32_4799e6c86c3034f4_5$EXT"

cp "_temp/SUPER MARIO 64#349B3BBD#0#2_all$EXT" "$PORT/Characters/Scuttlebug/tex1_32x64_302fc63706e51b2d_5$EXT"
cp "_temp/SUPER MARIO 64#55DA5D92#0#2_all$EXT" "$PORT/Characters/Scuttlebug/tex1_32x64_ca83aef1fdb9498b_5$EXT"
cp "_temp/SUPER MARIO 64#822FF6DF#0#2_all$EXT" "$PORT/Characters/Scuttlebug/tex1_32x32_d0a3c8d324981723_5$EXT"
cp "_temp/SUPER MARIO 64#C540C44C#0#2_all$EXT" "$PORT/Characters/Scuttlebug/tex1_32x32_418650bf0dcfa80e_5$EXT"
cp "_temp/SUPER MARIO 64#E6919896#0#2_all$EXT" "$PORT/Characters/Scuttlebug/tex1_32x32_cda8f489fed22a7f_5$EXT"

cp "_temp/SUPER MARIO 64#6AC8D5D1#0#2_all$EXT" "$PORT/Characters/Skeeter/tex1_32x32_4dba7f7437e42752_5$EXT"
cp "_temp/SUPER MARIO 64#A6469110#0#2_all$EXT" "$PORT/Characters/Skeeter/tex1_16x8_4cd5fb660516c37a_5$EXT"

cp "_temp/SUPER MARIO 64#1F4CDAB4#0#2_all$EXT" "$PORT/Characters/Snufit/tex1_16x32_a86ab42852761ca6_5$EXT"
cp "_temp/SUPER MARIO 64#458C0935#0#2_all$EXT" "$PORT/Characters/Snufit/tex1_32x32_a010f46862b582b3_5$EXT"
cp "_temp/SUPER MARIO 64#6BCC2E51#0#2_all$EXT" "$PORT/Characters/Snufit/tex1_32x32_55ea7d492516c989_5$EXT"
cp "_temp/SUPER MARIO 64#FACEA23F#0#2_all$EXT" "$PORT/Characters/Snufit/tex1_32x32_1b777ac54d052c00_5$EXT"

cp "_temp/SUPER MARIO 64#0F8EBA38#0#2_all$EXT" "$PORT/Characters/Spindrift/tex1_32x32_3ab8f85382222904_5$EXT"
cp "_temp/SUPER MARIO 64#13207BBB#0#2_all$EXT" "$PORT/Characters/Spindrift/tex1_32x32_05f5963890bca904_5$EXT"
cp "_temp/SUPER MARIO 64#9DC7C1E8#0#2_all$EXT" "$PORT/Characters/Spindrift/tex1_32x32_11f49045c695cbee_5$EXT"
cp "_temp/SUPER MARIO 64#DCD89861#0#2_all$EXT" "$PORT/Characters/Spindrift/tex1_32x32_41c15c5d1df66833_5$EXT"

cp "_temp/SUPER MARIO 64#0010FDC4#0#2_all$EXT" "$PORT/Characters/Sushi/tex1_32x32_badc2d06b780342f_5$EXT"
cp "_temp/SUPER MARIO 64#D4178125#0#2_all$EXT" "$PORT/Characters/Sushi/tex1_8x8_83df89616df1dd70_5$EXT"
cp "_temp/SUPER MARIO 64#E127CEDD#0#2_all$EXT" "$PORT/Characters/Sushi/tex1_32x16_1a3fc1d718b66fd1_5$EXT"

cp "_temp/SUPER MARIO 64#629A458D#0#2_all$EXT" "$PORT/Characters/Swoop/tex1_32x32_7656fe48ae3f3a16_5$EXT"
cp "_temp/SUPER MARIO 64#D220AA57#0#2_all$EXT" "$PORT/Characters/Swoop/tex1_32x32_83d93009e86756e0_5$EXT"
cp "_temp/SUPER MARIO 64#DF2A6551#0#2_all$EXT" "$PORT/Characters/Swoop/tex1_32x32_ee725cf4337e9937_5$EXT"
cp "_temp/SUPER MARIO 64#F399A4E9#0#2_all$EXT" "$PORT/Characters/Swoop/tex1_32x32_99be2209236a7049_5$EXT"

cp "_temp/SUPER MARIO 64#17CDE57D#0#2_all$EXT" "$PORT/Characters/Thwomp/tex1_32x64_7d380ae2b65db30b_5$EXT"
cp "_temp/SUPER MARIO 64#39D86D67#0#2_all$EXT" "$PORT/Characters/Thwomp/tex1_32x32_4bb0dec61469afae_5$EXT"

cp "_temp/SUPER MARIO 64#383BBD9B#0#2_all$EXT" "$PORT/Characters/Toad/tex1_32x32_c63ff58e9bd39107_5$EXT"
cp "_temp/SUPER MARIO 64#39F5A629#0#2_all$EXT" "$PORT/Characters/Toad/tex1_32x32_2c4ffc45146eea62_5$EXT"

cp "_temp/SUPER MARIO 64#31C66E6F#0#2_all$EXT" "$PORT/Characters/Ukiki/tex1_32x32_4f0dcb7cdcf9e55b_5$EXT"
cp "_temp/SUPER MARIO 64#49F74EB1#0#2_all$EXT" "$PORT/Characters/Ukiki/tex1_64x32_cbc83bfad35e29b4_5$EXT"
cp "_temp/SUPER MARIO 64#EA6F033E#0#2_all$EXT" "$PORT/Characters/Ukiki/tex1_32x32_83aa3f9a777c33a5_5$EXT"

cp "_temp/SUPER MARIO 64#59BBF047#0#2_all$EXT" "$PORT/Characters/Unagi/tex1_32x32_3e1d63ebef96de00_5$EXT"
cp "_temp/SUPER MARIO 64#6D6C38E3#0#2_all$EXT" "$PORT/Characters/Unagi/tex1_16x16_5c949a81607c69a0_5$EXT"
cp "_temp/SUPER MARIO 64#AD35A744#0#2_all$EXT" "$PORT/Characters/Unagi/tex1_32x32_f0f0a5ad65915600_5$EXT"
cp "_temp/SUPER MARIO 64#DB1CF863#0#2_all$EXT" "$PORT/Characters/Unagi/tex1_8x8_2cbf4e14259085f5_5$EXT"
cp "_temp/SUPER MARIO 64#EDBBE3D1#0#2_all$EXT" "$PORT/Characters/Unagi/tex1_16x16_08cb35a8a6259812_5$EXT"
cp "_temp/SUPER MARIO 64#F0729E14#0#2_all$EXT" "$PORT/Characters/Unagi/tex1_32x32_b029aef2964955b4_5$EXT"

cp "_temp/SUPER MARIO 64#4DEDBC41#0#2_all$EXT" "$PORT/Characters/Whomp/tex1_32x32_3abdc21d9414c06f_5$EXT"
cp "_temp/SUPER MARIO 64#6695E997#0#2_all$EXT" "$PORT/Characters/Whomp/tex1_32x64_b34ceebe551371fd_5$EXT"
cp "_temp/SUPER MARIO 64#8464CC0C#0#2_all$EXT" "$PORT/Characters/Whomp/tex1_32x32_f2debfc1a6864540_5$EXT"
cp "_temp/SUPER MARIO 64#D42E66E7#0#2_all$EXT" "$PORT/Characters/Whomp/tex1_32x64_84aef47a022b2c0c_5$EXT"

cp "_temp/SUPER MARIO 64#0E9C4E15#0#2_all$EXT" "$PORT/Characters/Wiggler/tex1_32x32_1634253791bc4655_5$EXT"
cp "_temp/SUPER MARIO 64#3411743E#0#2_all$EXT" "$PORT/Characters/Wiggler/tex1_32x64_f8dbb7d7139b2bf7_5$EXT"
cp "_temp/SUPER MARIO 64#3867CBEE#0#2_all$EXT" "$PORT/Characters/Wiggler/tex1_32x64_3bfcec48409fd411_5$EXT"
cp "_temp/SUPER MARIO 64#4E43931B#0#2_all$EXT" "$PORT/Characters/Wiggler/tex1_32x64_09243089ec899f33_5$EXT"
cp "_temp/SUPER MARIO 64#52FEDEB7#0#2_all$EXT" "$PORT/Characters/Wiggler/tex1_32x32_63cf6235b882195d_5$EXT"
cp "_temp/SUPER MARIO 64#A2F30414#0#2_all$EXT" "$PORT/Characters/Wiggler/tex1_32x64_4be816a533033430_5$EXT"

cp "_temp/SUPER MARIO 64#0AB43F69#0#2_all$EXT" "$PORT/Characters/Yoshi/tex1_16x16_bfa6794f89466b9c_5$EXT"
cp "_temp/SUPER MARIO 64#17060726#0#2_all$EXT" "$PORT/Characters/Yoshi/tex1_16x16_32ecc63668051ea5_5$EXT"
cp "_temp/SUPER MARIO 64#506D1A26#0#2_all$EXT" "$PORT/Characters/Yoshi/tex1_16x16_b504f74df91871c5_5$EXT"

cp "_temp/SUPER MARIO 64#41FDBC76#0#2_all$EXT" "$PORT/Effects/Bowser Explosion/00/tex1_64x32_ac869b6f32d8bbdb_5$EXT"
cp "_temp/SUPER MARIO 64#6ED6659F#0#2_all$EXT" "$PORT/Effects/Bowser Explosion/00/tex1_64x32_6d844e0136721c35_5$EXT"
cp "_temp/SUPER MARIO 64#D12D02E4#0#2_all$EXT" "$PORT/Effects/Bowser Explosion/01/tex1_64x32_387b23f620e9dc83_5$EXT"
cp "_temp/SUPER MARIO 64#DB8655FD#0#2_all$EXT" "$PORT/Effects/Bowser Explosion/01/tex1_64x32_85572927d8386fde_5$EXT"
cp "_temp/SUPER MARIO 64#5D54105C#0#2_all$EXT" "$PORT/Effects/Bowser Explosion/02/tex1_64x32_95880021909a42d0_5$EXT"
cp "_temp/SUPER MARIO 64#F5D23B55#0#2_all$EXT" "$PORT/Effects/Bowser Explosion/02/tex1_64x32_b38c77b2970d8d7f_5$EXT"
cp "_temp/SUPER MARIO 64#838795F8#0#2_all$EXT" "$PORT/Effects/Bowser Explosion/03/tex1_64x32_d23dec6190daf4c3_5$EXT"
cp "_temp/SUPER MARIO 64#B8B08A8F#0#2_all$EXT" "$PORT/Effects/Bowser Explosion/03/tex1_64x32_3b4880e1afebd372_5$EXT"
cp "_temp/SUPER MARIO 64#29636778#0#2_all$EXT" "$PORT/Effects/Bowser Explosion/04/tex1_64x32_95a85ab2bd3f5705_5$EXT"
cp "_temp/SUPER MARIO 64#E280555D#0#2_all$EXT" "$PORT/Effects/Bowser Explosion/04/tex1_64x32_9d6f5044c10a6c75_5$EXT"
cp "_temp/SUPER MARIO 64#4A7E7508#0#2_all$EXT" "$PORT/Effects/Bowser Explosion/05/tex1_64x32_4c839255a5a1befd_5$EXT"
cp "_temp/SUPER MARIO 64#B534B831#0#2_all$EXT" "$PORT/Effects/Bowser Explosion/05/tex1_64x32_eb41103f04c57d5d_5$EXT"
cp "_temp/SUPER MARIO 64#523F2F3F#0#2_all$EXT" "$PORT/Effects/Bowser Explosion/06/tex1_64x32_e192bb80f10dc7e8_5$EXT"
cp "_temp/SUPER MARIO 64#897D9B14#0#2_all$EXT" "$PORT/Effects/Bowser Explosion/06/tex1_64x32_422f1ba708e67855_5$EXT"
cp "_temp/SUPER MARIO 64#03249A62#0#2_all$EXT" "$PORT/Effects/Bowser Explosion/07/tex1_64x32_2167cb22454ca6c2_5$EXT"
cp "_temp/SUPER MARIO 64#61EC3940#0#2_all$EXT" "$PORT/Effects/Bowser Explosion/07/tex1_64x32_5074b18353d90e80_5$EXT"
cp "_temp/SUPER MARIO 64#0ED8D758#0#2_all$EXT" "$PORT/Effects/Bowser Explosion/08/tex1_64x32_03ff3a2c8196194e_5$EXT"
cp "_temp/SUPER MARIO 64#871045E4#0#2_all$EXT" "$PORT/Effects/Bowser Explosion/08/tex1_64x32_9539d779d8fa6a71_5$EXT"
cp "_temp/SUPER MARIO 64#5FD6CCEC#0#2_all$EXT" "$PORT/Effects/Bowser Explosion/09/tex1_64x32_1a61ab914dfcbcbf_5$EXT"
cp "_temp/SUPER MARIO 64#A46186FA#0#2_all$EXT" "$PORT/Effects/Bowser Explosion/09/tex1_64x32_4bb0a8aa75b46afa_5$EXT"
cp "_temp/SUPER MARIO 64#63F46B6E#0#2_all$EXT" "$PORT/Effects/Bowser Explosion/10/tex1_64x32_ad54ccdc758a7739_5$EXT"
cp "_temp/SUPER MARIO 64#FD1AA928#0#2_all$EXT" "$PORT/Effects/Bowser Explosion/10/tex1_64x32_a7b46fc2a503bb16_5$EXT"
cp "_temp/SUPER MARIO 64#095FC27A#0#2_all$EXT" "$PORT/Effects/Bowser Explosion/11/tex1_64x32_da81f6fa7481757a_5$EXT"
cp "_temp/SUPER MARIO 64#54E749EC#0#2_all$EXT" "$PORT/Effects/Bowser Explosion/11/tex1_64x32_0189d8593f72c1b0_5$EXT"
cp "_temp/SUPER MARIO 64#7473E7A4#0#2_all$EXT" "$PORT/Effects/Bowser Explosion/12/tex1_64x32_8727dd3f33a4e955_5$EXT"
cp "_temp/SUPER MARIO 64#B853043B#0#2_all$EXT" "$PORT/Effects/Bowser Explosion/12/tex1_64x32_01c2b0ae25dd2bec_5$EXT"
cp "_temp/SUPER MARIO 64#5E9F5DF4#0#2_all$EXT" "$PORT/Effects/Bowser Explosion/13/tex1_64x32_203d267252542d08_5$EXT"
cp "_temp/SUPER MARIO 64#A4F69A2F#0#2_all$EXT" "$PORT/Effects/Bowser Explosion/13/tex1_64x32_6744ea663b248da8_5$EXT"
cp "_temp/SUPER MARIO 64#1E263631#3#2_all$EXT" "$PORT/Effects/Bowser Explosion/tex1_64x32_c97429a66b77e80f_3$EXT"
cp "_temp/SUPER MARIO 64#D333CC90#3#2_all$EXT" "$PORT/Effects/Bowser Explosion/tex1_64x32_dbed90988666d990_3$EXT"

cp "_temp/SUPER MARIO 64#4A5830AD#0#2_all$EXT" "$PORT/Effects/Bubbles and Particles/tex1_32x32_57f927f75a4a8b32_5$EXT"
cp "_temp/SUPER MARIO 64#4A5830AD#0#2_all$EXT" "$PORT/Effects/Bubbles and Particles/Injects/tex1_32x32_2dbde788ce8b3804_5$EXT"
cp "_temp/SUPER MARIO 64#54FAC607#0#2_all$EXT" "$PORT/Effects/Bubbles and Particles/tex1_16x16_ac1b912027edf905_5$EXT"
cp "_temp/SUPER MARIO 64#6A32A053#0#2_all$EXT" "$PORT/Effects/Bubbles and Particles/tex1_16x16_5cda00e414764a0a_5$EXT"
cp "_temp/SUPER MARIO 64#CB509D6A#0#2_all$EXT" "$PORT/Effects/Bubbles and Particles/tex1_16x16_d5ec7a382514b869_5$EXT"
cp "_temp/SUPER MARIO 64#DCC12774#0#2_all$EXT" "$PORT/Effects/Bubbles and Particles/tex1_32x32_002bc6e36a26abdb_5$EXT"

cp "_temp/SUPER MARIO 64#D3A287BB#0#2_all$EXT" "$PORT/Effects/Burn Smoke/tex1_32x32_4c719dc337767aaa_5$EXT"

cp "_temp/SUPER MARIO 64#0B6D2926#0#2_all$EXT" "$PORT/Effects/Explosion/tex1_32x32_09eab57fc49d2381_5$EXT"
cp "_temp/SUPER MARIO 64#166DD880#0#2_all$EXT" "$PORT/Effects/Explosion/tex1_32x32_01f37c8172e09ff5_5$EXT"
cp "_temp/SUPER MARIO 64#1872FA6C#0#2_all$EXT" "$PORT/Effects/Explosion/tex1_32x32_0827ad674ab94f5e_5$EXT"
cp "_temp/SUPER MARIO 64#1E834EB0#0#2_all$EXT" "$PORT/Effects/Explosion/tex1_32x32_745d2a843634a570_5$EXT"
cp "_temp/SUPER MARIO 64#42A20F7E#0#2_all$EXT" "$PORT/Effects/Explosion/tex1_32x32_8e6794168e0b66c8_5$EXT"
cp "_temp/SUPER MARIO 64#B596CB90#0#2_all$EXT" "$PORT/Effects/Explosion/tex1_32x32_1f2cbf6f9b3c8d6e_5$EXT"
cp "_temp/SUPER MARIO 64#FA421C73#0#2_all$EXT" "$PORT/Effects/Explosion/tex1_32x32_9419994a7893c6bd_5$EXT"

cp "_temp/SUPER MARIO 64#1AE70860#3#2_all$EXT" "$PORT/Effects/Flame/tex1_32x32_b544332d156ba7c3_3$EXT"
cp "_temp/SUPER MARIO 64#28DF6C96#3#2_all$EXT" "$PORT/Effects/Flame/tex1_32x32_570636057e86f4f1_3$EXT"
cp "_temp/SUPER MARIO 64#4C6EDE9F#3#2_all$EXT" "$PORT/Effects/Flame/tex1_32x32_ec711b444f5ae9ae_3$EXT"
cp "_temp/SUPER MARIO 64#617BFB7B#3#2_all$EXT" "$PORT/Effects/Flame/tex1_32x32_c6bdb4d4f1849889_3$EXT"
cp "_temp/SUPER MARIO 64#67AD777B#3#2_all$EXT" "$PORT/Effects/Flame/tex1_32x32_62a525c7931d78a1_3$EXT"
cp "_temp/SUPER MARIO 64#A4841A07#3#2_all$EXT" "$PORT/Effects/Flame/tex1_32x32_03848ad036b9b96c_3$EXT"
cp "_temp/SUPER MARIO 64#DB4164D7#3#2_all$EXT" "$PORT/Effects/Flame/tex1_32x32_bca7d2fe64f0f5c1_3$EXT"
cp "_temp/SUPER MARIO 64#F0B319A6#3#2_all$EXT" "$PORT/Effects/Flame/tex1_32x32_6e9acacaec75c6a5_3$EXT"

cp "_temp/SUPER MARIO 64#5D987F11#0#2_all$EXT" "$PORT/Effects/Flower (unused)/tex1_32x32_59fa2201b8a2039e_5$EXT"
cp "_temp/SUPER MARIO 64#7B2F0CE2#0#2_all$EXT" "$PORT/Effects/Flower (unused)/tex1_32x32_e474c9afe040885d_5$EXT"
cp "_temp/SUPER MARIO 64#77C14ADF#0#2_all$EXT" "$PORT/Effects/Flower (unused)/tex1_32x32_3ae51b4bccca9014_5$EXT"
cp "_temp/SUPER MARIO 64#8A94A19F#0#2_all$EXT" "$PORT/Effects/Flower (unused)/tex1_32x32_5c0bdc674cb1b9a7_5$EXT"

cp "_temp/SUPER MARIO 64#20655B3C#3#2_all$EXT" "$PORT/Effects/Impact Ring/tex1_32x64_ef6e45663f199453_3$EXT"
cp "_temp/SUPER MARIO 64#3CF309E4#3#2_all$EXT" "$PORT/Effects/Impact Ring/tex1_32x64_c02bcc221d4d4d96_3$EXT"

cp "_temp/SUPER MARIO 64#85AEF726#0#2_all$EXT" "$PORT/Effects/Lava Bubble/unused/tex1_32x32_b6b1c0dd91288e98_5$EXT"
cp "_temp/SUPER MARIO 64#044F24EF#0#2_all$EXT" "$PORT/Effects/Lava Bubble/tex1_32x32_055587026b152260_5$EXT"
cp "_temp/SUPER MARIO 64#55E07C1C#0#2_all$EXT" "$PORT/Effects/Lava Bubble/tex1_32x32_0e177387f28db128_5$EXT"
cp "_temp/SUPER MARIO 64#7378A96F#0#2_all$EXT" "$PORT/Effects/Lava Bubble/tex1_32x32_8c119045adf35ece_5$EXT"
cp "_temp/SUPER MARIO 64#D2A5D574#0#2_all$EXT" "$PORT/Effects/Lava Bubble/tex1_32x32_feb73090f143dcb8_5$EXT"
cp "_temp/SUPER MARIO 64#DDE47B60#0#2_all$EXT" "$PORT/Effects/Lava Bubble/tex1_32x32_e7a0173978348490_5$EXT"
cp "_temp/SUPER MARIO 64#F91048ED#0#2_all$EXT" "$PORT/Effects/Lava Bubble/tex1_32x32_d8419b891a675dff_5$EXT"
cp "_temp/SUPER MARIO 64#FF50BD43#0#2_all$EXT" "$PORT/Effects/Lava Bubble/tex1_32x32_afb2323776a346e7_5$EXT"

cp "_temp/SUPER MARIO 64#F0A134BD#3#2_all$EXT" "$PORT/Effects/Light/Big Boo's Haunt/tex1_32x32_15d0064b554d0ad2_3$EXT"
cp "_temp/SUPER MARIO 64#19E8F076#3#2_all$EXT" "$PORT/Effects/Light/tex1_32x32_f8e2687d3378f0d4_3$EXT"
cp "_temp/SUPER MARIO 64#2EB2480C#3#2_all$EXT" "$PORT/Effects/Light/tex1_32x64_629fd40f9ae6177f_3$EXT"
cp "_temp/SUPER MARIO 64#3BAC2B9A#3#2_all$EXT" "$PORT/Effects/Light/tex1_16x16_96a81a7a37119c0d_3$EXT"
cp "_temp/SUPER MARIO 64#65542036#3#2_all$EXT" "$PORT/Effects/Light/tex1_32x32_47d6e1eb65c21ed7_3$EXT"
cp "_temp/SUPER MARIO 64#6C3CE89F#3#2_all$EXT" "$PORT/Effects/Light/tex1_32x32_bff3f85efba72041_3$EXT"

cp "_temp/SUPER MARIO 64#184368CA#0#2_all$EXT" "$PORT/Effects/Metal/tex1_32x32_2dfed89ba6e445ba_5$EXT"
cp "_temp/SUPER MARIO 64#432D56BE#0#2_all$EXT" "$PORT/Effects/Metal/tex1_64x32_9fe1587a3c780b33_5$EXT"

cp "_temp/SUPER MARIO 64#CD2A5787#0#2_all$EXT" "$PORT/Effects/Particles/tex1_16x16_069f6fabdd043276_5$EXT"
cp "_temp/SUPER MARIO 64#F21F608E#0#2_all$EXT" "$PORT/Effects/Particles/tex1_16x16_c60e49228765f2bc_5$EXT"

cp "_temp/SUPER MARIO 64#5535F203#0#2_all$EXT" "$PORT/Effects/Pebble/tex1_32x32_78443d8ac6c2be51_5$EXT"

cp "_temp/SUPER MARIO 64#1A43DF6A#3#2_all$EXT" "$PORT/Effects/Run/tex1_32x32_a94279230db4e01f_3$EXT"
cp "_temp/SUPER MARIO 64#3CB6F1A9#3#2_all$EXT" "$PORT/Effects/Run/tex1_32x32_49b1f4c6634b5734_3$EXT"
cp "_temp/SUPER MARIO 64#84836B2D#3#2_all$EXT" "$PORT/Effects/Run/tex1_32x32_395c8b0d8f08fbc5_3$EXT"
cp "_temp/SUPER MARIO 64#8A94D5A3#3#2_all$EXT" "$PORT/Effects/Run/tex1_32x32_edb39adad53185a7_3$EXT"
cp "_temp/SUPER MARIO 64#92828A2B#3#2_all$EXT" "$PORT/Effects/Run/tex1_32x32_28663d923f7120d6_3$EXT"
cp "_temp/SUPER MARIO 64#9C50AF6D#3#2_all$EXT" "$PORT/Effects/Run/tex1_32x32_6de04d26b0b1601a_3$EXT"
cp "_temp/SUPER MARIO 64#BBD69D4A#3#2_all$EXT" "$PORT/Effects/Run/tex1_32x32_738e76224e661f8a_3$EXT"

cp "_temp/SUPER MARIO 64#9CFE9F81#3#2_all$EXT" "$PORT/Effects/Shadow/tex1_32x32_4a32497e1f934262_3$EXT"

cp "_temp/SUPER MARIO 64#064F172D#3#2_all$EXT" "$PORT/Effects/Sparkle/Animation/tex1_32x32_b5088a0f1a0e89c1_3$EXT"
cp "_temp/SUPER MARIO 64#2465B806#3#2_all$EXT" "$PORT/Effects/Sparkle/Animation/tex1_32x32_3e86df9d2177523b_3$EXT"
cp "_temp/SUPER MARIO 64#2A283A6A#3#2_all$EXT" "$PORT/Effects/Sparkle/Animation/tex1_32x32_420d581d8f8106b5_3$EXT"
cp "_temp/SUPER MARIO 64#87805A7C#3#2_all$EXT" "$PORT/Effects/Sparkle/Animation/tex1_32x32_785b647fe8363f6c_3$EXT"
cp "_temp/SUPER MARIO 64#EED115D8#3#2_all$EXT" "$PORT/Effects/Sparkle/Animation/tex1_32x32_005092f17baa7a5f_3$EXT"
cp "_temp/SUPER MARIO 64#44AE3D51#0#2_all$EXT" "$PORT/Effects/Sparkle/Press Start/tex1_32x32_1046f55a94713eec_5$EXT"
cp "_temp/SUPER MARIO 64#4EE94F84#0#2_all$EXT" "$PORT/Effects/Sparkle/Press Start/tex1_32x32_334492f5f8071d8b_5$EXT"
cp "_temp/SUPER MARIO 64#6BF1D4EA#0#2_all$EXT" "$PORT/Effects/Sparkle/Press Start/tex1_32x32_9a9308ac92b6a033_5$EXT"
cp "_temp/SUPER MARIO 64#CCEB38F6#0#2_all$EXT" "$PORT/Effects/Sparkle/Press Start/tex1_32x32_80655fe6121fbcd9_5$EXT"
cp "_temp/SUPER MARIO 64#F476B374#0#2_all$EXT" "$PORT/Effects/Sparkle/Press Start/tex1_32x32_567e2368e423433e_5$EXT"
cp "_temp/SUPER MARIO 64#7F6733C7#0#2_all$EXT" "$PORT/Effects/Sparkle/Press Start/unused/tex1_32x32_eb137710124ad307_5$EXT"
cp "_temp/SUPER MARIO 64#57F55B58#0#2_all$EXT" "$PORT/Effects/Sparkle/tex1_32x32_777fc49a02c9929a_5$EXT"
cp "_temp/SUPER MARIO 64#8188E2DD#0#2_all$EXT" "$PORT/Effects/Sparkle/tex1_32x32_5c9aa4ea28088d33_5$EXT"
cp "_temp/SUPER MARIO 64#906FF62E#0#2_all$EXT" "$PORT/Effects/Sparkle/tex1_32x32_b142135f565f6792_5$EXT"
cp "_temp/SUPER MARIO 64#B9C749B9#0#2_all$EXT" "$PORT/Effects/Sparkle/tex1_32x32_acb879e9a7947a49_5$EXT"
cp "_temp/SUPER MARIO 64#F11E411F#0#2_all$EXT" "$PORT/Effects/Sparkle/tex1_32x32_3e780299615581df_5$EXT"
cp "_temp/SUPER MARIO 64#F4FAB5F3#0#2_all$EXT" "$PORT/Effects/Sparkle/tex1_32x32_9b70acb89f7b60f5_5$EXT"

cp "_temp/SUPER MARIO 64#4446F65D#3#2_all$EXT" "$PORT/Effects/Stomp/tex1_32x32_77e5f21c88085477_3$EXT"
cp "_temp/SUPER MARIO 64#9374994C#3#2_all$EXT" "$PORT/Effects/Stomp/tex1_32x32_2a9b6bffd9379594_3$EXT"
cp "_temp/SUPER MARIO 64#A6411501#3#2_all$EXT" "$PORT/Effects/Stomp/tex1_32x32_f74e0bce74d8ec80_3$EXT"
cp "_temp/SUPER MARIO 64#BB48F1BC#3#2_all$EXT" "$PORT/Effects/Stomp/tex1_32x32_9dd078c3c0954445_3$EXT"
cp "_temp/SUPER MARIO 64#C7B5DBC9#3#2_all$EXT" "$PORT/Effects/Stomp/tex1_32x32_d82e5a34e81bbc3b_3$EXT"
cp "_temp/SUPER MARIO 64#D8504EE4#3#2_all$EXT" "$PORT/Effects/Stomp/tex1_32x32_63f04d93c7db25db_3$EXT"

cp "_temp/SUPER MARIO 64#4B0C0C56#3#2_all$EXT" "$PORT/Effects/Swim/tex1_32x32_4c4fbc57f658463a_3$EXT"
cp "_temp/SUPER MARIO 64#5FF8D3EF#3#2_all$EXT" "$PORT/Effects/Swim/tex1_32x32_32ea021161fb8f51_3$EXT"
cp "_temp/SUPER MARIO 64#67D8B446#3#2_all$EXT" "$PORT/Effects/Swim/tex1_32x32_d2f9956cda26a0aa_3$EXT"
cp "_temp/SUPER MARIO 64#FBA28E17#3#2_all$EXT" "$PORT/Effects/Swim/tex1_32x32_198cbff232e8f798_3$EXT"

cp "_temp/SUPER MARIO 64#A7BDD88F#3#2_all$EXT" "$PORT/Effects/Tornado/tex1_32x64_6db56747f950f274_3$EXT"
cp "_temp/SUPER MARIO 64#A7BDD88F#3#2_all$EXT" "$PORT/Effects/Tornado/Injects/tex1_32x64_ee2b2c51cf80dc0a_3$EXT"

cp "_temp/SUPER MARIO 64#2D0C2E11#3#1_all$EXT" "$PORT/Effects/Transitions/tex1_32x64_408a6f2a923a5cd5_2$EXT"
cp "_temp/SUPER MARIO 64#7749B0D9#3#1_all$EXT" "$PORT/Effects/Transitions/tex1_32x64_96f1af674c399417_2$EXT"
cp "_temp/SUPER MARIO 64#98347689#3#1_all$EXT" "$PORT/Effects/Transitions/tex1_32x64_5bfd372ff3123460_2$EXT"
cp "_temp/SUPER MARIO 64#CB57B47B#3#1_all$EXT" "$PORT/Effects/Transitions/tex1_64x64_2b1770a4fa5a16e2_2$EXT"

cp "_temp/SUPER MARIO 64#0F5D756E#0#2_all$EXT" "$PORT/Effects/Water Splash/tex1_32x64_d44be964728be4e9_5$EXT"
cp "_temp/SUPER MARIO 64#444B37F6#0#2_all$EXT" "$PORT/Effects/Water Splash/tex1_32x64_72aba2365b475a7e_5$EXT"
cp "_temp/SUPER MARIO 64#4844CCB0#0#2_all$EXT" "$PORT/Effects/Water Splash/tex1_32x64_7396483218c8645c_5$EXT"
cp "_temp/SUPER MARIO 64#674FA5C8#0#2_all$EXT" "$PORT/Effects/Water Splash/tex1_32x64_3003929dcb104b4c_5$EXT"
cp "_temp/SUPER MARIO 64#928D4E78#0#2_all$EXT" "$PORT/Effects/Water Splash/tex1_32x64_499f2f48010499a8_5$EXT"
cp "_temp/SUPER MARIO 64#B54D1A02#0#2_all$EXT" "$PORT/Effects/Water Splash/tex1_32x64_88062e195432030e_5$EXT"
cp "_temp/SUPER MARIO 64#E04DCB5D#0#2_all$EXT" "$PORT/Effects/Water Splash/tex1_32x64_c364e4ea140e2275_5$EXT"
cp "_temp/SUPER MARIO 64#FA11921A#0#2_all$EXT" "$PORT/Effects/Water Splash/tex1_32x64_b94d74dfe79306da_5$EXT"

cp "_temp/SUPER MARIO 64#931AB56D#3#1_all$EXT" "$PORT/Effects/tex1_16x16_a7b47fdafa215356_2$EXT"
cp "_temp/SUPER MARIO 64#A44DF3E3#3#1_all$EXT" "$PORT/Effects/tex1_16x16_83fc4f564093ccab_2$EXT"

cp "_temp/SUPER MARIO 64#1A6F8A0E#0#2_all$EXT" "$PORT/Ending/tex1_80x20_22d331cb7739249a_5$EXT"
cp "_temp/SUPER MARIO 64#6A799547#0#2_all$EXT" "$PORT/Ending/tex1_80x20_556748ae31a70cbb_5$EXT"
cp "_temp/SUPER MARIO 64#6BC84AF5#0#2_all$EXT" "$PORT/Ending/tex1_80x20_69f35127f2da9cd9_5$EXT"
cp "_temp/SUPER MARIO 64#6C706165#0#2_all$EXT" "$PORT/Ending/tex1_80x20_a0c1eba86ada03f5_5$EXT"
cp "_temp/SUPER MARIO 64#07C7C401#0#2_all$EXT" "$PORT/Ending/tex1_80x20_1cc0e973f7346868_5$EXT"
cp "_temp/SUPER MARIO 64#8A4DF121#0#2_all$EXT" "$PORT/Ending/tex1_80x20_4c2b137b1341b24f_5$EXT"
cp "_temp/SUPER MARIO 64#8D5F88C4#0#2_all$EXT" "$PORT/Ending/tex1_80x20_1a45663c5d241b07_5$EXT"
cp "_temp/SUPER MARIO 64#9BD37209#0#2_all$EXT" "$PORT/Ending/tex1_80x20_523835fe22c1d93b_5$EXT"
cp "_temp/SUPER MARIO 64#9C8D6967#0#2_all$EXT" "$PORT/Ending/tex1_80x20_f461ded72ac6619a_5$EXT"
cp "_temp/SUPER MARIO 64#10C87D57#0#2_all$EXT" "$PORT/Ending/tex1_80x20_1c6a59667b03b8f0_5$EXT"
cp "_temp/SUPER MARIO 64#16DB7146#0#2_all$EXT" "$PORT/Ending/tex1_80x20_55b3b1aae59679ae_5$EXT"
cp "_temp/SUPER MARIO 64#21A99BEF#0#2_all$EXT" "$PORT/Ending/tex1_80x20_8ade0ad71a95863f_5$EXT"
cp "_temp/SUPER MARIO 64#39A50598#0#2_all$EXT" "$PORT/Ending/tex1_80x20_ef9ab2f4c954d038_5$EXT"
cp "_temp/SUPER MARIO 64#40AA862F#0#2_all$EXT" "$PORT/Ending/tex1_80x20_ea399d30c40d925f_5$EXT"
cp "_temp/SUPER MARIO 64#59C798D4#0#2_all$EXT" "$PORT/Ending/tex1_80x20_9a4fd3cbce6bcf12_5$EXT"
cp "_temp/SUPER MARIO 64#60BCEF6E#0#2_all$EXT" "$PORT/Ending/tex1_80x20_54af6a9762a54b6c_5$EXT"
cp "_temp/SUPER MARIO 64#72A1D4B8#0#2_all$EXT" "$PORT/Ending/tex1_80x20_9fb55714cc7372fa_5$EXT"
cp "_temp/SUPER MARIO 64#77C0FF44#0#2_all$EXT" "$PORT/Ending/tex1_80x20_c50de8fbf27a842e_5$EXT"
cp "_temp/SUPER MARIO 64#108D6CAE#0#2_all$EXT" "$PORT/Ending/tex1_80x20_ad1b2100a7655093_5$EXT"
cp "_temp/SUPER MARIO 64#163F6E7C#0#2_all$EXT" "$PORT/Ending/tex1_80x20_d961c8b684b66537_5$EXT"
cp "_temp/SUPER MARIO 64#292C40A1#0#2_all$EXT" "$PORT/Ending/tex1_80x20_e04636c0f3175817_5$EXT"
cp "_temp/SUPER MARIO 64#0430DE55#0#2_all$EXT" "$PORT/Ending/tex1_80x20_3b146c3bde2b72cf_5$EXT"
cp "_temp/SUPER MARIO 64#537D0A34#0#2_all$EXT" "$PORT/Ending/tex1_80x20_38a5b954fc3b251b_5$EXT"
cp "_temp/SUPER MARIO 64#2282C30A#0#2_all$EXT" "$PORT/Ending/tex1_80x20_14aec392165d4e94_5$EXT"
cp "_temp/SUPER MARIO 64#2677A2A0#0#2_all$EXT" "$PORT/Ending/tex1_80x20_2f5b92e48cd3b783_5$EXT"
cp "_temp/SUPER MARIO 64#5663D126#0#2_all$EXT" "$PORT/Ending/tex1_80x20_c96cfae7a49b221f_5$EXT"
cp "_temp/SUPER MARIO 64#8202BE27#0#2_all$EXT" "$PORT/Ending/tex1_80x20_dc8058626cdd095c_5$EXT"
cp "_temp/SUPER MARIO 64#80443EAE#0#2_all$EXT" "$PORT/Ending/tex1_80x20_c400f86457ead82a_5$EXT"
cp "_temp/SUPER MARIO 64#086772E7#0#2_all$EXT" "$PORT/Ending/tex1_80x20_f2e89a07af17c6b6_5$EXT"
cp "_temp/SUPER MARIO 64#992737D1#0#2_all$EXT" "$PORT/Ending/tex1_80x20_bf0aa85720adbb96_5$EXT"
cp "_temp/SUPER MARIO 64#6926316A#0#2_all$EXT" "$PORT/Ending/tex1_80x20_75611fe1c7905821_5$EXT"
cp "_temp/SUPER MARIO 64#A58A82F8#0#2_all$EXT" "$PORT/Ending/tex1_80x20_53255d6fd19a8f99_5$EXT"
cp "_temp/SUPER MARIO 64#BA568BD1#0#2_all$EXT" "$PORT/Ending/tex1_80x20_a14648cb7c15308c_5$EXT"
cp "_temp/SUPER MARIO 64#BF00C323#0#2_all$EXT" "$PORT/Ending/tex1_80x20_5c1f541ca666dff5_5$EXT"
cp "_temp/SUPER MARIO 64#C136BC10#0#2_all$EXT" "$PORT/Ending/tex1_80x20_1cc6aa7576b16b16_5$EXT"
cp "_temp/SUPER MARIO 64#C8782E13#0#2_all$EXT" "$PORT/Ending/tex1_80x20_2b07354409c46ee5_5$EXT"
cp "_temp/SUPER MARIO 64#D3D78F68#0#2_all$EXT" "$PORT/Ending/tex1_80x20_2b328ac3fd1fa224_5$EXT"
cp "_temp/SUPER MARIO 64#E3A23A76#0#2_all$EXT" "$PORT/Ending/tex1_80x20_815b8bca0cd0887b_5$EXT"
cp "_temp/SUPER MARIO 64#EC390C33#0#2_all$EXT" "$PORT/Ending/tex1_80x20_89477dcbfaf50321_5$EXT"
cp "_temp/SUPER MARIO 64#F8B79A21#0#2_all$EXT" "$PORT/Ending/tex1_80x20_99ca2180e88ef137_5$EXT"
cp "_temp/SUPER MARIO 64#F8D3168E#0#2_all$EXT" "$PORT/Ending/tex1_80x20_6af3569f43a0b219_5$EXT"
cp "_temp/SUPER MARIO 64#F3247D8B#0#2_all$EXT" "$PORT/Ending/tex1_80x20_2dbe08ef83c89291_5$EXT"
cp "_temp/SUPER MARIO 64#F66738C7#0#2_all$EXT" "$PORT/Ending/tex1_80x20_a461f5f13c732a62_5$EXT"
cp "_temp/SUPER MARIO 64#FA49A60A#0#2_all$EXT" "$PORT/Ending/tex1_80x20_fc1add988173c560_5$EXT"
cp "_temp/SUPER MARIO 64#FA825D44#0#2_all$EXT" "$PORT/Ending/tex1_80x20_63931a5b3be5fd1b_5$EXT"
cp "_temp/SUPER MARIO 64#FBEC7687#0#2_all$EXT" "$PORT/Ending/tex1_80x20_7c991f4cb9697a8b_5$EXT"

cp "_temp/SUPER MARIO 64#18EC36FD#0#2_all$EXT" "$PORT/Ending/Europe/English/tex1_64x32_20be91e05a94ee7f_5$EXT"
cp "_temp/SUPER MARIO 64#31A51D72#0#2_all$EXT" "$PORT/Ending/Europe/English/tex1_64x32_d9622691cfb09484_5$EXT"
cp "_temp/SUPER MARIO 64#290FFE53#0#2_all$EXT" "$PORT/Ending/Europe/French/tex1_64x32_b8fcd4aef08272b8_5$EXT"
cp "_temp/SUPER MARIO 64#500B0DEA#0#2_all$EXT" "$PORT/Ending/Europe/French/tex1_64x32_9d3996f9f074f96f_5$EXT"
cp "_temp/SUPER MARIO 64#0C111216#0#2_all$EXT" "$PORT/Ending/Europe/German/tex1_64x32_83134c2529d13d42_5$EXT"
cp "_temp/SUPER MARIO 64#4381E7ED#0#2_all$EXT" "$PORT/Ending/Europe/German/tex1_64x32_d259d0e6727d4f38_5$EXT"
cp "_temp/SUPER MARIO 64#0C106657#0#2_all$EXT" "$PORT/Ending/Europe/tex1_64x32_2880aa3783d6e713_5$EXT"
cp "_temp/SUPER MARIO 64#10F7ABF3#0#2_all$EXT" "$PORT/Ending/Europe/tex1_64x32_51339443d6887f37_5$EXT"
cp "_temp/SUPER MARIO 64#27FDB2DC#0#2_all$EXT" "$PORT/Ending/Europe/tex1_64x32_6a6152981721905c_5$EXT"
cp "_temp/SUPER MARIO 64#28F7B042#0#2_all$EXT" "$PORT/Ending/Europe/tex1_64x32_edd0ebdade8b996f_5$EXT"
cp "_temp/SUPER MARIO 64#2A46C0DF#0#2_all$EXT" "$PORT/Ending/Europe/tex1_64x32_d7f68cd3f5903995_5$EXT"
cp "_temp/SUPER MARIO 64#308E2468#0#2_all$EXT" "$PORT/Ending/Europe/tex1_64x32_45b1bfdeae5e10c9_5$EXT"
cp "_temp/SUPER MARIO 64#3F7232A7#0#2_all$EXT" "$PORT/Ending/Europe/tex1_64x32_d712fe5491c804f4_5$EXT"
cp "_temp/SUPER MARIO 64#4AD973E2#0#2_all$EXT" "$PORT/Ending/Europe/tex1_64x32_2d630f7d69a7ab79_5$EXT"
cp "_temp/SUPER MARIO 64#532ECD87#0#2_all$EXT" "$PORT/Ending/Europe/tex1_64x32_819633da5372c338_5$EXT"
cp "_temp/SUPER MARIO 64#5657416D#0#2_all$EXT" "$PORT/Ending/Europe/tex1_64x32_3f7f051522770b9d_5$EXT"
cp "_temp/SUPER MARIO 64#5677A141#0#2_all$EXT" "$PORT/Ending/Europe/tex1_64x32_9284691bbc190605_5$EXT"
cp "_temp/SUPER MARIO 64#5AB4CEF4#0#2_all$EXT" "$PORT/Ending/Europe/tex1_64x32_915ea75057eecb0a_5$EXT"
cp "_temp/SUPER MARIO 64#63AECD87#0#2_all$EXT" "$PORT/Ending/Europe/tex1_64x32_fc9a90a767d81e0e_5$EXT"
cp "_temp/SUPER MARIO 64#6D62A6A6#0#2_all$EXT" "$PORT/Ending/Europe/tex1_64x32_3679df007e2cce72_5$EXT"
cp "_temp/SUPER MARIO 64#74A85A68#0#2_all$EXT" "$PORT/Ending/Europe/tex1_64x32_10468ebf191b0f08_5$EXT"
cp "_temp/SUPER MARIO 64#763590BE#0#2_all$EXT" "$PORT/Ending/Europe/tex1_64x32_58e3f25edb3c271b_5$EXT"
cp "_temp/SUPER MARIO 64#81874B75#0#2_all$EXT" "$PORT/Ending/Europe/tex1_64x32_dc0c97b477c56f6a_5$EXT"
cp "_temp/SUPER MARIO 64#83AB57C6#0#2_all$EXT" "$PORT/Ending/Europe/tex1_64x32_5fb12cfd13dcfcd3_5$EXT"
cp "_temp/SUPER MARIO 64#85C02640#0#2_all$EXT" "$PORT/Ending/Europe/tex1_64x32_24f4ca2e96f65d9d_5$EXT"
cp "_temp/SUPER MARIO 64#89464744#0#2_all$EXT" "$PORT/Ending/Europe/tex1_64x32_0e150c12cfe01a86_5$EXT"
cp "_temp/SUPER MARIO 64#978D2257#0#2_all$EXT" "$PORT/Ending/Europe/tex1_64x32_90d8241abbdf5341_5$EXT"
cp "_temp/SUPER MARIO 64#A5CFD43A#0#2_all$EXT" "$PORT/Ending/Europe/tex1_64x32_695ea13b1cf1bdeb_5$EXT"
cp "_temp/SUPER MARIO 64#B2743C1B#0#2_all$EXT" "$PORT/Ending/Europe/tex1_64x32_8e304e46e8448622_5$EXT"
cp "_temp/SUPER MARIO 64#B4D53E4A#0#2_all$EXT" "$PORT/Ending/Europe/tex1_64x32_2fc7375f77558494_5$EXT"
cp "_temp/SUPER MARIO 64#C041FCD7#0#2_all$EXT" "$PORT/Ending/Europe/tex1_64x32_b5d867f493ef23b8_5$EXT"
cp "_temp/SUPER MARIO 64#D31DAE4D#0#2_all$EXT" "$PORT/Ending/Europe/tex1_64x32_4d509f65866c21a4_5$EXT"
cp "_temp/SUPER MARIO 64#D6570E85#0#2_all$EXT" "$PORT/Ending/Europe/tex1_64x32_d82fc73408d3646a_5$EXT"
cp "_temp/SUPER MARIO 64#E3F75852#0#2_all$EXT" "$PORT/Ending/Europe/tex1_64x32_d9418dd6b58fae14_5$EXT"
cp "_temp/SUPER MARIO 64#E97DEC1C#0#2_all$EXT" "$PORT/Ending/Europe/tex1_64x32_e189706fb0b61ea4_5$EXT"
cp "_temp/SUPER MARIO 64#EA9EFBD7#0#2_all$EXT" "$PORT/Ending/Europe/tex1_64x32_19cffd1c283a513b_5$EXT"
cp "_temp/SUPER MARIO 64#EDF99175#0#2_all$EXT" "$PORT/Ending/Europe/tex1_64x32_ef5224d188893c32_5$EXT"
cp "_temp/SUPER MARIO 64#EDFDEEE8#0#2_all$EXT" "$PORT/Ending/Europe/tex1_64x32_794c2019e151971c_5$EXT"

cp "_temp/SUPER MARIO 64#0B2390F1#0#2_all$EXT" "$PORT/Hacks/Italian/tex1_16x16_daaba5fa852f467a_5$EXT"
cp "_temp/SUPER MARIO 64#9D0D539A#0#2_all$EXT" "$PORT/Hacks/Italian/tex1_64x32_64be5ade73699237_5$EXT"

cp "_temp/SUPER MARIO 64#7F99C256#3#0_all$EXT" "$PORT/Hacks/Italian/Accents/tex1_16x8_1bee8f162019796a_2$EXT"
cp "_temp/SUPER MARIO 64#8BB18968#3#0_all$EXT" "$PORT/Hacks/Italian/Accents/tex1_16x8_99de8feed881fb7b_2$EXT"
cp "_temp/SUPER MARIO 64#8CA25891#3#0_all$EXT" "$PORT/Hacks/Italian/Accents/tex1_16x8_eeb5ef31a048bc38_2$EXT"
cp "_temp/SUPER MARIO 64#70A7D167#3#0_all$EXT" "$PORT/Hacks/Italian/Accents/tex1_16x8_b61f1bbec8c26ef3_2$EXT"
cp "_temp/SUPER MARIO 64#787AC0A1#3#0_all$EXT" "$PORT/Hacks/Italian/Accents/tex1_16x8_381307de6be64ca5_2$EXT"
cp "_temp/SUPER MARIO 64#AEA7B185#3#0_all$EXT" "$PORT/Hacks/Italian/Accents/tex1_16x8_644dfca9ae0444e7_2$EXT"
cp "_temp/SUPER MARIO 64#BEA8A184#3#0_all$EXT" "$PORT/Hacks/Italian/Accents/tex1_16x8_bd686a23f04a32f6_2$EXT"

cp "_temp/SUPER MARIO 64#6FAA2E94#0#2_all$EXT" "$PORT/Hacks/Italian/Boot/tex1_80x24_880207f7bc3218df_5$EXT"
cp "_temp/SUPER MARIO 64#E1C887F7#0#2_all$EXT" "$PORT/Hacks/Italian/Boot/tex1_128x16_6b317d9f667e9335_5$EXT"
cp "_temp/SUPER MARIO 64#E519CA39#0#2_all$EXT" "$PORT/Hacks/Italian/Boot/tex1_16x16_f952a8c7a8c056ae_5$EXT"

cp "_temp/SUPER MARIO 64#0DF2EE56#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/tex1_8x8_fef495759f8344ed_5$EXT"
cp "_temp/SUPER MARIO 64#03615A50#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/tex1_8x8_83c9796dc574dc9e_5$EXT"
cp "_temp/SUPER MARIO 64#05E4C3CE#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/tex1_8x8_49eabe90fedb5e4d_5$EXT"
cp "_temp/SUPER MARIO 64#2FFB1C1E#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/tex1_8x8_c3958ce6aa160f4d_5$EXT"
cp "_temp/SUPER MARIO 64#3BCA4663#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/tex1_8x8_69d9b53ee013e0ac_5$EXT"
cp "_temp/SUPER MARIO 64#4AFB88E5#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/tex1_8x8_b9d5b6f3b4f75c1a_5$EXT"
cp "_temp/SUPER MARIO 64#7E19E019#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/tex1_8x8_dc332906732d423c_5$EXT"
cp "_temp/SUPER MARIO 64#8B3C07F3#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/tex1_8x8_8de30b7599bd570e_5$EXT"
cp "_temp/SUPER MARIO 64#17EF85F7#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/tex1_8x8_e11a6628bbd6e137_5$EXT"
cp "_temp/SUPER MARIO 64#25B219C7#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/tex1_8x8_fdabb0c42747381a_5$EXT"
cp "_temp/SUPER MARIO 64#66D3249E#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/tex1_8x8_4de4bd28ba57b84c_5$EXT"
cp "_temp/SUPER MARIO 64#68CC2DCF#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/tex1_8x8_af22b70584407e86_5$EXT"
cp "_temp/SUPER MARIO 64#74B2E682#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/tex1_8x8_c524310f4a564dd7_5$EXT"
cp "_temp/SUPER MARIO 64#76A30F4E#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/tex1_8x8_4498d3e086e6a25b_5$EXT"
cp "_temp/SUPER MARIO 64#97BE3437#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/tex1_8x8_b33199d137229d41_5$EXT"
cp "_temp/SUPER MARIO 64#284FF556#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/tex1_8x8_a0190af0b24d2a54_5$EXT"
cp "_temp/SUPER MARIO 64#522CE9C5#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/tex1_8x8_e326002615487ea8_5$EXT"
cp "_temp/SUPER MARIO 64#690ACA1A#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/tex1_8x8_1980189187aad322_5$EXT"
cp "_temp/SUPER MARIO 64#916ADF8D#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/tex1_8x8_f2bc007bd5aa01a8_5$EXT"
cp "_temp/SUPER MARIO 64#89840F12#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/tex1_8x8_5ce3f1acddceb2e3_5$EXT"
cp "_temp/SUPER MARIO 64#96184D64#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/tex1_8x8_9215df596ec221c6_5$EXT"
cp "_temp/SUPER MARIO 64#381969FB#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/tex1_8x8_3487043a8896ecc0_5$EXT"
cp "_temp/SUPER MARIO 64#A8A99A1B#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/tex1_8x8_eccab6e0217372bc_5$EXT"
cp "_temp/SUPER MARIO 64#A24313CF#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/tex1_8x8_cecf8a2988e3d43c_5$EXT"
cp "_temp/SUPER MARIO 64#E192BD52#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/tex1_8x8_14c502bb9eee841a_5$EXT"
cp "_temp/SUPER MARIO 64#EDC820A0#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/tex1_8x8_3a609dae53b16829_5$EXT"
cp "_temp/SUPER MARIO 64#EF597575#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/tex1_8x8_7c6e85dcb7e73b02_5$EXT"
cp "_temp/SUPER MARIO 64#EFC4F8C1#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/tex1_8x8_c0112e9192adb9a5_5$EXT"
cp "_temp/SUPER MARIO 64#F09319B6#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/tex1_8x8_54f1217d782683e2_5$EXT"
cp "_temp/SUPER MARIO 64#F9693BD4#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/tex1_8x8_15c4b5a9bb40eed4_5$EXT"

cp "_temp/SUPER MARIO 64#379ABEE0#0#2_all$EXT" "$PORT/Hacks/Italian/Doors/tex1_32x64_8cd414320eac1d5a_5$EXT"
cp "_temp/SUPER MARIO 64#C48EA6DD#0#2_all$EXT" "$PORT/Hacks/Italian/Doors/tex1_32x32_1a33c274b79fc9f1_5$EXT"
cp "_temp/SUPER MARIO 64#E6170513#0#2_all$EXT" "$PORT/Hacks/Italian/Doors/tex1_32x64_329f5dd2f3fa7ba6_5$EXT"
cp "_temp/SUPER MARIO 64#F4F57CAE#0#2_all$EXT" "$PORT/Hacks/Italian/Doors/tex1_32x64_35aa064910e0b61a_5$EXT"

cp "_temp/SUPER MARIO 64#08731842#0#2_all$EXT" "$PORT/Hacks/Italian/Ending/tex1_80x20_d24088074335f286_5$EXT"
cp "_temp/SUPER MARIO 64#8E673CBA#0#2_all$EXT" "$PORT/Hacks/Italian/Ending/tex1_80x20_d47311bfb6ef27e0_5$EXT"
cp "_temp/SUPER MARIO 64#44A3D447#0#2_all$EXT" "$PORT/Hacks/Italian/Ending/tex1_80x20_3e37a1594bcca18f_5$EXT"
cp "_temp/SUPER MARIO 64#90105191#0#2_all$EXT" "$PORT/Hacks/Italian/Ending/tex1_80x20_eb53f75f68a07764_5$EXT"
cp "_temp/SUPER MARIO 64#A8EF6703#0#2_all$EXT" "$PORT/Hacks/Italian/Ending/tex1_80x20_cbc0b2aba0b1908d_5$EXT"
cp "_temp/SUPER MARIO 64#BCD252AA#0#2_all$EXT" "$PORT/Hacks/Italian/Ending/tex1_80x20_de503fc856de8e82_5$EXT"
cp "_temp/SUPER MARIO 64#C3D06562#0#2_all$EXT" "$PORT/Hacks/Italian/Ending/tex1_80x20_dec16c33713c592f_5$EXT"
cp "_temp/SUPER MARIO 64#FBAC0AC1#0#2_all$EXT" "$PORT/Hacks/Italian/Ending/tex1_80x20_95ded6a5eaa015fb_5$EXT"

cp "_temp/SUPER MARIO 64#2C614658#0#2_all$EXT" "$PORT/Hacks/Italian/File Select/tex1_16x16_01e5365ef0314511_5$EXT"
cp "_temp/SUPER MARIO 64#832377DF#0#2_all$EXT" "$PORT/Hacks/Italian/File Select/tex1_64x32_68ffc93c67c56d2a_5$EXT"
cp "_temp/SUPER MARIO 64#DDDEB631#0#2_all$EXT" "$PORT/Hacks/Italian/File Select/tex1_64x32_748a23b4209beeb4_5$EXT"

cp "_temp/SUPER MARIO 64#1D183FBC#0#2_all$EXT" "$PORT/Hacks/Italian/Game Over/tex1_80x20_bf2e81be3fedb2d6_5$EXT"
cp "_temp/SUPER MARIO 64#9B6614EA#0#2_all$EXT" "$PORT/Hacks/Italian/Game Over/tex1_80x20_ca054a46ac8a2594_5$EXT"
cp "_temp/SUPER MARIO 64#B994341B#0#2_all$EXT" "$PORT/Hacks/Italian/Game Over/tex1_80x20_81c34a55ff7a8af7_5$EXT"
cp "_temp/SUPER MARIO 64#DE288E3D#0#2_all$EXT" "$PORT/Hacks/Italian/Game Over/tex1_80x20_577a380d1efd8a3c_5$EXT"

cp "_temp/SUPER MARIO 64#28C6D988#0#2_all$EXT" "$PORT/Hacks/Italian/Power Meter/tex1_32x64_00c06ae464dedc3d_5$EXT"
cp "_temp/SUPER MARIO 64#DA943EC7#0#2_all$EXT" "$PORT/Hacks/Italian/Power Meter/tex1_32x64_2d37e684411aa058_5$EXT"

cp "_temp/SUPER MARIO 64#22922890#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Bowser/tex1_32x32_19534f93b1ac6f45_5$EXT"
cp "_temp/SUPER MARIO 64#28306D49#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Bowser/tex1_32x32_31b05537bd3dc1be_5$EXT"
cp "_temp/SUPER MARIO 64#4167F9D9#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Bowser/tex1_32x32_23def5b41debb00c_5$EXT"
cp "_temp/SUPER MARIO 64#461CAD5E#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Bowser/tex1_32x32_7e370df3a86af4c9_5$EXT"
cp "_temp/SUPER MARIO 64#51464DCC#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Bowser/tex1_32x32_5088c44e37971c96_5$EXT"
cp "_temp/SUPER MARIO 64#89A3BC6D#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Bowser/tex1_32x32_e24fc1cf2caa18d1_5$EXT"
cp "_temp/SUPER MARIO 64#8E553E08#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Bowser/tex1_32x32_df61eb9111ea3f2a_5$EXT"
cp "_temp/SUPER MARIO 64#9FB22F58#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Bowser/tex1_32x32_6ad1934cb5034d7f_5$EXT"
cp "_temp/SUPER MARIO 64#AB5321E2#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Bowser/tex1_32x32_567dcd996d2f93b9_5$EXT"
cp "_temp/SUPER MARIO 64#B75E03A9#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Bowser/tex1_32x32_efbbaa61ca867172_5$EXT"
cp "_temp/SUPER MARIO 64#B994AC9B#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Bowser/tex1_32x32_14f60558591aea5a_5$EXT"
cp "_temp/SUPER MARIO 64#D03DC784#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Bowser/tex1_32x32_54506eac9df3cfeb_5$EXT"
cp "_temp/SUPER MARIO 64#E6FC50A9#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Bowser/tex1_32x32_2434109ac15d6b63_5$EXT"

cp "_temp/SUPER MARIO 64#169F1F02#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Luigi/tex1_32x32_baa26093b68bb236_5$EXT"
cp "_temp/SUPER MARIO 64#44A70AFD#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Luigi/tex1_32x32_a30bab052003a67e_5$EXT"
cp "_temp/SUPER MARIO 64#5844A956#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Luigi/tex1_32x32_f13bac2017f98dd9_5$EXT"
cp "_temp/SUPER MARIO 64#5CB45199#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Luigi/tex1_32x32_ab364afda7dad01b_5$EXT"
cp "_temp/SUPER MARIO 64#799CA729#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Luigi/tex1_32x32_ba22604a2c84d8f0_5$EXT"
cp "_temp/SUPER MARIO 64#D0381C0B#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Luigi/tex1_32x32_e1d1771dea86a48e_5$EXT"
cp "_temp/SUPER MARIO 64#F23F46C3#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Luigi/tex1_32x32_da44d4526c92d008_5$EXT"

cp "_temp/SUPER MARIO 64#0A9E2B96#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Mario/tex1_32x32_e9951b7df823d451_5$EXT"
cp "_temp/SUPER MARIO 64#0DB99B2E#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Mario/tex1_32x32_c838448216473f9e_5$EXT"
cp "_temp/SUPER MARIO 64#3DC483C5#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Mario/tex1_32x32_df804165a7a5ac0e_5$EXT"
cp "_temp/SUPER MARIO 64#47CF2FCB#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Mario/tex1_32x32_a5e302fce70886f3_5$EXT"
cp "_temp/SUPER MARIO 64#5F864F5D#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Mario/tex1_32x32_1fc5df94a990f361_5$EXT"
cp "_temp/SUPER MARIO 64#847028E0#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Mario/tex1_32x32_f2ef6dd983c2cc74_5$EXT"
cp "_temp/SUPER MARIO 64#CCC551FE#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Mario/tex1_32x32_0fadd4e8a156ca0a_5$EXT"
cp "_temp/SUPER MARIO 64#D9F6CF53#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Mario/tex1_32x32_4073e96cbad4973a_5$EXT"
cp "_temp/SUPER MARIO 64#E972AC97#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Mario/tex1_32x32_77860aeff2bb9874_5$EXT"
cp "_temp/SUPER MARIO 64#EB3842BD#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Mario/tex1_32x32_224f4c421a695f61_5$EXT"
cp "_temp/SUPER MARIO 64#F309ED8E#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Mario/tex1_32x32_0fc0a49dc8634b9b_5$EXT"
cp "_temp/SUPER MARIO 64#FBE45EEE#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Mario/tex1_32x32_4aefa52606604565_5$EXT"
cp "_temp/SUPER MARIO 64#FE3E61A2#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Mario/tex1_32x32_c2a49addd4ccb740_5$EXT"

cp "_temp/SUPER MARIO 64#00D84C67#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Peach/tex1_32x32_d6aa6e6abf5084ab_5$EXT"
cp "_temp/SUPER MARIO 64#2BDECACD#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Peach/tex1_32x32_dc3283d8e6f30a1f_5$EXT"
cp "_temp/SUPER MARIO 64#4EDD979D#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Peach/tex1_32x32_2b9c55e1f86450ed_5$EXT"
cp "_temp/SUPER MARIO 64#5B8168E1#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Peach/tex1_32x32_aef5fb6256dbf409_5$EXT"
cp "_temp/SUPER MARIO 64#60F3F3DD#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Peach/tex1_32x32_ffd2289fa1c5372a_5$EXT"
cp "_temp/SUPER MARIO 64#74EDA125#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Peach/tex1_32x32_73d2e0d51d35b4ca_5$EXT"
cp "_temp/SUPER MARIO 64#861FB80F#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Peach/tex1_32x32_0ad8a1968d7b4d1a_5$EXT"
cp "_temp/SUPER MARIO 64#9C85EB43#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Peach/tex1_32x32_4cff28ecca863247_5$EXT"
cp "_temp/SUPER MARIO 64#B5FDC516#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Peach/tex1_32x32_7978bd00113d620a_5$EXT"
cp "_temp/SUPER MARIO 64#B8F1BFA4#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Peach/tex1_32x32_cb4d12cff0617688_5$EXT"
cp "_temp/SUPER MARIO 64#BD013EA0#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Peach/tex1_32x32_cf2ea9f78860e5ac_5$EXT"
cp "_temp/SUPER MARIO 64#C60DF6D6#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Peach/tex1_32x32_fdf1e8cf8b2a8a32_5$EXT"

cp "_temp/SUPER MARIO 64#3645BC2D#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Toad/tex1_32x32_4450c0d04a3a3f48_5$EXT"
cp "_temp/SUPER MARIO 64#575F3D32#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Toad/tex1_32x32_8160d6a38afd9f54_5$EXT"
cp "_temp/SUPER MARIO 64#6D7C572B#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Toad/tex1_32x32_43241a9f11888982_5$EXT"
cp "_temp/SUPER MARIO 64#D5229F79#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Toad/tex1_32x32_c8fbc4533031f5d9_5$EXT"

cp "_temp/SUPER MARIO 64#244E5B3E#0#2_all$EXT" "$PORT/Hacks/Multiplayer/v1.2/tex1_32x32_793b2788bdde9115_5$EXT"
cp "_temp/SUPER MARIO 64#36D4EF3E#0#2_all$EXT" "$PORT/Hacks/Multiplayer/v1.2/tex1_32x32_62506efe5d99ac82_5$EXT"
cp "_temp/SUPER MARIO 64#3CF17015#0#2_all$EXT" "$PORT/Hacks/Multiplayer/v1.2/tex1_32x32_8b759431d3b348a5_5$EXT"
cp "_temp/SUPER MARIO 64#CAF05DAA#0#2_all$EXT" "$PORT/Hacks/Multiplayer/v1.2/tex1_32x32_2f9a015b8f37d389_5$EXT"
cp "_temp/SUPER MARIO 64#87E934DB#0#2_all$EXT" "$PORT/Hacks/Multiplayer/v1.3/tex1_16x16_0a94872fe873742b_5$EXT"
cp "_temp/SUPER MARIO 64#CFB0A1D9#0#2_all$EXT" "$PORT/Hacks/Multiplayer/v1.3/tex1_32x32_f73850a3c910fd97_5$EXT"
cp "_temp/SUPER MARIO 64#CB30FEE4#0#2_all$EXT" "$PORT/Hacks/Multiplayer/v1.3/tex1_16x16_2ea62a2fe2193ae2_5$EXT"
cp "_temp/SUPER MARIO 64#670C1829#0#2_all$EXT" "$PORT/Hacks/Multiplayer/v1.3.1/tex1_16x16_2f92cfc86b81cf46_5$EXT"

cp "_temp/SUPER MARIO 64#AFE7D9AE#0#2_all$EXT" "$PORT/Hacks/Shindou Improvement/tex1_80x24_36eb28aebf62a879_5$EXT"
cp "_temp/SUPER MARIO 64#D3A287BB#3#2_all$EXT" "$PORT/Hacks/Shindou Improvement/tex1_32x32_a1af8faeabc370dc_3$EXT"

cp "_temp/SUPER MARIO 64#72BFE459#0#2_all$EXT" "$PORT/HUD/Course/Europe/English/tex1_64x32_e1e2fb34aa0f82b1_5$EXT"
cp "_temp/SUPER MARIO 64#0B32979B#0#2_all$EXT" "$PORT/HUD/Course/Europe/French/tex1_64x32_2514bef222e6a00a_5$EXT"
cp "_temp/SUPER MARIO 64#FA7285DE#0#2_all$EXT" "$PORT/HUD/Course/Europe/German/tex1_64x32_ac486c9f407d5c6e_5$EXT"
cp "_temp/SUPER MARIO 64#56DB5E1C#0#2_all$EXT" "$PORT/HUD/Course/Europe/tex1_64x32_cc6cda17ba351d50_5$EXT"
cp "_temp/SUPER MARIO 64#D135687E#0#2_all$EXT" "$PORT/HUD/Course/tex1_64x32_c468b38eb5edd4e1_5$EXT"
cp "_temp/SUPER MARIO 64#FAD8C6E1#0#2_all$EXT" "$PORT/HUD/Course/tex1_64x32_cf16404ff58564e0_5$EXT"

cp "_temp/SUPER MARIO 64#0075DA18#0#2_all$EXT" "$PORT/HUD/Font/Japanese/tex1_16x16_f0857f959137eb78_5$EXT"
cp "_temp/SUPER MARIO 64#127B0F41#0#2_all$EXT" "$PORT/HUD/Font/Japanese/tex1_16x16_eaf7001f571c4700_5$EXT"
cp "_temp/SUPER MARIO 64#1CD30ACE#0#2_all$EXT" "$PORT/HUD/Font/Japanese/tex1_16x16_f7e9840a7effe224_5$EXT"
cp "_temp/SUPER MARIO 64#1CDCC29C#0#2_all$EXT" "$PORT/HUD/Font/Japanese/tex1_16x16_1f71e264b4a0c2d4_5$EXT"
cp "_temp/SUPER MARIO 64#27AE0809#0#2_all$EXT" "$PORT/HUD/Font/Japanese/tex1_16x16_451abc5411dea212_5$EXT"
cp "_temp/SUPER MARIO 64#3711D2C0#0#2_all$EXT" "$PORT/HUD/Font/Japanese/tex1_16x16_eb0df8a912215705_5$EXT"
cp "_temp/SUPER MARIO 64#448CB3E7#0#2_all$EXT" "$PORT/HUD/Font/Japanese/tex1_16x16_ddd1c72c9e3a9a14_5$EXT"
cp "_temp/SUPER MARIO 64#48FC50A9#0#2_all$EXT" "$PORT/HUD/Font/Japanese/tex1_16x16_151f2830cd4dbedc_5$EXT"
cp "_temp/SUPER MARIO 64#4DA5EB87#0#2_all$EXT" "$PORT/HUD/Font/Japanese/tex1_16x16_f03d2a5c7e822d6a_5$EXT"
cp "_temp/SUPER MARIO 64#52797C8E#0#2_all$EXT" "$PORT/HUD/Font/Japanese/tex1_16x16_773f33f672a4183c_5$EXT"
cp "_temp/SUPER MARIO 64#5F21CD0B#0#2_all$EXT" "$PORT/HUD/Font/Japanese/tex1_16x16_7d030fb4d4e545de_5$EXT"
cp "_temp/SUPER MARIO 64#6379BE10#0#2_all$EXT" "$PORT/HUD/Font/Japanese/tex1_16x16_2ce4d305f36333e6_5$EXT"
cp "_temp/SUPER MARIO 64#6A94B667#0#2_all$EXT" "$PORT/HUD/Font/Japanese/tex1_16x16_2d747cf27139ec4d_5$EXT"
cp "_temp/SUPER MARIO 64#72C132CB#0#2_all$EXT" "$PORT/HUD/Font/Japanese/tex1_16x16_bd7e512f3b4ce7b7_5$EXT"
cp "_temp/SUPER MARIO 64#73017371#0#2_all$EXT" "$PORT/HUD/Font/Japanese/tex1_16x16_ca333924bbe3700d_5$EXT"
cp "_temp/SUPER MARIO 64#83CB5976#0#2_all$EXT" "$PORT/HUD/Font/Japanese/tex1_16x16_e89c537c2129de47_5$EXT"
cp "_temp/SUPER MARIO 64#9255AA67#0#2_all$EXT" "$PORT/HUD/Font/Japanese/tex1_16x16_55ad714afe0533b4_5$EXT"
cp "_temp/SUPER MARIO 64#93E5A95E#0#2_all$EXT" "$PORT/HUD/Font/Japanese/tex1_16x16_fd35b9a713beb29a_5$EXT"
cp "_temp/SUPER MARIO 64#9B6626FE#0#2_all$EXT" "$PORT/HUD/Font/Japanese/tex1_16x16_68566a434a958be3_5$EXT"
cp "_temp/SUPER MARIO 64#BE7558ED#0#2_all$EXT" "$PORT/HUD/Font/Japanese/tex1_16x16_13097821d3d6044d_5$EXT"
cp "_temp/SUPER MARIO 64#DDAFBC28#0#2_all$EXT" "$PORT/HUD/Font/Japanese/tex1_16x16_b51ec358baf0a856_5$EXT"
cp "_temp/SUPER MARIO 64#EBE128AA#0#2_all$EXT" "$PORT/HUD/Font/Japanese/tex1_16x16_608bcb47b53f0c53_5$EXT"
cp "_temp/SUPER MARIO 64#F30400D5#0#2_all$EXT" "$PORT/HUD/Font/Japanese/tex1_16x16_2f84be9a06eeb178_5$EXT"
cp "_temp/SUPER MARIO 64#F7DE7C20#0#2_all$EXT" "$PORT/HUD/Font/Japanese/tex1_16x16_3fd15e77395d4f1b_5$EXT"
cp "_temp/SUPER MARIO 64#0659AB56#0#2_all$EXT" "$PORT/HUD/Font/tex1_16x16_d93cd3a14ef7b29e_5$EXT"
cp "_temp/SUPER MARIO 64#08C865BC#0#2_all$EXT" "$PORT/HUD/Font/tex1_16x16_30f6877e36ae7cf5_5$EXT"
cp "_temp/SUPER MARIO 64#095CCD5F#0#2_all$EXT" "$PORT/HUD/Font/tex1_16x16_f5f82188071dccd2_5$EXT"
cp "_temp/SUPER MARIO 64#0F53E6DA#0#2_all$EXT" "$PORT/HUD/Font/tex1_16x16_59ae60b09500bd0e_5$EXT"
cp "_temp/SUPER MARIO 64#134A35B3#0#2_all$EXT" "$PORT/HUD/Font/tex1_16x16_72897fb13c9778c3_5$EXT"
cp "_temp/SUPER MARIO 64#202D35BE#0#2_all$EXT" "$PORT/HUD/Font/tex1_16x16_4540ccb5d39afeda_5$EXT"
cp "_temp/SUPER MARIO 64#28A7F52B#0#2_all$EXT" "$PORT/HUD/Font/tex1_16x16_edb091bc95980064_5$EXT"
cp "_temp/SUPER MARIO 64#2A359204#0#2_all$EXT" "$PORT/HUD/Font/tex1_16x16_e0d52b1f1feab732_5$EXT"
cp "_temp/SUPER MARIO 64#2B851F69#0#2_all$EXT" "$PORT/HUD/Font/tex1_16x16_48400449fedeac31_5$EXT"
cp "_temp/SUPER MARIO 64#336D534A#0#2_all$EXT" "$PORT/HUD/Font/tex1_16x16_13df19ff26dffa79_5$EXT"
cp "_temp/SUPER MARIO 64#414026B4#0#2_all$EXT" "$PORT/HUD/Font/tex1_16x16_b52572926d253477_5$EXT"
cp "_temp/SUPER MARIO 64#468BC569#0#2_all$EXT" "$PORT/HUD/Font/tex1_16x16_0ccef2b58ac78ec1_5$EXT"
cp "_temp/SUPER MARIO 64#4E4571C1#0#2_all$EXT" "$PORT/HUD/Font/tex1_16x16_32c631c07bd86059_5$EXT"
cp "_temp/SUPER MARIO 64#51BDAFFF#0#2_all$EXT" "$PORT/HUD/Font/tex1_16x16_64f0902970704aa5_5$EXT"
cp "_temp/SUPER MARIO 64#52A84252#0#2_all$EXT" "$PORT/HUD/Font/tex1_16x16_c98f9428c427b82c_5$EXT"
cp "_temp/SUPER MARIO 64#5EF65DD9#0#2_all$EXT" "$PORT/HUD/Font/tex1_16x16_192d14d333d96311_5$EXT"
cp "_temp/SUPER MARIO 64#6B1FC91A#0#2_all$EXT" "$PORT/HUD/Font/tex1_16x16_388686bf9bff14bf_5$EXT"
cp "_temp/SUPER MARIO 64#6BC75681#0#2_all$EXT" "$PORT/HUD/Font/tex1_16x16_a5a508f2ac8bcdef_5$EXT"
cp "_temp/SUPER MARIO 64#6C64EB0B#0#2_all$EXT" "$PORT/HUD/Font/tex1_16x16_a7ab48549489556d_5$EXT"
cp "_temp/SUPER MARIO 64#78CE86A9#0#2_all$EXT" "$PORT/HUD/Font/tex1_16x16_a4052a4321ee5be5_5$EXT"
cp "_temp/SUPER MARIO 64#7AB277B8#0#2_all$EXT" "$PORT/HUD/Font/tex1_16x16_7f5d4d766077751d_5$EXT"
cp "_temp/SUPER MARIO 64#7C2D13C9#0#2_all$EXT" "$PORT/HUD/Font/tex1_16x16_16c832642503f83e_5$EXT"
cp "_temp/SUPER MARIO 64#7CC51E15#0#2_all$EXT" "$PORT/HUD/Font/tex1_16x16_762c9e5be2bea5e3_5$EXT"
cp "_temp/SUPER MARIO 64#81BB18E0#0#2_all$EXT" "$PORT/HUD/Font/tex1_16x16_eb82defd65d54253_5$EXT"
cp "_temp/SUPER MARIO 64#86B7D553#0#2_all$EXT" "$PORT/HUD/Font/tex1_16x16_3e77239113af2a54_5$EXT"
cp "_temp/SUPER MARIO 64#92AD1EEF#0#2_all$EXT" "$PORT/HUD/Font/tex1_16x16_b4159b6881bc94d1_5$EXT"
cp "_temp/SUPER MARIO 64#9513887C#0#2_all$EXT" "$PORT/HUD/Font/tex1_16x16_3afcdb2659fc9fd6_5$EXT"
cp "_temp/SUPER MARIO 64#A0974D75#0#2_all$EXT" "$PORT/HUD/Font/tex1_16x16_dafea1cc30fcd03c_5$EXT"
cp "_temp/SUPER MARIO 64#A2013A12#0#2_all$EXT" "$PORT/HUD/Font/tex1_16x16_499047903e099b69_5$EXT"
cp "_temp/SUPER MARIO 64#D89B4538#0#2_all$EXT" "$PORT/HUD/Font/tex1_16x16_680f09dcfcd52560_5$EXT"
cp "_temp/SUPER MARIO 64#DB3C7C79#0#2_all$EXT" "$PORT/HUD/Font/tex1_16x16_9bb71b2c9f0b6e5f_5$EXT"
cp "_temp/SUPER MARIO 64#E2DE3E2B#0#2_all$EXT" "$PORT/HUD/Font/tex1_16x16_474bb789e90bf7b1_5$EXT"
cp "_temp/SUPER MARIO 64#E4BD5580#0#2_all$EXT" "$PORT/HUD/Font/tex1_16x16_03119cd95758e480_5$EXT"
cp "_temp/SUPER MARIO 64#F5974867#0#2_all$EXT" "$PORT/HUD/Font/tex1_16x16_f13fdb6c574deeab_5$EXT"
cp "_temp/SUPER MARIO 64#FC10A1B3#0#2_all$EXT" "$PORT/HUD/Font/tex1_16x16_16615dd90123fafd_5$EXT"
cp "_temp/SUPER MARIO 64#FE3D6481#0#2_all$EXT" "$PORT/HUD/Font/tex1_16x16_8167e6e6b123b184_5$EXT"
cp "_temp/SUPER MARIO 64#FFEA1FFE#0#2_all$EXT" "$PORT/HUD/Font/tex1_16x16_e8b2dd2133b154b5_5$EXT"

cp "_temp/SUPER MARIO 64#362E3E52#0#2_all$EXT" "$PORT/HUD/Icons/tex1_16x16_416d7a6606a751d5_5$EXT"
cp "_temp/SUPER MARIO 64#438CC5BE#0#2_all$EXT" "$PORT/HUD/Icons/tex1_16x16_aed275f1d84564e6_5$EXT"
cp "_temp/SUPER MARIO 64#580E00A9#0#2_all$EXT" "$PORT/HUD/Icons/tex1_16x16_0d6c261913cc7c09_5$EXT"
cp "_temp/SUPER MARIO 64#676B6CF3#0#2_all$EXT" "$PORT/HUD/Icons/tex1_16x16_4c7ef00d391993a7_5$EXT"
cp "_temp/SUPER MARIO 64#6F32A4FB#0#2_all$EXT" "$PORT/HUD/Icons/tex1_16x16_2b3c877b878a7e28_5$EXT"
cp "_temp/SUPER MARIO 64#88703C55#0#2_all$EXT" "$PORT/HUD/Icons/tex1_16x16_62f816d5be833abb_5$EXT"
cp "_temp/SUPER MARIO 64#A7398F08#0#2_all$EXT" "$PORT/HUD/Icons/tex1_8x8_68e1d34b143c6a4b_5$EXT"
cp "_temp/SUPER MARIO 64#EC24C279#0#2_all$EXT" "$PORT/HUD/Icons/tex1_8x8_25a17f75d3889351_5$EXT"

cp "_temp/SUPER MARIO 64#076B5C8F#0#2_all$EXT" "$PORT/HUD/Power Meter/tex1_32x32_697c9f14d4bebe82_5$EXT"
cp "_temp/SUPER MARIO 64#10F30B26#0#2_all$EXT" "$PORT/HUD/Power Meter/tex1_32x32_6759e1ea643875ba_5$EXT"
cp "_temp/SUPER MARIO 64#268B611D#0#2_all$EXT" "$PORT/HUD/Power Meter/tex1_32x32_83646daa0a09c552_5$EXT"
cp "_temp/SUPER MARIO 64#2B846815#0#2_all$EXT" "$PORT/HUD/Power Meter/tex1_32x32_503785ccbffcd75d_5$EXT"
cp "_temp/SUPER MARIO 64#4DC0BBDF#0#2_all$EXT" "$PORT/HUD/Power Meter/tex1_32x32_9b2a7086cd72192d_5$EXT"
cp "_temp/SUPER MARIO 64#6CA78364#0#2_all$EXT" "$PORT/HUD/Power Meter/tex1_32x64_c437ed5b88246671_5$EXT"
cp "_temp/SUPER MARIO 64#9F02A40F#0#2_all$EXT" "$PORT/HUD/Power Meter/tex1_32x32_949b4dafe9f60e56_5$EXT"
cp "_temp/SUPER MARIO 64#BCBD0842#0#2_all$EXT" "$PORT/HUD/Power Meter/tex1_32x32_14c095a0821a2685_5$EXT"
cp "_temp/SUPER MARIO 64#F1C23131#0#2_all$EXT" "$PORT/HUD/Power Meter/tex1_32x32_3e5e7b2851cfa8b0_5$EXT"
cp "_temp/SUPER MARIO 64#FD569CD5#0#2_all$EXT" "$PORT/HUD/Power Meter/tex1_32x64_8721f2a3df05d8b7_5$EXT"

cp "_temp/SUPER MARIO 64#D1D18587#3#0_all$EXT" "$PORT/Letters/16x8/Buttons/A/tex1_16x8_ab193dc3521dd68a_2$EXT"
cp "_temp/SUPER MARIO 64#9AC5A4A5#3#0_all$EXT" "$PORT/Letters/16x8/Buttons/B/tex1_16x8_95bffd35bc84fd69_2$EXT"
cp "_temp/SUPER MARIO 64#B97C9FAD#3#0_all$EXT" "$PORT/Letters/16x8/Buttons/C/tex1_16x8_6e53e40c4ef082d1_2$EXT"
cp "_temp/SUPER MARIO 64#B1C091A7#3#0_all$EXT" "$PORT/Letters/16x8/Buttons/R/tex1_16x8_6a44af4ac6694744_2$EXT"
cp "_temp/SUPER MARIO 64#0ECC73B4#3#0_all$EXT" "$PORT/Letters/16x8/Buttons/Z/tex1_16x8_c7a5908a9d279be4_2$EXT"
cp "_temp/SUPER MARIO 64#6CAB6E7C#3#0_all$EXT" "$PORT/Letters/16x8/Capital/A/tex1_16x8_b395d1bf2ec17a58_2$EXT"
cp "_temp/SUPER MARIO 64#AEB2B780#3#0_all$EXT" "$PORT/Letters/16x8/Capital/B/tex1_16x8_212f7653cbcf3b55_2$EXT"
cp "_temp/SUPER MARIO 64#897AB77F#3#0_all$EXT" "$PORT/Letters/16x8/Capital/C/tex1_16x8_4d4accdd9429da56_2$EXT"
cp "_temp/SUPER MARIO 64#86A979A6#3#0_all$EXT" "$PORT/Letters/16x8/Capital/D/tex1_16x8_f6f8b3dccded7023_2$EXT"
cp "_temp/SUPER MARIO 64#8798CFBF#3#0_all$EXT" "$PORT/Letters/16x8/Capital/E/tex1_16x8_0117d281b7f2184e_2$EXT"
cp "_temp/SUPER MARIO 64#69B6B1A1#3#0_all$EXT" "$PORT/Letters/16x8/Capital/F/tex1_16x8_65a5e667564592f5_2$EXT"
cp "_temp/SUPER MARIO 64#8894B7A4#3#0_all$EXT" "$PORT/Letters/16x8/Capital/G/tex1_16x8_3959f50caa5537c4_2$EXT"
cp "_temp/SUPER MARIO 64#78A6E268#3#0_all$EXT" "$PORT/Letters/16x8/Capital/H/tex1_16x8_16e7779830370b79_2$EXT"
cp "_temp/SUPER MARIO 64#B9A790A1#3#0_all$EXT" "$PORT/Letters/16x8/Capital/I/tex1_16x8_013942b6e5553512_2$EXT"
cp "_temp/SUPER MARIO 64#9F8995A3#3#0_all$EXT" "$PORT/Letters/16x8/Capital/J/tex1_16x8_77f6707f7154c112_2$EXT"
cp "_temp/SUPER MARIO 64#A8DF6863#3#0_all$EXT" "$PORT/Letters/16x8/Capital/K/tex1_16x8_b185072feffd5dad_2$EXT"
cp "_temp/SUPER MARIO 64#988AA5AE#3#0_all$EXT" "$PORT/Letters/16x8/Capital/L/tex1_16x8_b78d2061599f843d_2$EXT"
cp "_temp/SUPER MARIO 64#AFB97693#3#0_all$EXT" "$PORT/Letters/16x8/Capital/M/tex1_16x8_4e3c13c8050cd759_2$EXT"
cp "_temp/SUPER MARIO 64#B0AB7771#3#0_all$EXT" "$PORT/Letters/16x8/Capital/N/tex1_16x8_091d4bf9dcb102ca_2$EXT"
cp "_temp/SUPER MARIO 64#887AB795#3#0_all$EXT" "$PORT/Letters/16x8/Capital/O/tex1_16x8_a12f0edc0da552b2_2$EXT"
cp "_temp/SUPER MARIO 64#69B2B1A2#3#0_all$EXT" "$PORT/Letters/16x8/Capital/P/tex1_16x8_09fd1468f984f3b1_2$EXT"
cp "_temp/SUPER MARIO 64#A698B795#3#0_all$EXT" "$PORT/Letters/16x8/Capital/Q/tex1_16x8_bb6b302e9908dfcf_2$EXT"
cp "_temp/SUPER MARIO 64#6BB0B3A0#3#0_all$EXT" "$PORT/Letters/16x8/Capital/R/tex1_16x8_8b0e190b7f3bfcca_2$EXT"
cp "_temp/SUPER MARIO 64#C1799951#3#0_all$EXT" "$PORT/Letters/16x8/Capital/S/tex1_16x8_2ae44759e6528a3e_2$EXT"
cp "_temp/SUPER MARIO 64#B9A79083#3#0_all$EXT" "$PORT/Letters/16x8/Capital/T/tex1_16x8_e5049e9101be3936_2$EXT"
cp "_temp/SUPER MARIO 64#9789A886#3#0_all$EXT" "$PORT/Letters/16x8/Capital/U/tex1_16x8_d3bb864da5ccf982_2$EXT"
cp "_temp/SUPER MARIO 64#8D8F8692#3#0_all$EXT" "$PORT/Letters/16x8/Capital/V/tex1_16x8_9f81f874943c7f8f_2$EXT"
cp "_temp/SUPER MARIO 64#7D8D66C4#3#0_all$EXT" "$PORT/Letters/16x8/Capital/W/tex1_16x8_cfdcf13d926b4a11_2$EXT"
cp "_temp/SUPER MARIO 64#BDF14875#3#0_all$EXT" "$PORT/Letters/16x8/Capital/X/tex1_16x8_2438ef83e50b2472_2$EXT"
cp "_temp/SUPER MARIO 64#AC848284#3#0_all$EXT" "$PORT/Letters/16x8/Capital/Y/tex1_16x8_bcfe0920aa5c5594_2$EXT"
cp "_temp/SUPER MARIO 64#B97D6191#3#0_all$EXT" "$PORT/Letters/16x8/Capital/Z/tex1_16x8_711d697384e101c2_2$EXT"
cp "_temp/SUPER MARIO 64#80A7C266#3#0_all$EXT" "$PORT/Letters/16x8/Lowercase/a/tex1_16x8_ec61298f8e7c7af3_2$EXT"
cp "_temp/SUPER MARIO 64#6089A2C3#3#0_all$EXT" "$PORT/Letters/16x8/Lowercase/b/tex1_16x8_4b377d26fe111e23_2$EXT"
cp "_temp/SUPER MARIO 64#C089A462#3#0_all$EXT" "$PORT/Letters/16x8/Lowercase/c/tex1_16x8_d854f560c90b66a7_2$EXT"
cp "_temp/SUPER MARIO 64#8187C266#3#0_all$EXT" "$PORT/Letters/16x8/Lowercase/d/tex1_16x8_074c7ea223988265_2$EXT"
cp "_temp/SUPER MARIO 64#BEA7A284#3#0_all$EXT" "$PORT/Letters/16x8/Lowercase/e/tex1_16x8_a432ec0bbc787130_2$EXT"
cp "_temp/SUPER MARIO 64#AA77A182#3#0_all$EXT" "$PORT/Letters/16x8/Lowercase/f/tex1_16x8_10dc7b650b65157f_2$EXT"
cp "_temp/SUPER MARIO 64#8D8682B6#3#0_all$EXT" "$PORT/Letters/16x8/Lowercase/g/tex1_16x8_620b5f53dd0d5b00_2$EXT"
cp "_temp/SUPER MARIO 64#62A7C2A1#3#0_all$EXT" "$PORT/Letters/16x8/Lowercase/h/tex1_16x8_294a3b6bd297748d_2$EXT"
cp "_temp/SUPER MARIO 64#788AA257#3#0_all$EXT" "$PORT/Letters/16x8/Lowercase/i/tex1_16x8_8120263de8c7a898_2$EXT"
cp "_temp/SUPER MARIO 64#81697994#3#0_all$EXT" "$PORT/Letters/16x8/Lowercase/j/tex1_16x8_f8195628daac9a4a_2$EXT"
cp "_temp/SUPER MARIO 64#49E284A3#3#0_all$EXT" "$PORT/Letters/16x8/Lowercase/k/tex1_16x8_d759f0a46f08ea25_2$EXT"
cp "_temp/SUPER MARIO 64#6AA886A1#3#0_all$EXT" "$PORT/Letters/16x8/Lowercase/l/tex1_16x8_e6b3f5a59c327ab8_2$EXT"
cp "_temp/SUPER MARIO 64#64C774D2#3#0_all$EXT" "$PORT/Letters/16x8/Lowercase/m/tex1_16x8_94f9f7117299718c_2$EXT"
cp "_temp/SUPER MARIO 64#62A980C3#3#0_all$EXT" "$PORT/Letters/16x8/Lowercase/n/tex1_16x8_08f6e685fdae622d_2$EXT"
cp "_temp/SUPER MARIO 64#8089A286#3#0_all$EXT" "$PORT/Letters/16x8/Lowercase/o/tex1_16x8_c091bf742050a8e5_2$EXT"
cp "_temp/SUPER MARIO 64#A087A286#3#0_all$EXT" "$PORT/Letters/16x8/Lowercase/p/tex1_16x8_33d1fe9c80de69ea_2$EXT"
cp "_temp/SUPER MARIO 64#8187C284#3#0_all$EXT" "$PORT/Letters/16x8/Lowercase/q/tex1_16x8_2a5233012aba06bd_2$EXT"
cp "_temp/SUPER MARIO 64#A2C46681#3#0_all$EXT" "$PORT/Letters/16x8/Lowercase/r/tex1_16x8_1fe8eaf43091cb38_2$EXT"
cp "_temp/SUPER MARIO 64#C5C3A662#3#0_all$EXT" "$PORT/Letters/16x8/Lowercase/s/tex1_16x8_c5b81d67261609ca_2$EXT"
cp "_temp/SUPER MARIO 64#8C87859E#3#0_all$EXT" "$PORT/Letters/16x8/Lowercase/t/tex1_16x8_bb66ce56d507c7f6_2$EXT"
cp "_temp/SUPER MARIO 64#7F8AC166#3#0_all$EXT" "$PORT/Letters/16x8/Lowercase/u/tex1_16x8_f7fd3724ccd5304f_2$EXT"
cp "_temp/SUPER MARIO 64#C3688681#3#0_all$EXT" "$PORT/Letters/16x8/Lowercase/v/tex1_16x8_c573009a6571853f_2$EXT"
cp "_temp/SUPER MARIO 64#9FA8C268#3#0_all$EXT" "$PORT/Letters/16x8/Lowercase/w/tex1_16x8_ea2b5ecaf78cf634_2$EXT"
cp "_temp/SUPER MARIO 64#A2C49F94#3#0_all$EXT" "$PORT/Letters/16x8/Lowercase/x/tex1_16x8_dc8b2dfa4e539f09_2$EXT"
cp "_temp/SUPER MARIO 64#BD8C84AF#3#0_all$EXT" "$PORT/Letters/16x8/Lowercase/y/tex1_16x8_b6d2b62e1329f4a9_2$EXT"
cp "_temp/SUPER MARIO 64#C2A56782#3#0_all$EXT" "$PORT/Letters/16x8/Lowercase/z/tex1_16x8_83649597cd72deb7_2$EXT"
cp "_temp/SUPER MARIO 64#98BB898E#3#0_all$EXT" "$PORT/Letters/16x8/Numerals/0/tex1_16x8_92f6614eadad7b0b_2$EXT"
cp "_temp/SUPER MARIO 64#D057B494#3#0_all$EXT" "$PORT/Letters/16x8/Numerals/1/tex1_16x8_bee59023724174c4_2$EXT"
cp "_temp/SUPER MARIO 64#B0F373B0#3#0_all$EXT" "$PORT/Letters/16x8/Numerals/2/tex1_16x8_78c1c704a8b44150_2$EXT"
cp "_temp/SUPER MARIO 64#87BA54C8#3#0_all$EXT" "$PORT/Letters/16x8/Numerals/3/tex1_16x8_a4e794d73fe0996b_2$EXT"
cp "_temp/SUPER MARIO 64#60D4A5C2#3#0_all$EXT" "$PORT/Letters/16x8/Numerals/4/tex1_16x8_f63ff868eb8aa2c8_2$EXT"
cp "_temp/SUPER MARIO 64#B6BA71D3#3#0_all$EXT" "$PORT/Letters/16x8/Numerals/5/tex1_16x8_954422d26fe96f5e_2$EXT"
cp "_temp/SUPER MARIO 64#97BAA58E#3#0_all$EXT" "$PORT/Letters/16x8/Numerals/6/tex1_16x8_95d710c8a1910962_2$EXT"
cp "_temp/SUPER MARIO 64#68F155A5#3#0_all$EXT" "$PORT/Letters/16x8/Numerals/7/tex1_16x8_657344e0a02e5625_2$EXT"
cp "_temp/SUPER MARIO 64#87BA9198#3#0_all$EXT" "$PORT/Letters/16x8/Numerals/8/tex1_16x8_5bb14818832c8b79_2$EXT"
cp "_temp/SUPER MARIO 64#B0D568A0#3#0_all$EXT" "$PORT/Letters/16x8/Numerals/9/tex1_16x8_cad62e4291462011_2$EXT"
cp "_temp/SUPER MARIO 64#5297B884#3#0_all$EXT" "$PORT/Letters/16x8/Punctuation/tex1_16x8_3aa1ecb05dfc3fde_2$EXT"
cp "_temp/SUPER MARIO 64#637878B3#3#0_all$EXT" "$PORT/Letters/16x8/Punctuation/tex1_16x8_e993748f637fa15a_2$EXT"
cp "_temp/SUPER MARIO 64#6C6A6686#3#0_all$EXT" "$PORT/Letters/16x8/Punctuation/tex1_16x8_d534e79f1ae07ebd_2$EXT"
cp "_temp/SUPER MARIO 64#8A4886A6#3#0_all$EXT" "$PORT/Letters/16x8/Punctuation/tex1_16x8_d859dc82a8dc8157_2$EXT"
cp "_temp/SUPER MARIO 64#8A687694#3#0_all$EXT" "$PORT/Letters/16x8/Punctuation/tex1_16x8_297b03d06ab56a50_2$EXT"
cp "_temp/SUPER MARIO 64#8A688695#3#0_all$EXT" "$PORT/Letters/16x8/Punctuation/tex1_16x8_ebbf01cef5e09dac_2$EXT"
cp "_temp/SUPER MARIO 64#8A6886A4#3#0_all$EXT" "$PORT/Letters/16x8/Punctuation/tex1_16x8_03e748f186d21a91_2$EXT"
cp "_temp/SUPER MARIO 64#8C7275A4#3#0_all$EXT" "$PORT/Letters/16x8/Punctuation/tex1_16x8_c4285831e42e36f9_2$EXT"
cp "_temp/SUPER MARIO 64#9A887684#3#0_all$EXT" "$PORT/Letters/16x8/Punctuation/tex1_16x8_2a61b39dd3dd078c_2$EXT"
cp "_temp/SUPER MARIO 64#9B877585#3#0_all$EXT" "$PORT/Letters/16x8/Punctuation/tex1_16x8_60d74b980d53c8d7_2$EXT"
cp "_temp/SUPER MARIO 64#A77A8863#3#0_all$EXT" "$PORT/Letters/16x8/Punctuation/tex1_16x8_1925c9ac195ca993_2$EXT"
cp "_temp/SUPER MARIO 64#B35BE951#3#0_all$EXT" "$PORT/Letters/16x8/Punctuation/tex1_16x8_206e6ebb1c7076a6_2$EXT"
cp "_temp/SUPER MARIO 64#7A89B25A#3#0_all$EXT" "$PORT/Letters/16x8/Special/tex1_16x8_8ed35683b836147d_2$EXT"
cp "_temp/SUPER MARIO 64#888AA166#3#0_all$EXT" "$PORT/Letters/16x8/Special/tex1_16x8_81b642fda56cfd67_2$EXT"
cp "_temp/SUPER MARIO 64#897AF57D#3#0_all$EXT" "$PORT/Letters/16x8/Special/tex1_16x8_3f0d1b41cd9b502f_2$EXT"
cp "_temp/SUPER MARIO 64#8A898584#3#0_all$EXT" "$PORT/Letters/16x8/Special/tex1_16x8_5be798c10f91a8be_2$EXT"
cp "_temp/SUPER MARIO 64#8A978693#3#0_all$EXT" "$PORT/Letters/16x8/Special/tex1_16x8_6b01e37d52df5fc9_2$EXT"
cp "_temp/SUPER MARIO 64#8A978774#3#0_all$EXT" "$PORT/Letters/16x8/Special/tex1_16x8_6a636ad991cf7b6a_2$EXT"
cp "_temp/SUPER MARIO 64#8A978783#3#0_all$EXT" "$PORT/Letters/16x8/Special/tex1_16x8_e65404aeba76a802_2$EXT"
cp "_temp/SUPER MARIO 64#C089E260#3#0_all$EXT" "$PORT/Letters/16x8/Special/tex1_16x8_c2ce362c9bec6eb5_2$EXT"
cp "_temp/SUPER MARIO 64#7771686E#3#0_all$EXT" "$PORT/Letters/16x8/Symbols/tex1_16x8_e4fa519f491c777b_2$EXT"
cp "_temp/SUPER MARIO 64#8394A58A#3#0_all$EXT" "$PORT/Letters/16x8/Symbols/tex1_16x8_592b8a0cd15814f4_2$EXT"
cp "_temp/SUPER MARIO 64#92819878#3#0_all$EXT" "$PORT/Letters/16x8/Symbols/tex1_16x8_420965f77ae3d0d8_2$EXT"
cp "_temp/SUPER MARIO 64#92A5A679#3#0_all$EXT" "$PORT/Letters/16x8/Symbols/tex1_16x8_bfdd00ad1d0c372f_2$EXT"
cp "_temp/SUPER MARIO 64#9C937792#3#0_all$EXT" "$PORT/Letters/16x8/Symbols/tex1_16x8_2016deb8d77571ee_2$EXT"
cp "_temp/SUPER MARIO 64#A48A62B0#3#0_all$EXT" "$PORT/Letters/16x8/Symbols/tex1_16x8_8cfd2fefb5fd9b96_2$EXT"
cp "_temp/SUPER MARIO 64#A88FC5A2#3#0_all$EXT" "$PORT/Letters/16x8/Symbols/tex1_16x8_43d750aa9c42d9c3_2$EXT"
cp "_temp/SUPER MARIO 64#B0C2949A#3#0_all$EXT" "$PORT/Letters/16x8/Symbols/tex1_16x8_fe7eced1d9de6350_2$EXT"
cp "_temp/SUPER MARIO 64#D4A575A8#3#0_all$EXT" "$PORT/Letters/16x8/Symbols/tex1_16x8_f1c4a3fe0e09fec7_2$EXT"

cp "_temp/SUPER MARIO 64#5A807466#3#1_all$EXT" "$PORT/Letters/8x8/Capital/A/tex1_8x8_9750b8a980798e84_2$EXT"
cp "_temp/SUPER MARIO 64#767C6068#3#1_all$EXT" "$PORT/Letters/8x8/Capital/B/tex1_8x8_924c8cf17c324a62_2$EXT"
cp "_temp/SUPER MARIO 64#78986182#3#1_all$EXT" "$PORT/Letters/8x8/Capital/C/tex1_8x8_72a817e8f9a59690_2$EXT"
cp "_temp/SUPER MARIO 64#7C697070#3#1_all$EXT" "$PORT/Letters/8x8/Capital/D (Europe)/tex1_8x8_6ec770d8abf5b2a0_2$EXT"
cp "_temp/SUPER MARIO 64#786B7070#3#1_all$EXT" "$PORT/Letters/8x8/Capital/D (USA)/tex1_8x8_f14171d65d42dce6_2$EXT"
cp "_temp/SUPER MARIO 64#88788776#3#1_all$EXT" "$PORT/Letters/8x8/Capital/E/tex1_8x8_1186d0ace661a53e_2$EXT"
cp "_temp/SUPER MARIO 64#84788778#3#1_all$EXT" "$PORT/Letters/8x8/Capital/F/tex1_8x8_b6351c6288ea3bab_2$EXT"
cp "_temp/SUPER MARIO 64#68886576#3#1_all$EXT" "$PORT/Letters/8x8/Capital/G/tex1_8x8_96880e8ecd223fc4_2$EXT"
cp "_temp/SUPER MARIO 64#846A6656#3#1_all$EXT" "$PORT/Letters/8x8/Capital/H/tex1_8x8_3c3e29ca8f46a5a2_2$EXT"
cp "_temp/SUPER MARIO 64#788C8286#3#1_all$EXT" "$PORT/Letters/8x8/Capital/I/tex1_8x8_a6875c888591c056_2$EXT"
cp "_temp/SUPER MARIO 64#80707E74#3#1_all$EXT" "$PORT/Letters/8x8/Capital/J/tex1_8x8_29c1db792b81b982_2$EXT"
cp "_temp/SUPER MARIO 64#84806080#3#1_all$EXT" "$PORT/Letters/8x8/Capital/K/tex1_8x8_5f67a9d233fdc3aa_2$EXT"
cp "_temp/SUPER MARIO 64#8886887E#3#1_all$EXT" "$PORT/Letters/8x8/Capital/L/tex1_8x8_ae3f8eb920d0be52_2$EXT"
cp "_temp/SUPER MARIO 64#A65A6E86#3#1_all$EXT" "$PORT/Letters/8x8/Capital/M/tex1_8x8_cb9c70ef3d52f6c9_2$EXT"
cp "_temp/SUPER MARIO 64#964A7E66#3#1_all$EXT" "$PORT/Letters/8x8/Capital/N/tex1_8x8_7c9485a98847a1de_2$EXT"
cp "_temp/SUPER MARIO 64#68886272#3#1_all$EXT" "$PORT/Letters/8x8/Capital/O/tex1_8x8_989f0560a3a8f0e3_2$EXT"
cp "_temp/SUPER MARIO 64#5A967A74#3#1_all$EXT" "$PORT/Letters/8x8/Capital/P/tex1_8x8_660cdd56c2a7c7e8_2$EXT"
cp "_temp/SUPER MARIO 64#56886274#3#1_all$EXT" "$PORT/Letters/8x8/Capital/Q/tex1_8x8_2ae8e5a474e156f6_2$EXT"
cp "_temp/SUPER MARIO 64#4C947C72#3#1_all$EXT" "$PORT/Letters/8x8/Capital/R/tex1_8x8_7517cee75d48c7a0_2$EXT"
cp "_temp/SUPER MARIO 64#729C6184#3#1_all$EXT" "$PORT/Letters/8x8/Capital/S/tex1_8x8_0e5fb7920a9422ba_2$EXT"
cp "_temp/SUPER MARIO 64#8C748686#3#1_all$EXT" "$PORT/Letters/8x8/Capital/T/tex1_8x8_67e545da47bf9783_2$EXT"
cp "_temp/SUPER MARIO 64#8A6A5E6E#3#1_all$EXT" "$PORT/Letters/8x8/Capital/U/tex1_8x8_904ad88ef6aa1941_2$EXT"
cp "_temp/SUPER MARIO 64#92766B78#3#1_all$EXT" "$PORT/Letters/8x8/Capital/V/tex1_8x8_e5e1e616ecc99b5c_2$EXT"
cp "_temp/SUPER MARIO 64#945C9872#3#1_all$EXT" "$PORT/Letters/8x8/Capital/W/tex1_8x8_1089a27d25505383_2$EXT"
cp "_temp/SUPER MARIO 64#646A9C64#3#1_all$EXT" "$PORT/Letters/8x8/Capital/X/tex1_8x8_c2a4c3e5b2e3113d_2$EXT"
cp "_temp/SUPER MARIO 64#9A6D7782#3#1_all$EXT" "$PORT/Letters/8x8/Capital/Y/tex1_8x8_abb73aaaede7ba16_2$EXT"
cp "_temp/SUPER MARIO 64#7C9E686E#3#1_all$EXT" "$PORT/Letters/8x8/Capital/Z/tex1_8x8_1fa123c53a2f7520_2$EXT"
cp "_temp/SUPER MARIO 64#8A748466#3#1_all$EXT" "$PORT/Letters/8x8/Numerals/0/tex1_8x8_7994ffc5d5cc3ad6_2$EXT"
cp "_temp/SUPER MARIO 64#82868870#3#1_all$EXT" "$PORT/Letters/8x8/Numerals/1/tex1_8x8_c9fbe2be25cb9811_2$EXT"
cp "_temp/SUPER MARIO 64#44789E8C#3#1_all$EXT" "$PORT/Letters/8x8/Numerals/2/tex1_8x8_0c5444115a395440_2$EXT"
cp "_temp/SUPER MARIO 64#6C889C54#3#1_all$EXT" "$PORT/Letters/8x8/Numerals/3/tex1_8x8_b87d91d127cad8fa_2$EXT"
cp "_temp/SUPER MARIO 64#527E926C#3#1_all$EXT" "$PORT/Letters/8x8/Numerals/4/tex1_8x8_e530cbac0a43b06e_2$EXT"
cp "_temp/SUPER MARIO 64#7A96785C#3#1_all$EXT" "$PORT/Letters/8x8/Numerals/5/tex1_8x8_2504305f23c62bb7_2$EXT"
cp "_temp/SUPER MARIO 64#7A86845C#3#1_all$EXT" "$PORT/Letters/8x8/Numerals/6/tex1_8x8_8d2d3bf943958b48_2$EXT"
cp "_temp/SUPER MARIO 64#66729882#3#1_all$EXT" "$PORT/Letters/8x8/Numerals/7/tex1_8x8_4dc23c9ff6cff482_2$EXT"
cp "_temp/SUPER MARIO 64#688C825C#3#1_all$EXT" "$PORT/Letters/8x8/Numerals/8/tex1_8x8_962f6165226edb2f_2$EXT"
cp "_temp/SUPER MARIO 64#72768866#3#1_all$EXT" "$PORT/Letters/8x8/Numerals/9/tex1_8x8_eb054de7056a0180_2$EXT"
cp "_temp/SUPER MARIO 64#86888984#3#1_all$EXT" "$PORT/Letters/8x8/Punctuation/Europe/tex1_8x8_9e233f012ad76700_2$EXT"
cp "_temp/SUPER MARIO 64#8A848688#3#1_all$EXT" "$PORT/Letters/8x8/Punctuation/Europe/tex1_8x8_c9392be5ff329e74_2$EXT"
cp "_temp/SUPER MARIO 64#607A828A#3#1_all$EXT" "$PORT/Letters/8x8/Punctuation/tex1_8x8_29cc7611afff1395_2$EXT"
cp "_temp/SUPER MARIO 64#86848A88#3#1_all$EXT" "$PORT/Letters/8x8/Punctuation/tex1_8x8_d2745ecf3c81216e_2$EXT"
cp "_temp/SUPER MARIO 64#6EB46458#3#1_all$EXT" "$PORT/Letters/8x8/Punctuation/tex1_8x8_2b2a496ab362c38d_2$EXT"
cp "_temp/SUPER MARIO 64#80788486#3#1_all$EXT" "$PORT/Letters/8x8/Punctuation/tex1_8x8_4e202ca8e40efe85_2$EXT"
cp "_temp/SUPER MARIO 64#82888684#3#1_all$EXT" "$PORT/Letters/8x8/Punctuation/tex1_8x8_a1fa041e17b721f9_2$EXT"
cp "_temp/SUPER MARIO 64#86868886#3#1_all$EXT" "$PORT/Letters/8x8/Punctuation/tex1_8x8_0500e128f7891ea9_2$EXT"
cp "_temp/SUPER MARIO 64#88898880#3#1_all$EXT" "$PORT/Letters/8x8/Punctuation/tex1_8x8_a9105515d220510a_2$EXT"
cp "_temp/SUPER MARIO 64#8C868486#3#1_all$EXT" "$PORT/Letters/8x8/Punctuation/tex1_8x8_1e8de0815ac35005_2$EXT"
cp "_temp/SUPER MARIO 64#7A7E7984#3#1_all$EXT" "$PORT/Letters/8x8/Special/tex1_8x8_fefd18e40f977ef7_2$EXT"
cp "_temp/SUPER MARIO 64#8C869674#3#1_all$EXT" "$PORT/Letters/8x8/Special/tex1_8x8_76b0194fdcf3d196_2$EXT"
cp "_temp/SUPER MARIO 64#4C8A74AC#3#1_all$EXT" "$PORT/Letters/8x8/Symbols/tex1_8x8_b7702871b2fa1709_2$EXT"
cp "_temp/SUPER MARIO 64#686C9480#3#1_all$EXT" "$PORT/Letters/8x8/Symbols/tex1_8x8_dfee502d2f1d16dc_2$EXT"
cp "_temp/SUPER MARIO 64#76406E6E#3#1_all$EXT" "$PORT/Letters/8x8/Symbols/tex1_8x8_4cd450cf01b52d86_2$EXT"
cp "_temp/SUPER MARIO 64#7E87867A#3#1_all$EXT" "$PORT/Letters/8x8/Symbols/tex1_8x8_3e0493c94f963dfb_2$EXT"
cp "_temp/SUPER MARIO 64#C4F693E5#3#1_all$EXT" "$PORT/Letters/8x8/Symbols/tex1_8x8_0915820923ccf3bc_2$EXT"

cp "_temp/SUPER MARIO 64#02330CCD#0#2_all$EXT" "$PORT/Letters/Credits/tex1_8x8_d0c7f770ccd5ff6a_5$EXT"
cp "_temp/SUPER MARIO 64#1CB6DC98#0#2_all$EXT" "$PORT/Letters/Credits/tex1_8x8_6463d65e5d8ce4d0_5$EXT"
cp "_temp/SUPER MARIO 64#2447B7F9#0#2_all$EXT" "$PORT/Letters/Credits/tex1_8x8_b0ffec3f1b87eca5_5$EXT"
cp "_temp/SUPER MARIO 64#24E61683#0#2_all$EXT" "$PORT/Letters/Credits/tex1_8x8_d89bc61d428734f2_5$EXT"
cp "_temp/SUPER MARIO 64#276489C6#0#2_all$EXT" "$PORT/Letters/Credits/tex1_8x8_8248df3db0003b37_5$EXT"
cp "_temp/SUPER MARIO 64#2811C57F#0#2_all$EXT" "$PORT/Letters/Credits/tex1_8x8_d2a1dd5b3a260763_5$EXT"
cp "_temp/SUPER MARIO 64#2D898713#0#2_all$EXT" "$PORT/Letters/Credits/tex1_8x8_bf49903374cd8cf3_5$EXT"
cp "_temp/SUPER MARIO 64#38AFCD8F#0#2_all$EXT" "$PORT/Letters/Credits/tex1_8x8_2efe350c9e1fcb3f_5$EXT"
cp "_temp/SUPER MARIO 64#39E90B67#0#2_all$EXT" "$PORT/Letters/Credits/tex1_8x8_7de947fe0749c789_5$EXT"
cp "_temp/SUPER MARIO 64#3CE9E494#0#2_all$EXT" "$PORT/Letters/Credits/tex1_8x8_04c9e2f23faa5e36_5$EXT"
cp "_temp/SUPER MARIO 64#3DE0ED4E#0#2_all$EXT" "$PORT/Letters/Credits/tex1_8x8_56a61f5d4b9f5e42_5$EXT"
cp "_temp/SUPER MARIO 64#48A3E423#0#2_all$EXT" "$PORT/Letters/Credits/tex1_8x8_bb30fa34d49f8622_5$EXT"
cp "_temp/SUPER MARIO 64#4EE951E9#0#2_all$EXT" "$PORT/Letters/Credits/tex1_8x8_798ba21a561b39fa_5$EXT"
cp "_temp/SUPER MARIO 64#75D9483A#0#2_all$EXT" "$PORT/Letters/Credits/tex1_8x8_c5729f1cf5ba1a1e_5$EXT"
cp "_temp/SUPER MARIO 64#784949CA#0#2_all$EXT" "$PORT/Letters/Credits/tex1_8x8_1410b61019c50bbe_5$EXT"
cp "_temp/SUPER MARIO 64#962278D5#0#2_all$EXT" "$PORT/Letters/Credits/tex1_8x8_e767f3f17fc8f1f5_5$EXT"
cp "_temp/SUPER MARIO 64#988F8D4A#0#2_all$EXT" "$PORT/Letters/Credits/tex1_8x8_82b1427600a43696_5$EXT"
cp "_temp/SUPER MARIO 64#9AE320D1#0#2_all$EXT" "$PORT/Letters/Credits/tex1_8x8_c9a6cc2b81bdbf5f_5$EXT"
cp "_temp/SUPER MARIO 64#C91C9210#0#2_all$EXT" "$PORT/Letters/Credits/tex1_8x8_6e28f784a4fa60e8_5$EXT"
cp "_temp/SUPER MARIO 64#CE8E25FA#0#2_all$EXT" "$PORT/Letters/Credits/tex1_8x8_5b40ac73a1fe8e7a_5$EXT"
cp "_temp/SUPER MARIO 64#D2E92870#0#2_all$EXT" "$PORT/Letters/Credits/tex1_8x8_2efacedb1187edf7_5$EXT"
cp "_temp/SUPER MARIO 64#D6F1A677#0#2_all$EXT" "$PORT/Letters/Credits/tex1_8x8_e982f0d4fd0fa4c4_5$EXT"
cp "_temp/SUPER MARIO 64#D8502FF0#0#2_all$EXT" "$PORT/Letters/Credits/tex1_8x8_b8995ec75b59ad67_5$EXT"
cp "_temp/SUPER MARIO 64#DA971B4E#0#2_all$EXT" "$PORT/Letters/Credits/tex1_8x8_4c3a558174288aa0_5$EXT"
cp "_temp/SUPER MARIO 64#E67C070B#0#2_all$EXT" "$PORT/Letters/Credits/tex1_8x8_80a0f8eb239da3a5_5$EXT"
cp "_temp/SUPER MARIO 64#ECD57CE8#0#2_all$EXT" "$PORT/Letters/Credits/tex1_8x8_b0d25545071fbadd_5$EXT"
cp "_temp/SUPER MARIO 64#F2979267#0#2_all$EXT" "$PORT/Letters/Credits/tex1_8x8_b44280c9cae05a32_5$EXT"
cp "_temp/SUPER MARIO 64#FC58ED51#0#2_all$EXT" "$PORT/Letters/Credits/tex1_8x8_4d6b75ec18921d07_5$EXT"

cp "_temp/SUPER MARIO 64#A23342E2#0#2_all$EXT" "$PORT/Objects/1-UP/tex1_32x64_9ea08c01cdc918cf_5$EXT"

cp "_temp/SUPER MARIO 64#25EE1BA5#0#2_all$EXT" "$PORT/Objects/Blue Coin Switch/tex1_32x16_df09434ac0865649_5$EXT"
cp "_temp/SUPER MARIO 64#875630D6#0#2_all$EXT" "$PORT/Objects/Blue Coin Switch/tex1_32x32_145468f6a5d087c2_5$EXT"

cp "_temp/SUPER MARIO 64#AE1D5DC1#0#2_all$EXT" "$PORT/Objects/Bomb/tex1_32x32_8e8e0ce8cfbd6963_5$EXT"
cp "_temp/SUPER MARIO 64#C2050F68#0#2_all$EXT" "$PORT/Objects/Bomb/tex1_32x64_5faadb69241e708f_5$EXT"
cp "_temp/SUPER MARIO 64#C82A46F3#0#2_all$EXT" "$PORT/Objects/Bomb/tex1_32x64_4e33d5cc287d9bc4_5$EXT"

cp "_temp/SUPER MARIO 64#1F04DAF4#0#2_all$EXT" "$PORT/Objects/Boxes/tex1_32x32_a0b8250259e3dd31_5$EXT"
cp "_temp/SUPER MARIO 64#23F84D6A#0#2_all$EXT" "$PORT/Objects/Boxes/tex1_32x32_fff7b81821aea8cb_5$EXT"
cp "_temp/SUPER MARIO 64#428D4124#0#2_all$EXT" "$PORT/Objects/Boxes/tex1_64x32_3126ebed56f533a9_5$EXT"
cp "_temp/SUPER MARIO 64#4838A16E#0#2_all$EXT" "$PORT/Objects/Boxes/tex1_32x64_373e9ab08d08c07b_5$EXT"
cp "_temp/SUPER MARIO 64#7E5C3A04#0#2_all$EXT" "$PORT/Objects/Boxes/tex1_32x32_7b8b00ea75420cae_5$EXT"
cp "_temp/SUPER MARIO 64#7EBE7D5E#0#2_all$EXT" "$PORT/Objects/Boxes/tex1_32x32_b46c088207f9518f_5$EXT"
cp "_temp/SUPER MARIO 64#8413A8FA#0#2_all$EXT" "$PORT/Objects/Boxes/tex1_64x32_2f47792a8cdfadf3_5$EXT"
cp "_temp/SUPER MARIO 64#A765AAA8#0#2_all$EXT" "$PORT/Objects/Boxes/tex1_32x32_d7b3014036b1eb2e_5$EXT"
cp "_temp/SUPER MARIO 64#B16EDFA9#0#2_all$EXT" "$PORT/Objects/Boxes/tex1_32x64_a3f621625f087877_5$EXT"
cp "_temp/SUPER MARIO 64#D17F99C6#0#2_all$EXT" "$PORT/Objects/Boxes/tex1_16x32_6625b22d7bc9558c_5$EXT"

cp "_temp/SUPER MARIO 64#C9F30BAF#0#2_all$EXT" "$PORT/Objects/Breakable Box/tex1_32x32_d3e6ddc23b212a6e_5$EXT"
cp "_temp/SUPER MARIO 64#FDDF5C31#0#2_all$EXT" "$PORT/Objects/Breakable Box/tex1_32x32_304db5619e3f7e41_5$EXT"

cp "_temp/SUPER MARIO 64#0612269D#0#2_all$EXT" "$PORT/Objects/Cannon/tex1_32x32_1f0b19322df687f7_5$EXT"
cp "_temp/SUPER MARIO 64#94776F27#0#2_all$EXT" "$PORT/Objects/Cannon/tex1_32x32_a3bf20f299cfc231_5$EXT"
cp "_temp/SUPER MARIO 64#E0BB9B61#0#2_all$EXT" "$PORT/Objects/Cannon/tex1_32x32_83d254f4b29c1970_5$EXT"

cp "_temp/SUPER MARIO 64#1F71DA85#0#2_all$EXT" "$PORT/Objects/Cap Switch/tex1_16x4_676baee5eddd158c_5$EXT"
cp "_temp/SUPER MARIO 64#D2A05119#3#2_all$EXT" "$PORT/Objects/Cap Switch/tex1_32x64_7b805ed6cac18bef_3$EXT"

cp "_temp/SUPER MARIO 64#A6E1B26B#0#2_all$EXT" "$PORT/Objects/Chair/unused/tex1_32x32_9f4d8f094a242374_5$EXT"
cp "_temp/SUPER MARIO 64#1195AECC#0#2_all$EXT" "$PORT/Objects/Chair/tex1_16x32_899bcdbb06e3ce86_5$EXT"
cp "_temp/SUPER MARIO 64#1198C8AB#0#2_all$EXT" "$PORT/Objects/Chair/tex1_32x32_2e0ec8671ee9296d_5$EXT"
cp "_temp/SUPER MARIO 64#21BFEA1A#0#2_all$EXT" "$PORT/Objects/Chair/tex1_32x32_4af81938d60058b9_5$EXT"

cp "_temp/SUPER MARIO 64#3486BF66#0#2_all$EXT" "$PORT/Objects/Checkerboard Platform/tex1_32x16_09b982c51b27bb6a_5$EXT"
cp "_temp/SUPER MARIO 64#BC16978D#0#2_all$EXT" "$PORT/Objects/Checkerboard Platform/tex1_32x32_cf22be82ff5f915c_5$EXT"

cp "_temp/SUPER MARIO 64#176C2E93#3#2_all$EXT" "$PORT/Objects/Coin/tex1_32x32_c2f05c97279b236c_3$EXT"
cp "_temp/SUPER MARIO 64#6906C074#3#2_all$EXT" "$PORT/Objects/Coin/tex1_32x32_1f80d3535013958a_3$EXT"
cp "_temp/SUPER MARIO 64#E5BCF46E#3#2_all$EXT" "$PORT/Objects/Coin/tex1_32x32_8ba91ab6d74ec900_3$EXT"
cp "_temp/SUPER MARIO 64#FBE08CAB#3#2_all$EXT" "$PORT/Objects/Coin/tex1_32x32_4404bb9fcf5f0a1c_3$EXT"

cp "_temp/SUPER MARIO 64#0DF6BDFF#0#2_all$EXT" "$PORT/Objects/Doors/tex1_32x32_7194fce4c14058c4_5$EXT"
cp "_temp/SUPER MARIO 64#12733B4F#0#2_all$EXT" "$PORT/Objects/Doors/tex1_32x64_13b461cd51ba5ad7_5$EXT"
cp "_temp/SUPER MARIO 64#1EBAE88A#0#2_all$EXT" "$PORT/Objects/Doors/tex1_32x64_262e9a608a82acb6_5$EXT"
cp "_temp/SUPER MARIO 64#2AAB5196#0#2_all$EXT" "$PORT/Objects/Doors/tex1_32x32_92c2f956537c51ee_5$EXT"
cp "_temp/SUPER MARIO 64#2F5F1297#0#2_all$EXT" "$PORT/Objects/Doors/tex1_32x64_ea55929639b463d5_5$EXT"
cp "_temp/SUPER MARIO 64#401B923F#0#2_all$EXT" "$PORT/Objects/Doors/tex1_32x64_5f3730d5d3f221dd_5$EXT"
cp "_temp/SUPER MARIO 64#4EB8714C#0#2_all$EXT" "$PORT/Objects/Doors/tex1_32x32_3df5973a05d07ef9_5$EXT"
cp "_temp/SUPER MARIO 64#877137A9#0#2_all$EXT" "$PORT/Objects/Doors/tex1_32x64_75e59709333837cf_5$EXT"
cp "_temp/SUPER MARIO 64#93D4EE01#0#2_all$EXT" "$PORT/Objects/Doors/tex1_32x32_e0da5a8b963a42e9_5$EXT"
cp "_temp/SUPER MARIO 64#9965C006#0#2_all$EXT" "$PORT/Objects/Doors/tex1_32x64_ea4d47fcc6df7f08_5$EXT"
cp "_temp/SUPER MARIO 64#9A5A2FB3#0#2_all$EXT" "$PORT/Objects/Doors/tex1_32x32_ff2f3f48eb8b43b3_5$EXT"
cp "_temp/SUPER MARIO 64#9C977CFF#0#2_all$EXT" "$PORT/Objects/Doors/tex1_32x32_062e82929587ae3d_5$EXT"
cp "_temp/SUPER MARIO 64#BBC6B061#0#2_all$EXT" "$PORT/Objects/Doors/tex1_16x32_097218fb50f61900_5$EXT"
cp "_temp/SUPER MARIO 64#C99B5909#0#2_all$EXT" "$PORT/Objects/Doors/tex1_32x32_11d2463d40e01987_5$EXT"
cp "_temp/SUPER MARIO 64#F2897E05#0#2_all$EXT" "$PORT/Objects/Doors/tex1_32x64_000aca09fc4524f6_5$EXT"
cp "_temp/SUPER MARIO 64#FD820701#0#2_all$EXT" "$PORT/Objects/Doors/tex1_32x64_bf5e688992e04b71_5$EXT"
cp "_temp/SUPER MARIO 64#FD820701#0#2_all$EXT" "$PORT/Objects/Doors/Injects/tex1_32x64_b6f4d48c9d5a3c60_5$EXT"

cp "_temp/SUPER MARIO 64#CD5F7595#0#2_all$EXT" "$PORT/Objects/Heart/tex1_32x32_17d9f590cf913c3b_5$EXT"

cp "_temp/SUPER MARIO 64#3F817C21#0#2_all$EXT" "$PORT/Objects/Lava/tex1_32x32_c7d261cf9c0349a2_5$EXT"

cp "_temp/SUPER MARIO 64#946F580C#0#2_all$EXT" "$PORT/Objects/Metal Box/tex1_32x64_b6876feb74e2fe3c_5$EXT"

cp "_temp/SUPER MARIO 64#67A98771#0#2_all$EXT" "$PORT/Objects/Pipe/tex1_32x32_e7ba81c084d355d2_5$EXT"
cp "_temp/SUPER MARIO 64#E9CABB44#0#2_all$EXT" "$PORT/Objects/Pipe/tex1_32x64_219900f7f0716675_5$EXT"

cp "_temp/SUPER MARIO 64#31B77240#0#2_all$EXT" "$PORT/Objects/Poundable Pole/tex1_32x32_0d384cc8c63b19b2_5$EXT"
cp "_temp/SUPER MARIO 64#90027A49#0#2_all$EXT" "$PORT/Objects/Poundable Pole/tex1_32x32_9006c76e14ec9376_5$EXT"

cp "_temp/SUPER MARIO 64#3AC6C19C#0#2_all$EXT" "$PORT/Objects/Purple Switch/tex1_16x32_25bb87b77460045a_5$EXT"
cp "_temp/SUPER MARIO 64#CD381281#0#2_all$EXT" "$PORT/Objects/Purple Switch/tex1_16x4_d8346c483d5ed45a_5$EXT"

cp "_temp/SUPER MARIO 64#125E068D#0#2_all$EXT" "$PORT/Objects/Sign/tex1_32x32_16881e115d9f59fc_5$EXT"
cp "_temp/SUPER MARIO 64#F09D711E#0#2_all$EXT" "$PORT/Objects/Sign/tex1_32x32_4614f1dc97f98ec9_5$EXT"

cp "_temp/SUPER MARIO 64#10E998F8#0#2_all$EXT" "$PORT/Objects/Star/tex1_32x32_7b36cbd381f1a8ae_5$EXT"
cp "_temp/SUPER MARIO 64#1D0F0A8E#0#2_all$EXT" "$PORT/Objects/Star/tex1_32x64_6358a12264f4d9b8_5$EXT"

cp "_temp/SUPER MARIO 64#192FA726#0#2_all$EXT" "$PORT/Objects/Trees/tex1_32x64_054de0def71cdb2b_5$EXT"
cp "_temp/SUPER MARIO 64#3FB69C59#0#2_all$EXT" "$PORT/Objects/Trees/tex1_32x64_7ac6296ee14a1aed_5$EXT"
cp "_temp/SUPER MARIO 64#7AF18328#0#2_all$EXT" "$PORT/Objects/Trees/tex1_32x64_77b1cae7f3084861_5$EXT"
cp "_temp/SUPER MARIO 64#B452CBBE#0#2_all$EXT" "$PORT/Objects/Trees/tex1_32x64_aa7c393295b819ea_5$EXT"
cp "_temp/SUPER MARIO 64#C2E48C81#0#2_all$EXT" "$PORT/Objects/Trees/tex1_32x64_a7f89fecd9e64c64_5$EXT"
cp "_temp/SUPER MARIO 64#C4D1C3CE#0#2_all$EXT" "$PORT/Objects/Trees/tex1_16x16_a74a51c5aaf909d4_5$EXT"

cp "_temp/SUPER MARIO 64#5095921B#0#2_all$EXT" "$PORT/Objects/Water/tex1_32x32_2477d00836c8297d_5$EXT"
cp "_temp/SUPER MARIO 64#DFFBB688#0#2_all$EXT" "$PORT/Objects/Water/tex1_32x32_0823ecf54dc3ff7c_5$EXT"
cp "_temp/SUPER MARIO 64#DFFBB688#3#2_all$EXT" "$PORT/Objects/Water/tex1_32x32_561bb134b3d67bfe_3$EXT"

cp "_temp/SUPER MARIO 64#14C95BA0#0#2_all$EXT" "$PORT/Objects/Water Bubble/tex1_32x32_6df65225c2fca654_5$EXT"

cp "_temp/SUPER MARIO 64#8E41FFCD#0#2_all$EXT" "$PORT/Objects/Yellow Sphere/tex1_32x32_5906e1836bf9efbe_5$EXT"

cp "_temp/SUPER MARIO 64#946E561B#0#2_all$EXT" "$PORT/Paintings/Bob-omb Battlefield/tex1_64x32_f3738070515fcfff_5$EXT"
cp "_temp/SUPER MARIO 64#FC4B4762#0#2_all$EXT" "$PORT/Paintings/Bob-omb Battlefield/tex1_64x32_9706da8cc6b48fee_5$EXT"
cp "_temp/SUPER MARIO 64#1C786EE9#0#2_all$EXT" "$PORT/Paintings/Bowser/tex1_32x32_40d34e2f70a8eaa8_5$EXT"
cp "_temp/SUPER MARIO 64#8D030865#0#2_all$EXT" "$PORT/Paintings/Bowser/tex1_32x32_458a58bb60f20742_5$EXT"
cp "_temp/SUPER MARIO 64#B1237167#0#2_all$EXT" "$PORT/Paintings/Bowser/tex1_32x32_1f40fbce1dd99cfb_5$EXT"
cp "_temp/SUPER MARIO 64#EB871023#0#2_all$EXT" "$PORT/Paintings/Bowser/tex1_32x32_006b8ae23826e999_5$EXT"
cp "_temp/SUPER MARIO 64#95C4562E#0#2_all$EXT" "$PORT/Paintings/Cool Cool Mountain/tex1_64x32_ee0f6e01bb0069d6_5$EXT"
cp "_temp/SUPER MARIO 64#B5AC8928#0#2_all$EXT" "$PORT/Paintings/Cool Cool Mountain/tex1_64x32_b8a1cd697c4fffce_5$EXT"
cp "_temp/SUPER MARIO 64#27183C4F#0#2_all$EXT" "$PORT/Paintings/Dire Dire Docks/tex1_32x32_2f942b8af01f1a66_5$EXT"
cp "_temp/SUPER MARIO 64#08B8530E#0#2_all$EXT" "$PORT/Paintings/Jolly Roger Bay/tex1_64x32_0156a7edf54e412a_5$EXT"
cp "_temp/SUPER MARIO 64#1A4BCC77#0#2_all$EXT" "$PORT/Paintings/Jolly Roger Bay/tex1_64x32_102bba4a01b6b652_5$EXT"
cp "_temp/SUPER MARIO 64#8300DD14#0#2_all$EXT" "$PORT/Paintings/Lethal Lava Land/tex1_64x32_391bf1bf9d5c7a3b_5$EXT"
cp "_temp/SUPER MARIO 64#A8FF4543#0#2_all$EXT" "$PORT/Paintings/Lethal Lava Land/tex1_64x32_a20bde6b2d3ef8f1_5$EXT"
cp "_temp/SUPER MARIO 64#678BBBC1#0#2_all$EXT" "$PORT/Paintings/Peach/tex1_32x32_95dab89a5a79a1a4_5$EXT"
cp "_temp/SUPER MARIO 64#73D7C121#0#2_all$EXT" "$PORT/Paintings/Peach/tex1_32x32_2a43fe77a7aca583_5$EXT"
cp "_temp/SUPER MARIO 64#A08E284C#0#2_all$EXT" "$PORT/Paintings/Peach/tex1_32x32_da66b95eacf2ad5f_5$EXT"
cp "_temp/SUPER MARIO 64#CB7B6E97#0#2_all$EXT" "$PORT/Paintings/Peach/tex1_32x32_a47fda6bacdce3bd_5$EXT"
cp "_temp/SUPER MARIO 64#CCA2987C#0#2_all$EXT" "$PORT/Paintings/Shifting Sand Land/tex1_64x32_717a1a27d05322e5_5$EXT"
cp "_temp/SUPER MARIO 64#D2A1C338#0#2_all$EXT" "$PORT/Paintings/Shifting Sand Land/tex1_64x32_8cc1e2b5ed66f78e_5$EXT"
cp "_temp/SUPER MARIO 64#33AE70AA#0#2_all$EXT" "$PORT/Paintings/Snowman's Land/tex1_64x32_00dbd0bd1a5c04ff_5$EXT"
cp "_temp/SUPER MARIO 64#6FF2AAC5#0#2_all$EXT" "$PORT/Paintings/Snowman's Land/tex1_64x32_cb7364a0075a59a3_5$EXT"
cp "_temp/SUPER MARIO 64#603AB9FE#0#2_all$EXT" "$PORT/Paintings/Tall Tall Mountain/tex1_64x32_d132df0deed68d72_5$EXT"
cp "_temp/SUPER MARIO 64#FE391DDB#0#2_all$EXT" "$PORT/Paintings/Tall Tall Mountain/tex1_64x32_3db84e36e18baae5_5$EXT"
cp "_temp/SUPER MARIO 64#239F9E44#0#2_all$EXT" "$PORT/Paintings/Tick Tock Clock/tex1_64x32_20b64524e693fe6a_5$EXT"
cp "_temp/SUPER MARIO 64#981FC4C1#0#2_all$EXT" "$PORT/Paintings/Tick Tock Clock/tex1_64x32_798ff6eedcbccdf9_5$EXT"
cp "_temp/SUPER MARIO 64#8B6C6929#0#2_all$EXT" "$PORT/Paintings/Tiny-Huge Island/tex1_64x32_503eee47057831e1_5$EXT"
cp "_temp/SUPER MARIO 64#DEAE047B#0#2_all$EXT" "$PORT/Paintings/Tiny-Huge Island/tex1_64x32_f9ac9c1a12dd1d4e_5$EXT"
cp "_temp/SUPER MARIO 64#B6A89482#0#2_all$EXT" "$PORT/Paintings/Wet-Dry World/tex1_64x32_f6e1a64936594b5e_5$EXT"
cp "_temp/SUPER MARIO 64#E8FABCC5#0#2_all$EXT" "$PORT/Paintings/Wet-Dry World/tex1_64x32_b68d8d731fe5b8a0_5$EXT"
cp "_temp/SUPER MARIO 64#88493238#0#2_all$EXT" "$PORT/Paintings/Whomp's Fortress/tex1_64x32_8b4f4e9e0c631ab4_5$EXT"
cp "_temp/SUPER MARIO 64#90EF51BB#0#2_all$EXT" "$PORT/Paintings/Whomp's Fortress/tex1_64x32_65e8949ad257cd2e_5$EXT"

cp "_temp/SUPER MARIO 64#46BEFF45#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/tex1_32x32_01e09ae58c9d1124_5$EXT"
cp "_temp/SUPER MARIO 64#5E819C11#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/tex1_32x32_04b9ac803740baf4_5$EXT"
cp "_temp/SUPER MARIO 64#BD9C82DE#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/tex1_32x32_09c420e307183277_5$EXT"
cp "_temp/SUPER MARIO 64#BE721E4B#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/tex1_32x32_1d0f732ab1e38905_5$EXT"
cp "_temp/SUPER MARIO 64#E2FAD209#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/tex1_32x32_24ca50b94246f2ef_5$EXT"
cp "_temp/SUPER MARIO 64#0D6A8490#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/tex1_32x32_2a42bc7a318ba7bb_5$EXT"
cp "_temp/SUPER MARIO 64#B45578DC#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/tex1_32x32_2c3c1ef8b4e1c2be_5$EXT"
cp "_temp/SUPER MARIO 64#4ED18843#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/tex1_32x32_31a0abc51a887189_5$EXT"
cp "_temp/SUPER MARIO 64#51B5CD93#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/tex1_32x32_425fd87ad9c14208_5$EXT"
cp "_temp/SUPER MARIO 64#888F7075#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/tex1_32x32_432dbe0bc45f45c4_5$EXT"
cp "_temp/SUPER MARIO 64#BA8930C5#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/tex1_32x32_48654b2796b17824_5$EXT"
cp "_temp/SUPER MARIO 64#72D28485#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/tex1_32x32_517b50fb418c0d34_5$EXT"
cp "_temp/SUPER MARIO 64#C99F67F2#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/tex1_32x32_55f80764db617120_5$EXT"
cp "_temp/SUPER MARIO 64#5691C606#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/tex1_32x32_57116cbe0f69712a_5$EXT"
cp "_temp/SUPER MARIO 64#543AE92E#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/tex1_32x32_5f0486938afd0d80_5$EXT"
cp "_temp/SUPER MARIO 64#0571FC7C#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/tex1_32x32_66b68e07eef8f779_5$EXT"
cp "_temp/SUPER MARIO 64#63820423#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/tex1_32x32_67e8b577b2c781fc_5$EXT"
cp "_temp/SUPER MARIO 64#02429854#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/tex1_32x32_701f55cf5e86fc8e_5$EXT"
cp "_temp/SUPER MARIO 64#B3F25163#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/tex1_32x32_7c60d57cbc720513_5$EXT"
cp "_temp/SUPER MARIO 64#AA5A7898#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/tex1_32x32_80c22fd6b179381a_5$EXT"
cp "_temp/SUPER MARIO 64#EB0DFB0A#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/tex1_32x32_815ebd227790ff46_5$EXT"
cp "_temp/SUPER MARIO 64#8EDC5BE4#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/tex1_32x32_823e21cdf74e4298_5$EXT"
cp "_temp/SUPER MARIO 64#9E520CB2#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/tex1_32x32_838f88a08aad1d11_5$EXT"
cp "_temp/SUPER MARIO 64#C55CA18E#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/tex1_32x32_83fda7f4cef0f800_5$EXT"
cp "_temp/SUPER MARIO 64#B616A7C2#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/tex1_32x32_8ec3aeee3740ea2d_5$EXT"
cp "_temp/SUPER MARIO 64#ACEC3F69#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/tex1_32x32_902c2fc31cdf7f38_5$EXT"
cp "_temp/SUPER MARIO 64#7F0C0D1A#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/tex1_32x32_97f5dc8951bfe343_5$EXT"
cp "_temp/SUPER MARIO 64#5DDD4BF0#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/tex1_32x32_a2f5715ef4955ffe_5$EXT"
cp "_temp/SUPER MARIO 64#165F940A#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/tex1_32x32_a77d532d7e6d50b4_5$EXT"
cp "_temp/SUPER MARIO 64#6E88F5E0#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/tex1_32x32_a85e701109ba55a5_5$EXT"
cp "_temp/SUPER MARIO 64#9C6FA38A#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/tex1_32x32_ac3b755430121b47_5$EXT"
cp "_temp/SUPER MARIO 64#F5E69D71#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/tex1_32x32_b942b307997075d8_5$EXT"
cp "_temp/SUPER MARIO 64#73276400#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/tex1_32x32_bac7bb0cd2fae01b_5$EXT"
cp "_temp/SUPER MARIO 64#9663B6F7#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/tex1_32x32_d2b4f5ea4662ca5f_5$EXT"
cp "_temp/SUPER MARIO 64#869D1C9B#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/tex1_32x32_d94df7b8f054a14a_5$EXT"
cp "_temp/SUPER MARIO 64#3556A0C8#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/tex1_32x32_de9517151f206807_5$EXT"
cp "_temp/SUPER MARIO 64#339B3765#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/tex1_32x32_e0723f88de4c14aa_5$EXT"
cp "_temp/SUPER MARIO 64#AF7B75C2#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/tex1_32x32_ee52ca8e028111a2_5$EXT"
cp "_temp/SUPER MARIO 64#D678C04F#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/tex1_32x32_f724dbdcf022bbd1_5$EXT"
cp "_temp/SUPER MARIO 64#D910F455#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/tex1_32x32_fa0a1ba6174a7fdb_5$EXT"

cp "_temp/SUPER MARIO 64#22253C7E#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_063842d3c0c01d03_5$EXT"
cp "_temp/SUPER MARIO 64#FC6EF688#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_0666c001a4612992_5$EXT"
cp "_temp/SUPER MARIO 64#C4C331E8#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_08b19f498149602a_5$EXT"
cp "_temp/SUPER MARIO 64#D4FECE2C#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_0f1c7fc3ab4ebbc1_5$EXT"
cp "_temp/SUPER MARIO 64#05D86D02#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_12e7e048b012069c_5$EXT"
cp "_temp/SUPER MARIO 64#DF07ED35#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_155d81e46ee799de_5$EXT"
cp "_temp/SUPER MARIO 64#27D9AF1F#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_15891e22f42497a9_5$EXT"
cp "_temp/SUPER MARIO 64#DE38650F#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_1b30e298ec64b8ed_5$EXT"
cp "_temp/SUPER MARIO 64#BE610D43#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_1f3e0276ab7b2930_5$EXT"
cp "_temp/SUPER MARIO 64#3324B340#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_2e1bccc480782ae5_5$EXT"
cp "_temp/SUPER MARIO 64#7FCB976C#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_302e40261835de68_5$EXT"
cp "_temp/SUPER MARIO 64#1EA893D2#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_350f2db4a54b4717_5$EXT"
cp "_temp/SUPER MARIO 64#ADB81440#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_35f46bb268383f2c_5$EXT"
cp "_temp/SUPER MARIO 64#2CFA4B7F#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_360bc602657d872e_5$EXT"
cp "_temp/SUPER MARIO 64#D97FB4F5#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_384c408c360beef3_5$EXT"
cp "_temp/SUPER MARIO 64#3CCF8886#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_38a50a51229f11d9_5$EXT"
cp "_temp/SUPER MARIO 64#00B11930#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_38f0353424fb2df5_5$EXT"
cp "_temp/SUPER MARIO 64#68C4A756#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_399146c195bb2202_5$EXT"
cp "_temp/SUPER MARIO 64#DC08D520#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_476da6d1d6c91713_5$EXT"
cp "_temp/SUPER MARIO 64#7F5468E5#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_4a6342162dc0c2de_5$EXT"
cp "_temp/SUPER MARIO 64#D8A463DF#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_4b4c414137283a8e_5$EXT"
cp "_temp/SUPER MARIO 64#FAAFF848#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_4d540f89de2379f7_5$EXT"
cp "_temp/SUPER MARIO 64#C39651E5#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_4e873acff686d936_5$EXT"
cp "_temp/SUPER MARIO 64#0EE19C09#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_5651fbdb518ed758_5$EXT"
cp "_temp/SUPER MARIO 64#CB67DA9F#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_59ef1b6b1d8753f4_5$EXT"
cp "_temp/SUPER MARIO 64#718C4694#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_5bf2bb82ed7137db_5$EXT"
cp "_temp/SUPER MARIO 64#310F4C2C#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_640c8606f90c0682_5$EXT"
cp "_temp/SUPER MARIO 64#C4C356FA#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_68092bc758a4bf1b_5$EXT"
cp "_temp/SUPER MARIO 64#46649148#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_6a16a1014b7c78e4_5$EXT"
cp "_temp/SUPER MARIO 64#216A674D#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_6c850b5710746d50_5$EXT"
cp "_temp/SUPER MARIO 64#5B01FAF9#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_8386a810492815ac_5$EXT"
cp "_temp/SUPER MARIO 64#D89FBCA9#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_885a7eda9abaeefd_5$EXT"
cp "_temp/SUPER MARIO 64#A4316E88#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_893944aba7636b95_5$EXT"
cp "_temp/SUPER MARIO 64#D1B72B53#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_8b0326c32c17c93d_5$EXT"
cp "_temp/SUPER MARIO 64#6EB6822E#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_9979891eed9fb186_5$EXT"
cp "_temp/SUPER MARIO 64#5050548F#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_9bd8584efa4332ef_5$EXT"
cp "_temp/SUPER MARIO 64#2FE9009A#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_9f06b350d8be2d99_5$EXT"
cp "_temp/SUPER MARIO 64#908BB0A5#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_a422f10fedd6fa61_5$EXT"
cp "_temp/SUPER MARIO 64#93507E3B#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_aa5b7cdd521c6210_5$EXT"
cp "_temp/SUPER MARIO 64#B2EFD400#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_b2d1c9a1d62826ce_5$EXT"
cp "_temp/SUPER MARIO 64#9E94B9F1#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_b313f2c933d8046e_5$EXT"
cp "_temp/SUPER MARIO 64#2FC064C1#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_b5aa6ea52f71eafc_5$EXT"
cp "_temp/SUPER MARIO 64#92914C1C#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_b5ae910bd8cb57f5_5$EXT"
cp "_temp/SUPER MARIO 64#6218470C#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_b870ff9bfd501138_5$EXT"
cp "_temp/SUPER MARIO 64#18102121#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_c0148b0566665a82_5$EXT"
cp "_temp/SUPER MARIO 64#75F39E26#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_c08398f00dbd4d32_5$EXT"
cp "_temp/SUPER MARIO 64#4CDB236C#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_c0ed13ebddd50bbb_5$EXT"
cp "_temp/SUPER MARIO 64#4E80FA6F#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_c286bea931f281b2_5$EXT"
cp "_temp/SUPER MARIO 64#9F6DD214#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_d54e1650b659b22e_5$EXT"
cp "_temp/SUPER MARIO 64#D660A2AE#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_d7bae0ce459a1f75_5$EXT"
cp "_temp/SUPER MARIO 64#BE5AB2EE#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_dae214748984394f_5$EXT"
cp "_temp/SUPER MARIO 64#AE39BA68#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_db7ac4eed9b05e44_5$EXT"
cp "_temp/SUPER MARIO 64#B76D42DD#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_dcabded0bf2f083d_5$EXT"
cp "_temp/SUPER MARIO 64#8093D98D#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_e276475b303d7c5b_5$EXT"
cp "_temp/SUPER MARIO 64#C30B4FE2#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_e68ff4db093f5652_5$EXT"
cp "_temp/SUPER MARIO 64#CC89FE99#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_e8c0c66c6828fb0d_5$EXT"
cp "_temp/SUPER MARIO 64#7AF76431#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_eea9f5a4c8731de1_5$EXT"
cp "_temp/SUPER MARIO 64#BFE56F11#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_eec13e025e59c62c_5$EXT"
cp "_temp/SUPER MARIO 64#9205F8FC#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_f4c92c6bed7e2ae1_5$EXT"
cp "_temp/SUPER MARIO 64#58C547BD#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_f627ac4869eb372f_5$EXT"
cp "_temp/SUPER MARIO 64#48E57582#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_f903f1705b38cd6b_5$EXT"
cp "_temp/SUPER MARIO 64#BFA0DFE0#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_fa9275436fe8daff_5$EXT"
cp "_temp/SUPER MARIO 64#BE0750A6#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_fd148b4cefe3446b_5$EXT"
cp "_temp/SUPER MARIO 64#937650B4#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/tex1_32x32_fd585a724e1d3f4d_5$EXT"

cp "_temp/SUPER MARIO 64#2FA4B137#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/tex1_32x32_00700e02d11e51de_5$EXT"
cp "_temp/SUPER MARIO 64#A5063ADB#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/tex1_32x32_01ae8aff5a47639e_5$EXT"
cp "_temp/SUPER MARIO 64#FF309AA3#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/tex1_32x32_0370e6d21a1bcaab_5$EXT"
cp "_temp/SUPER MARIO 64#27B1AA10#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/tex1_32x32_05ed16ffe927ce14_5$EXT"
cp "_temp/SUPER MARIO 64#81175ED5#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/tex1_32x32_0fb07c2a06327b00_5$EXT"
cp "_temp/SUPER MARIO 64#9E30AED1#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/tex1_32x32_13132b96f39ecd82_5$EXT"
cp "_temp/SUPER MARIO 64#CE142635#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/tex1_32x32_15e81e40fec0b9a1_5$EXT"
cp "_temp/SUPER MARIO 64#CF390916#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/tex1_32x32_18d09d97aac933de_5$EXT"
cp "_temp/SUPER MARIO 64#9EB76583#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/tex1_32x32_1af9dab877dab5b9_5$EXT"
cp "_temp/SUPER MARIO 64#3342AE2E#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/tex1_32x32_1f57b8afbd324d24_5$EXT"
cp "_temp/SUPER MARIO 64#CEB6CAA7#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/tex1_32x32_2338349beb963be1_5$EXT"
cp "_temp/SUPER MARIO 64#3D7ADDE3#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/tex1_32x32_25a4313de9e99b4b_5$EXT"
cp "_temp/SUPER MARIO 64#9E4203FF#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/tex1_32x32_3293e40ae1e7d57c_5$EXT"
cp "_temp/SUPER MARIO 64#DDBE80A7#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/tex1_32x32_347d18d89282517b_5$EXT"
cp "_temp/SUPER MARIO 64#99302633#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/tex1_32x32_34a48a7fe0ee0bad_5$EXT"
cp "_temp/SUPER MARIO 64#4F1CAC41#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/tex1_32x32_34d323bd26ecfcb3_5$EXT"
cp "_temp/SUPER MARIO 64#22348F8B#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/tex1_32x32_3a282e873c00e79e_5$EXT"
cp "_temp/SUPER MARIO 64#07FF7CD2#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/tex1_32x32_40bd10128ad234ed_5$EXT"
cp "_temp/SUPER MARIO 64#DF0E0D87#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/tex1_32x32_41ca7bc940aaf473_5$EXT"
cp "_temp/SUPER MARIO 64#4783C2BF#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/tex1_32x32_49d8bfc33c7ee89c_5$EXT"
cp "_temp/SUPER MARIO 64#49D68918#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/tex1_32x32_50035b49f495e18e_5$EXT"
cp "_temp/SUPER MARIO 64#DCDCA548#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/tex1_32x32_5645a72af3961dc3_5$EXT"
cp "_temp/SUPER MARIO 64#F8CC42D7#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/tex1_32x32_57202073e7177d82_5$EXT"
cp "_temp/SUPER MARIO 64#B453CC4A#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/tex1_32x32_65834c5f8649a97d_5$EXT"
cp "_temp/SUPER MARIO 64#EF44FC69#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/tex1_32x32_69397b285a166401_5$EXT"
cp "_temp/SUPER MARIO 64#E6959DA0#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/tex1_32x32_76683217e7679c79_5$EXT"
cp "_temp/SUPER MARIO 64#EA566CB8#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/tex1_32x32_7f0c5bb2733550ff_5$EXT"
cp "_temp/SUPER MARIO 64#E398C0E5#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/tex1_32x32_84b5620eac3fe4aa_5$EXT"
cp "_temp/SUPER MARIO 64#5FC183BA#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/tex1_32x32_87ec07c02aa36384_5$EXT"
cp "_temp/SUPER MARIO 64#63860579#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/tex1_32x32_924a1966912b4977_5$EXT"
cp "_temp/SUPER MARIO 64#EE949D98#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/tex1_32x32_a803c2c29947d581_5$EXT"
cp "_temp/SUPER MARIO 64#BB5327E0#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/tex1_32x32_a925ba6e6d4ac1a8_5$EXT"
cp "_temp/SUPER MARIO 64#E69D9617#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/tex1_32x32_b1b53bb511c2d849_5$EXT"
cp "_temp/SUPER MARIO 64#BFAFF600#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/tex1_32x32_b202a8605212d2d9_5$EXT"
cp "_temp/SUPER MARIO 64#6E969590#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/tex1_32x32_b6a1e0bb79e070f4_5$EXT"
cp "_temp/SUPER MARIO 64#A46217AB#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/tex1_32x32_ba5ff11cfc4f6dfe_5$EXT"
cp "_temp/SUPER MARIO 64#6872E4FF#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/tex1_32x32_bb85573182e38b72_5$EXT"
cp "_temp/SUPER MARIO 64#DAA65AFC#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/tex1_32x32_bbcb60ad5d1f2df2_5$EXT"
cp "_temp/SUPER MARIO 64#EF161D97#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/tex1_32x32_c6d7207a60a60fb9_5$EXT"
cp "_temp/SUPER MARIO 64#E00D840E#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/tex1_32x32_cc41ae12278bf735_5$EXT"
cp "_temp/SUPER MARIO 64#E7161D98#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/tex1_32x32_d8de8a55dc15604b_5$EXT"
cp "_temp/SUPER MARIO 64#B8AB2C4E#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/tex1_32x32_d9be3a14141b5262_5$EXT"
cp "_temp/SUPER MARIO 64#07155D85#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/tex1_32x32_e74d9dc4dc43c3b1_5$EXT"
cp "_temp/SUPER MARIO 64#E6061D88#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/tex1_32x32_e8a243048cd9155c_5$EXT"
cp "_temp/SUPER MARIO 64#F9889333#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/tex1_32x32_efab53a16237acd3_5$EXT"
cp "_temp/SUPER MARIO 64#BDE331E7#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/tex1_32x32_f3f7ae76a03e16af_5$EXT"
cp "_temp/SUPER MARIO 64#FFDEBBC5#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/tex1_32x32_f82d55d17f32633a_5$EXT"
cp "_temp/SUPER MARIO 64#812626F9#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/tex1_32x32_fe2b21a39d42cd96_5$EXT"

cp "_temp/SUPER MARIO 64#DE415A3C#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_0ad40173b5aa7236_5$EXT"
cp "_temp/SUPER MARIO 64#F5D9E5BF#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_1a90a12ba0bb82b0_5$EXT"
cp "_temp/SUPER MARIO 64#B5DA0B63#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_1a93b4722401fe01_5$EXT"
cp "_temp/SUPER MARIO 64#B26D42C0#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_1cb4833eac752314_5$EXT"
cp "_temp/SUPER MARIO 64#EC004254#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_1dc0aec09ff7abf5_5$EXT"
cp "_temp/SUPER MARIO 64#24AD7055#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_218d221adc246f1f_5$EXT"
cp "_temp/SUPER MARIO 64#688DEFB4#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_227179197ab245eb_5$EXT"
cp "_temp/SUPER MARIO 64#7D398EF0#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_2ddce618c8c0c94d_5$EXT"
cp "_temp/SUPER MARIO 64#18A7104C#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_32987dfb84abd90d_5$EXT"
cp "_temp/SUPER MARIO 64#6DABF6C8#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_385dde73804f2244_5$EXT"
cp "_temp/SUPER MARIO 64#42F2325A#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_3e44f152347ac0fb_5$EXT"
cp "_temp/SUPER MARIO 64#2B3F9B9C#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_3efe8fdf23480ef3_5$EXT"
cp "_temp/SUPER MARIO 64#7DCC1AB5#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_4527ad4fe571ec52_5$EXT"
cp "_temp/SUPER MARIO 64#58A11D1E#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_4789296f4ce2a80b_5$EXT"
cp "_temp/SUPER MARIO 64#B2444E60#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_4d8760bd91209725_5$EXT"
cp "_temp/SUPER MARIO 64#9AF43B47#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_5073967559bf20cf_5$EXT"
cp "_temp/SUPER MARIO 64#2ECE83FA#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_542bb980beca133d_5$EXT"
cp "_temp/SUPER MARIO 64#B602AB34#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_55233adb3d4ea3d1_5$EXT"
cp "_temp/SUPER MARIO 64#11543850#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_56823875a34d1832_5$EXT"
cp "_temp/SUPER MARIO 64#D97D5A21#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_59d858b85ca842d2_5$EXT"
cp "_temp/SUPER MARIO 64#2CE5532E#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_619186d786fd9813_5$EXT"
cp "_temp/SUPER MARIO 64#930392D9#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_61f7646d981af4b2_5$EXT"
cp "_temp/SUPER MARIO 64#A9F1685A#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_6212e55a61e45295_5$EXT"
cp "_temp/SUPER MARIO 64#B92BF6C1#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_648c216def99be7b_5$EXT"
cp "_temp/SUPER MARIO 64#0771AB54#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_6ba933515ee52291_5$EXT"
cp "_temp/SUPER MARIO 64#795FE3B9#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_734f4aafc27c911c_5$EXT"
cp "_temp/SUPER MARIO 64#452AAD60#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_758021d5caea7461_5$EXT"
cp "_temp/SUPER MARIO 64#44D5AA4B#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_77ce548f4849a429_5$EXT"
cp "_temp/SUPER MARIO 64#9791B947#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_78483c0fbf70ff00_5$EXT"
cp "_temp/SUPER MARIO 64#6F964986#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_7bcd421491bfb3d1_5$EXT"
cp "_temp/SUPER MARIO 64#2C246943#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_7bf8d935286001e6_5$EXT"
cp "_temp/SUPER MARIO 64#DD5AE929#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_7c8fb9334e3877a4_5$EXT"
cp "_temp/SUPER MARIO 64#2A9F12C7#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_7c8fc12eec65f002_5$EXT"
cp "_temp/SUPER MARIO 64#747B1B07#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_826124df1dccadd2_5$EXT"
cp "_temp/SUPER MARIO 64#A436E205#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_854e3d261a620945_5$EXT"
cp "_temp/SUPER MARIO 64#DB37FF1F#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_877e520f7d6087c8_5$EXT"
cp "_temp/SUPER MARIO 64#5C153DAF#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_88190b7d139850b5_5$EXT"
cp "_temp/SUPER MARIO 64#2C44217C#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_88d39d07d8b79755_5$EXT"
cp "_temp/SUPER MARIO 64#677A5E03#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_9195dec655ea196b_5$EXT"
cp "_temp/SUPER MARIO 64#34E02944#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_9313abb4ca37b982_5$EXT"
cp "_temp/SUPER MARIO 64#D6ACB89D#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_9731e92766872226_5$EXT"
cp "_temp/SUPER MARIO 64#FCFC8637#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_9e690b996b438b66_5$EXT"
cp "_temp/SUPER MARIO 64#14C6A0DB#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_a9b996a8175afbf4_5$EXT"
cp "_temp/SUPER MARIO 64#8141BBBC#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_ab73535252a996d4_5$EXT"
cp "_temp/SUPER MARIO 64#308C95F5#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_ad8a766338469801_5$EXT"
cp "_temp/SUPER MARIO 64#FC0DD433#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_b362b3e43ddfd93d_5$EXT"
cp "_temp/SUPER MARIO 64#17F35F3C#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_b4847c6bb0d6ec46_5$EXT"
cp "_temp/SUPER MARIO 64#51256D7A#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_b70665f170096417_5$EXT"
cp "_temp/SUPER MARIO 64#AA0F24EC#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_bd8531d1f90ef547_5$EXT"
cp "_temp/SUPER MARIO 64#069F68D5#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_beb5b19262e04b94_5$EXT"
cp "_temp/SUPER MARIO 64#21854115#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_bf01a470c9d45162_5$EXT"
cp "_temp/SUPER MARIO 64#4CEEF375#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_c34a8be016c69361_5$EXT"
cp "_temp/SUPER MARIO 64#B271DB5B#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_ce41d5a9ee18e14c_5$EXT"
cp "_temp/SUPER MARIO 64#C80078C1#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_d4ac652234acdb45_5$EXT"
cp "_temp/SUPER MARIO 64#41D56401#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_d90d668dd8083557_5$EXT"
cp "_temp/SUPER MARIO 64#0A18ADCA#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_ddeb76c489bbba60_5$EXT"
cp "_temp/SUPER MARIO 64#84EB583E#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_ee0c4e5b14408249_5$EXT"
cp "_temp/SUPER MARIO 64#68CBBCD3#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_efa759084959eeca_5$EXT"
cp "_temp/SUPER MARIO 64#486F9BD1#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_efbfdc538d6576db_5$EXT"
cp "_temp/SUPER MARIO 64#A349A078#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_f1e37e01895f5608_5$EXT"
cp "_temp/SUPER MARIO 64#1450F56E#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_f489defa1ae23f97_5$EXT"
cp "_temp/SUPER MARIO 64#F69986CE#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_f6a4dd7d758e36c8_5$EXT"
cp "_temp/SUPER MARIO 64#4F503C6E#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_fb6fb2b04daba11b_5$EXT"
cp "_temp/SUPER MARIO 64#E144C219#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/tex1_32x32_ff0428240013aa46_5$EXT"

cp "_temp/SUPER MARIO 64#49A828DB#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_0623e5eba1744372_5$EXT"
cp "_temp/SUPER MARIO 64#76F2963D#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_0667aeef8b89d323_5$EXT"
cp "_temp/SUPER MARIO 64#86B5C15F#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_0b1e944a21ddd2e8_5$EXT"
cp "_temp/SUPER MARIO 64#889D2B5C#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_0f97a81ce13c7ff8_5$EXT"
cp "_temp/SUPER MARIO 64#E6640E91#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_118d9ed69430a437_5$EXT"
cp "_temp/SUPER MARIO 64#71D8C330#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_12bb26cc9e614199_5$EXT"
cp "_temp/SUPER MARIO 64#74C13ED4#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_18b8dbb372806bf4_5$EXT"
cp "_temp/SUPER MARIO 64#EE5C9999#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_1be0b8a356ba7d7b_5$EXT"
cp "_temp/SUPER MARIO 64#7E91D91E#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_1ec308e680f2fb6a_5$EXT"
cp "_temp/SUPER MARIO 64#579D6C8A#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_1f16a68421ff9fa9_5$EXT"
cp "_temp/SUPER MARIO 64#A4908044#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_1f19f39e306d75b5_5$EXT"
cp "_temp/SUPER MARIO 64#6D00C07C#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_1f3f79aa1f51cc93_5$EXT"
cp "_temp/SUPER MARIO 64#71FFBF4D#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_1fcf426b3c337b9a_5$EXT"
cp "_temp/SUPER MARIO 64#880ED312#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_28e4d80612694860_5$EXT"
cp "_temp/SUPER MARIO 64#84651765#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_29db40f3f0ac58d2_5$EXT"
cp "_temp/SUPER MARIO 64#648DFFC2#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_34847b15f47b9b57_5$EXT"
cp "_temp/SUPER MARIO 64#9FB76A34#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_356a27f87e52b15e_5$EXT"
cp "_temp/SUPER MARIO 64#027C89DB#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_367cbddf4c974f60_5$EXT"
cp "_temp/SUPER MARIO 64#579B80B3#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_38cf8075fe2b1140_5$EXT"
cp "_temp/SUPER MARIO 64#F0DD9D26#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_3e40b833f783d272_5$EXT"
cp "_temp/SUPER MARIO 64#F05AADEE#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_3f23b2caa9392b35_5$EXT"
cp "_temp/SUPER MARIO 64#5D58D20C#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_4874ece0226b1ac9_5$EXT"
cp "_temp/SUPER MARIO 64#EB5C820F#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_519951985f49c27d_5$EXT"
cp "_temp/SUPER MARIO 64#D8E02894#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_53173348d5a7e18c_5$EXT"
cp "_temp/SUPER MARIO 64#76ABE6DB#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_5be614b5d41e4f77_5$EXT"
cp "_temp/SUPER MARIO 64#408779A6#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_5d85a02dd2c0f4ee_5$EXT"
cp "_temp/SUPER MARIO 64#7C98DFA7#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_621193844ca2748d_5$EXT"
cp "_temp/SUPER MARIO 64#B484B601#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_6632f0960d0bb0e8_5$EXT"
cp "_temp/SUPER MARIO 64#40AD9DAB#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_69a9fcaae305322b_5$EXT"
cp "_temp/SUPER MARIO 64#D3D96165#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_6c3180b170fd36e0_5$EXT"
cp "_temp/SUPER MARIO 64#57DD4DE0#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_6e101360405959c1_5$EXT"
cp "_temp/SUPER MARIO 64#05EC9E16#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_71b366c5d54500aa_5$EXT"
cp "_temp/SUPER MARIO 64#B416574C#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_752f4303d222d90f_5$EXT"
cp "_temp/SUPER MARIO 64#B09F7FF5#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_7710183ba6403241_5$EXT"
cp "_temp/SUPER MARIO 64#F03AEF7D#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_7e8869b07f735d05_5$EXT"
cp "_temp/SUPER MARIO 64#48A5F126#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_8402a2639706d427_5$EXT"
cp "_temp/SUPER MARIO 64#C70E2879#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_8a2eb5a0f5d06c89_5$EXT"
cp "_temp/SUPER MARIO 64#EBA48BA7#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_914f60ca2778b8c8_5$EXT"
cp "_temp/SUPER MARIO 64#54CA6DDC#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_943dfeb94a7fee0b_5$EXT"
cp "_temp/SUPER MARIO 64#EBA8BFCA#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_99daa57d4e5ffd19_5$EXT"
cp "_temp/SUPER MARIO 64#FC424ECC#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_9aa207350c36ddfa_5$EXT"
cp "_temp/SUPER MARIO 64#E0901C5A#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_9c94e3ab6fc02efb_5$EXT"
cp "_temp/SUPER MARIO 64#2D31F48B#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_a0546c8b8b553ce3_5$EXT"
cp "_temp/SUPER MARIO 64#D404F7B3#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_a0e627ad14e700d2_5$EXT"
cp "_temp/SUPER MARIO 64#626B987C#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_a7b6ba434c949198_5$EXT"
cp "_temp/SUPER MARIO 64#02AADDF6#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_b36ee793b6a5e19b_5$EXT"
cp "_temp/SUPER MARIO 64#D61DC576#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_b446e5121ce21616_5$EXT"
cp "_temp/SUPER MARIO 64#212A4546#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_bd9c66f7bbe9045b_5$EXT"
cp "_temp/SUPER MARIO 64#613A2612#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_bfedf18ed31fede7_5$EXT"
cp "_temp/SUPER MARIO 64#031DC071#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_c81622847f5eea38_5$EXT"
cp "_temp/SUPER MARIO 64#D3F0D281#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_cf607c014b33193c_5$EXT"
cp "_temp/SUPER MARIO 64#E7D08E45#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_d17a7f8211800490_5$EXT"
cp "_temp/SUPER MARIO 64#A87F6678#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_d241d128afb9d57a_5$EXT"
cp "_temp/SUPER MARIO 64#F6BB8446#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_d387be65c47e0952_5$EXT"
cp "_temp/SUPER MARIO 64#FB04DE95#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_da8ea4141166f3b1_5$EXT"
cp "_temp/SUPER MARIO 64#FB4E7D3C#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_dc6bfe2218ed8a74_5$EXT"
cp "_temp/SUPER MARIO 64#24A049BD#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_dd6c07856d2291b6_5$EXT"
cp "_temp/SUPER MARIO 64#32DA5C54#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_e1770923bd27a61e_5$EXT"
cp "_temp/SUPER MARIO 64#0F1C2159#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_e275666910697a50_5$EXT"
cp "_temp/SUPER MARIO 64#677CF935#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_e47c629b71b54c68_5$EXT"
cp "_temp/SUPER MARIO 64#2DDB1AB2#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_e4a27ff0fdba616e_5$EXT"
cp "_temp/SUPER MARIO 64#BA25C107#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_ea76bc9b1230df2e_5$EXT"
cp "_temp/SUPER MARIO 64#A356667C#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_f03386a7987d3013_5$EXT"
cp "_temp/SUPER MARIO 64#E747F9B9#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/tex1_32x32_f88735e39d7e0c65_5$EXT"

cp "_temp/SUPER MARIO 64#F0FD9FE8#0#2_all$EXT" "$PORT/Skybox/Clouds/tex1_32x32_032275c5d9b197ad_5$EXT"
cp "_temp/SUPER MARIO 64#40E6BBFB#0#2_all$EXT" "$PORT/Skybox/Clouds/tex1_32x32_0817976085bffc58_5$EXT"
cp "_temp/SUPER MARIO 64#214F09C8#0#2_all$EXT" "$PORT/Skybox/Clouds/tex1_32x32_0fd349e0717b920b_5$EXT"
cp "_temp/SUPER MARIO 64#7FCD908D#0#2_all$EXT" "$PORT/Skybox/Clouds/tex1_32x32_141285a0a13a4562_5$EXT"
cp "_temp/SUPER MARIO 64#89AC3C05#0#2_all$EXT" "$PORT/Skybox/Clouds/tex1_32x32_16801a876badd6b0_5$EXT"
cp "_temp/SUPER MARIO 64#C0A7D217#0#2_all$EXT" "$PORT/Skybox/Clouds/tex1_32x32_1cd1322f9e9535ec_5$EXT"
cp "_temp/SUPER MARIO 64#0D344FC8#0#2_all$EXT" "$PORT/Skybox/Clouds/tex1_32x32_24ceb96f00f465d0_5$EXT"
cp "_temp/SUPER MARIO 64#019BFB97#0#2_all$EXT" "$PORT/Skybox/Clouds/tex1_32x32_2c510bded96732d6_5$EXT"
cp "_temp/SUPER MARIO 64#DB5B2455#0#2_all$EXT" "$PORT/Skybox/Clouds/tex1_32x32_2e614b4eee3d50b3_5$EXT"
cp "_temp/SUPER MARIO 64#EEB51695#0#2_all$EXT" "$PORT/Skybox/Clouds/tex1_32x32_30f3128a10c3872a_5$EXT"
cp "_temp/SUPER MARIO 64#AACF41C9#0#2_all$EXT" "$PORT/Skybox/Clouds/tex1_32x32_34badfd35c7400ae_5$EXT"
cp "_temp/SUPER MARIO 64#CABC445D#0#2_all$EXT" "$PORT/Skybox/Clouds/tex1_32x32_380c345d73438d75_5$EXT"
cp "_temp/SUPER MARIO 64#DC28412D#0#2_all$EXT" "$PORT/Skybox/Clouds/tex1_32x32_4ee349383fb187dd_5$EXT"
cp "_temp/SUPER MARIO 64#8CC10B27#0#2_all$EXT" "$PORT/Skybox/Clouds/tex1_32x32_503e3b0b7a681bd9_5$EXT"
cp "_temp/SUPER MARIO 64#4A043C67#0#2_all$EXT" "$PORT/Skybox/Clouds/tex1_32x32_5076b6f0d696d0a6_5$EXT"
cp "_temp/SUPER MARIO 64#FDB6DE70#0#2_all$EXT" "$PORT/Skybox/Clouds/tex1_32x32_5f9976959b3111c3_5$EXT"
cp "_temp/SUPER MARIO 64#A5E5250E#0#2_all$EXT" "$PORT/Skybox/Clouds/tex1_32x32_62fc99410e57099f_5$EXT"
cp "_temp/SUPER MARIO 64#E20D5C69#0#2_all$EXT" "$PORT/Skybox/Clouds/tex1_32x32_64391e088e2e9006_5$EXT"
cp "_temp/SUPER MARIO 64#02C423F8#0#2_all$EXT" "$PORT/Skybox/Clouds/tex1_32x32_64ccea2607f27f4e_5$EXT"
cp "_temp/SUPER MARIO 64#89CFD188#0#2_all$EXT" "$PORT/Skybox/Clouds/tex1_32x32_657b91cda444f3b8_5$EXT"
cp "_temp/SUPER MARIO 64#6C064A7F#0#2_all$EXT" "$PORT/Skybox/Clouds/tex1_32x32_68092f58f2b495eb_5$EXT"
cp "_temp/SUPER MARIO 64#C3941398#0#2_all$EXT" "$PORT/Skybox/Clouds/tex1_32x32_6d9b3336fa045378_5$EXT"
cp "_temp/SUPER MARIO 64#5A838C70#0#2_all$EXT" "$PORT/Skybox/Clouds/tex1_32x32_6e78d809db7d5631_5$EXT"
cp "_temp/SUPER MARIO 64#540F30FF#0#2_all$EXT" "$PORT/Skybox/Clouds/tex1_32x32_73c158d65dfd5847_5$EXT"
cp "_temp/SUPER MARIO 64#C63F7ABB#0#2_all$EXT" "$PORT/Skybox/Clouds/tex1_32x32_746464476308e208_5$EXT"
cp "_temp/SUPER MARIO 64#98C45311#0#2_all$EXT" "$PORT/Skybox/Clouds/tex1_32x32_751d3e62b0d35cc6_5$EXT"
cp "_temp/SUPER MARIO 64#6C42DFF7#0#2_all$EXT" "$PORT/Skybox/Clouds/tex1_32x32_939ed3e33a4023aa_5$EXT"
cp "_temp/SUPER MARIO 64#A1261BAA#0#2_all$EXT" "$PORT/Skybox/Clouds/tex1_32x32_98985db3e76d6a22_5$EXT"
cp "_temp/SUPER MARIO 64#C96FD4B4#0#2_all$EXT" "$PORT/Skybox/Clouds/tex1_32x32_9ed665ab7c74a786_5$EXT"
cp "_temp/SUPER MARIO 64#2F3FDBA3#0#2_all$EXT" "$PORT/Skybox/Clouds/tex1_32x32_a374a0f526198d32_5$EXT"
cp "_temp/SUPER MARIO 64#0A10018C#0#2_all$EXT" "$PORT/Skybox/Clouds/tex1_32x32_ba6130dd1b1dca57_5$EXT"
cp "_temp/SUPER MARIO 64#D7B09499#0#2_all$EXT" "$PORT/Skybox/Clouds/tex1_32x32_c674260c76fa9a33_5$EXT"
cp "_temp/SUPER MARIO 64#A07BCDE0#0#2_all$EXT" "$PORT/Skybox/Clouds/tex1_32x32_c91fcbc79162fdc9_5$EXT"
cp "_temp/SUPER MARIO 64#7F86B16B#0#2_all$EXT" "$PORT/Skybox/Clouds/tex1_32x32_d6a586e2627e56c4_5$EXT"
cp "_temp/SUPER MARIO 64#98C99A4D#0#2_all$EXT" "$PORT/Skybox/Clouds/tex1_32x32_e10aaad13fc75a1e_5$EXT"
cp "_temp/SUPER MARIO 64#82C55DC1#0#2_all$EXT" "$PORT/Skybox/Clouds/tex1_32x32_e5c452f2ddbd844f_5$EXT"
cp "_temp/SUPER MARIO 64#F19D33E5#0#2_all$EXT" "$PORT/Skybox/Clouds/tex1_32x32_e7f1329839e8d8f5_5$EXT"
cp "_temp/SUPER MARIO 64#D658AB33#0#2_all$EXT" "$PORT/Skybox/Clouds/tex1_32x32_edb0eb0c5aba35c8_5$EXT"
cp "_temp/SUPER MARIO 64#AB7A67D1#0#2_all$EXT" "$PORT/Skybox/Clouds/tex1_32x32_f2cde9ca1ac200f6_5$EXT"
cp "_temp/SUPER MARIO 64#21676BDD#0#2_all$EXT" "$PORT/Skybox/Clouds/tex1_32x32_f30ab7f5f55f8ae9_5$EXT"

cp "_temp/SUPER MARIO 64#86A4D0DC#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_043e8446dc77de81_5$EXT"
cp "_temp/SUPER MARIO 64#D742B346#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_05eb86336dea434b_5$EXT"
cp "_temp/SUPER MARIO 64#64DF79E9#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_0ee46d13f169a869_5$EXT"
cp "_temp/SUPER MARIO 64#5C293288#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_0f0f73ea839d73d2_5$EXT"
cp "_temp/SUPER MARIO 64#74535372#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_154364ef2a4ce719_5$EXT"
cp "_temp/SUPER MARIO 64#9F6BFF93#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_15d659f1a4237a4c_5$EXT"
cp "_temp/SUPER MARIO 64#11A852CB#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_1c5131b098a0b41f_5$EXT"
cp "_temp/SUPER MARIO 64#3FFA0BE7#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_1d547b48a7b6bfef_5$EXT"
cp "_temp/SUPER MARIO 64#BF89DF6A#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_26b55868a998839c_5$EXT"
cp "_temp/SUPER MARIO 64#221C9F08#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_27813f10f1ee8f70_5$EXT"
cp "_temp/SUPER MARIO 64#BBED1DAD#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_29d32ddfaea2bac2_5$EXT"
cp "_temp/SUPER MARIO 64#26A34F80#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_2b01670e321083d2_5$EXT"
cp "_temp/SUPER MARIO 64#8B462047#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_2d443bb2da6a1520_5$EXT"
cp "_temp/SUPER MARIO 64#EB70D69C#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_2e55fe711e90abd4_5$EXT"
cp "_temp/SUPER MARIO 64#39C55C7F#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_2edd6c2716f9965f_5$EXT"
cp "_temp/SUPER MARIO 64#46EE72E8#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_307b3695e1953515_5$EXT"
cp "_temp/SUPER MARIO 64#82487DAB#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_350c416094397caa_5$EXT"
cp "_temp/SUPER MARIO 64#58F28A81#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_3533cb5e0280d79e_5$EXT"
cp "_temp/SUPER MARIO 64#9DBB856E#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_4a725d059dcaa6d9_5$EXT"
cp "_temp/SUPER MARIO 64#76F2D5AF#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_4ec4cf6558e0dde7_5$EXT"
cp "_temp/SUPER MARIO 64#CCFB8478#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_4f2f5537cafb6b2b_5$EXT"
cp "_temp/SUPER MARIO 64#CD7A591F#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_54b00f3c72499a60_5$EXT"
cp "_temp/SUPER MARIO 64#6905FBF2#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_57acf48e8c01a820_5$EXT"
cp "_temp/SUPER MARIO 64#40226C48#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_5da4356ccf28db6f_5$EXT"
cp "_temp/SUPER MARIO 64#92A6E121#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_5e56bfa8ff47c9cc_5$EXT"
cp "_temp/SUPER MARIO 64#3CC93124#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_6113f8d84c52a9df_5$EXT"
cp "_temp/SUPER MARIO 64#DA354D71#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_61568e54d49f5302_5$EXT"
cp "_temp/SUPER MARIO 64#DDCBD0BF#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_6823546883996a50_5$EXT"
cp "_temp/SUPER MARIO 64#889E61FF#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_6ec74eafccb389db_5$EXT"
cp "_temp/SUPER MARIO 64#BB2FB09F#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_76b719c79a6cf667_5$EXT"
cp "_temp/SUPER MARIO 64#822B53ED#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_7952231143dcdc93_5$EXT"
cp "_temp/SUPER MARIO 64#03EEAB38#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_7adf8ab0118ccb07_5$EXT"
cp "_temp/SUPER MARIO 64#0BA8D96E#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_7ce43c2587f24993_5$EXT"
cp "_temp/SUPER MARIO 64#B858A9A4#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_86e4af27fcc2a197_5$EXT"
cp "_temp/SUPER MARIO 64#E702818C#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_8a96b8242615fac8_5$EXT"
cp "_temp/SUPER MARIO 64#CCAD2F1E#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_93c87bd33a9cd3c6_5$EXT"
cp "_temp/SUPER MARIO 64#8726A741#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_94a797e700490548_5$EXT"
cp "_temp/SUPER MARIO 64#B0FE2869#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_9725b65b87d29e49_5$EXT"
cp "_temp/SUPER MARIO 64#88E7E346#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_97701e910ec63e75_5$EXT"
cp "_temp/SUPER MARIO 64#E348762E#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_9a97234ae4b1e626_5$EXT"
cp "_temp/SUPER MARIO 64#99A009D0#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_9c935a3f24b19091_5$EXT"
cp "_temp/SUPER MARIO 64#E47FB00E#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_9da3c25ca3999bf5_5$EXT"
cp "_temp/SUPER MARIO 64#9F82C465#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_9f322a2afcc605dd_5$EXT"
cp "_temp/SUPER MARIO 64#8076D349#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_a27f7875f70e6aa2_5$EXT"
cp "_temp/SUPER MARIO 64#EF1D1E70#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_a539fec628cd01e9_5$EXT"
cp "_temp/SUPER MARIO 64#24EC3198#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_a66999178b84c21f_5$EXT"
cp "_temp/SUPER MARIO 64#8541D92C#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_a8b3133cd2591e40_5$EXT"
cp "_temp/SUPER MARIO 64#6DB140AD#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_aaaa190b88b60d26_5$EXT"
cp "_temp/SUPER MARIO 64#F1301217#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_b6dae1d33dc41aa5_5$EXT"
cp "_temp/SUPER MARIO 64#B1330909#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_b9fcae54664c1a23_5$EXT"
cp "_temp/SUPER MARIO 64#32B61B3E#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_bd783278b6cdc183_5$EXT"
cp "_temp/SUPER MARIO 64#51D0A5D0#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_bf6944df59e4597e_5$EXT"
cp "_temp/SUPER MARIO 64#5CC5CAF7#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_bf993d081abb4a1e_5$EXT"
cp "_temp/SUPER MARIO 64#22628916#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_bfe8e3ee1369a9bd_5$EXT"
cp "_temp/SUPER MARIO 64#A3067F0B#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_c1b262f9b588b551_5$EXT"
cp "_temp/SUPER MARIO 64#014C6E73#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_ccb03d2627f43654_5$EXT"
cp "_temp/SUPER MARIO 64#DC5422CC#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_cfce65892118281f_5$EXT"
cp "_temp/SUPER MARIO 64#C9425D35#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_d582ac5e0a8a32e3_5$EXT"
cp "_temp/SUPER MARIO 64#D2A5272B#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_de3d70aba989656d_5$EXT"
cp "_temp/SUPER MARIO 64#912F6E5E#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_e56a97cffdfdae11_5$EXT"
cp "_temp/SUPER MARIO 64#D68E7D47#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_e6409b8d90f9656d_5$EXT"
cp "_temp/SUPER MARIO 64#BDD76307#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_e7a499a4a05cb637_5$EXT"
cp "_temp/SUPER MARIO 64#77EC8240#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_ef688905bdd2cdc2_5$EXT"
cp "_temp/SUPER MARIO 64#DEEF869F#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/tex1_32x32_fe8df0e07cf9a215_5$EXT"

cp "_temp/SUPER MARIO 64#CB3C5D47#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_020ac6a6f8192b2a_5$EXT"
cp "_temp/SUPER MARIO 64#DBA34B25#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_02a364084314f1a2_5$EXT"
cp "_temp/SUPER MARIO 64#B3C88877#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_04ac181fd3c01efb_5$EXT"
cp "_temp/SUPER MARIO 64#3C183177#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_060fc577c6877c17_5$EXT"
cp "_temp/SUPER MARIO 64#B1E98F62#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_09ba3f72c221e569_5$EXT"
cp "_temp/SUPER MARIO 64#B7C222A8#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_0e336ecc9be679c8_5$EXT"
cp "_temp/SUPER MARIO 64#A34577B4#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_114480d47245547e_5$EXT"
cp "_temp/SUPER MARIO 64#19CF329B#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_16a19b20cce8c0f0_5$EXT"
cp "_temp/SUPER MARIO 64#75EF9A90#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_1748892fb6fa3e9d_5$EXT"
cp "_temp/SUPER MARIO 64#6899F91F#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_1a4aaff095f1be20_5$EXT"
cp "_temp/SUPER MARIO 64#CEA7425D#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_1dcb6c3628ac862b_5$EXT"
cp "_temp/SUPER MARIO 64#67B3CF11#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_1f3abb083610f05c_5$EXT"
cp "_temp/SUPER MARIO 64#6A17A436#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_2508e0e7c21bb63b_5$EXT"
cp "_temp/SUPER MARIO 64#52749E6E#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_275824d077c284f1_5$EXT"
cp "_temp/SUPER MARIO 64#85A91338#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_2edf3207bf1927ba_5$EXT"
cp "_temp/SUPER MARIO 64#7E1D47DB#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_31f6b05425a4262b_5$EXT"
cp "_temp/SUPER MARIO 64#79C8997D#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_323d95b43e47dffa_5$EXT"
cp "_temp/SUPER MARIO 64#A4C2448B#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_32bfcf979b35234f_5$EXT"
cp "_temp/SUPER MARIO 64#393BA6AE#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_3847658ecc7ef4ed_5$EXT"
cp "_temp/SUPER MARIO 64#B8378CD9#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_38498b569cdd3827_5$EXT"
cp "_temp/SUPER MARIO 64#C8922002#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_39bda586d97f363b_5$EXT"
cp "_temp/SUPER MARIO 64#C6D80BAF#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_3b53d211d0c0b18b_5$EXT"
cp "_temp/SUPER MARIO 64#38EC1B66#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_4643223e84591518_5$EXT"
cp "_temp/SUPER MARIO 64#A0A0A907#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_49b7105f3a36651a_5$EXT"
cp "_temp/SUPER MARIO 64#914AFA93#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_4b71caccc516b591_5$EXT"
cp "_temp/SUPER MARIO 64#5F5E3DF7#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_57d484167df359be_5$EXT"
cp "_temp/SUPER MARIO 64#B44A7CEF#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_66c68da8ea694a42_5$EXT"
cp "_temp/SUPER MARIO 64#52D5A8B9#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_690007dd630ee950_5$EXT"
cp "_temp/SUPER MARIO 64#F765D232#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_69e70dc5f737b3c6_5$EXT"
cp "_temp/SUPER MARIO 64#A6D0D0CC#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_6e4e324598b1d218_5$EXT"
cp "_temp/SUPER MARIO 64#2193CD76#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_6e82d82822cd806f_5$EXT"
cp "_temp/SUPER MARIO 64#6505FAC3#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_70f3cab6f2801549_5$EXT"
cp "_temp/SUPER MARIO 64#D26EE300#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_747aa87c7d808381_5$EXT"
cp "_temp/SUPER MARIO 64#213EBD50#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_77ec1699c6f8da47_5$EXT"
cp "_temp/SUPER MARIO 64#DDD906E3#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_8238bbd57249e335_5$EXT"
cp "_temp/SUPER MARIO 64#6D0C18AA#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_87b70415b19e4431_5$EXT"
cp "_temp/SUPER MARIO 64#F16F1966#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_89142d3388dc7333_5$EXT"
cp "_temp/SUPER MARIO 64#11F1B791#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_8db603381bbc3229_5$EXT"
cp "_temp/SUPER MARIO 64#101CA508#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_8e934eb0ad2e1b2c_5$EXT"
cp "_temp/SUPER MARIO 64#FF6C67F0#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_950197153990d16f_5$EXT"
cp "_temp/SUPER MARIO 64#B0A791EE#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_9b8d7ccd89611cad_5$EXT"
cp "_temp/SUPER MARIO 64#55EB7A33#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_9f5861d78f54f3dd_5$EXT"
cp "_temp/SUPER MARIO 64#AFCC9DE7#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_a90866fb0eb175ab_5$EXT"
cp "_temp/SUPER MARIO 64#96FAD568#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_ad31b8eaa0701b98_5$EXT"
cp "_temp/SUPER MARIO 64#1411177B#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_adbb52f35f5f45f8_5$EXT"
cp "_temp/SUPER MARIO 64#2D6492F4#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_aed85f2c505a94e1_5$EXT"
cp "_temp/SUPER MARIO 64#91787803#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_aedfff4c6f79815b_5$EXT"
cp "_temp/SUPER MARIO 64#06AB9733#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_b0febe57d6a88d4e_5$EXT"
cp "_temp/SUPER MARIO 64#082CD478#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_b5499e5270828572_5$EXT"
cp "_temp/SUPER MARIO 64#15B65397#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_b6583b059c712e36_5$EXT"
cp "_temp/SUPER MARIO 64#074933DA#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_b8e33442e152b06b_5$EXT"
cp "_temp/SUPER MARIO 64#1ADECD70#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_bb901101146fdb6c_5$EXT"
cp "_temp/SUPER MARIO 64#BDC75108#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_bf4111f7b2de75bc_5$EXT"
cp "_temp/SUPER MARIO 64#F4472DB5#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_cb304ac3a5b50db3_5$EXT"
cp "_temp/SUPER MARIO 64#DF68E5A6#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_ccc69ea6f59c5338_5$EXT"
cp "_temp/SUPER MARIO 64#7E27E43F#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_d0b89b4e4ac6e857_5$EXT"
cp "_temp/SUPER MARIO 64#B48BB452#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_e48219ca07f9387c_5$EXT"
cp "_temp/SUPER MARIO 64#9BF7992D#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_e494c222ca92d34d_5$EXT"
cp "_temp/SUPER MARIO 64#FDC48AEB#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_e72e4dd67edd299a_5$EXT"
cp "_temp/SUPER MARIO 64#62AEFDE2#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_e7abe5e1a2e87e10_5$EXT"
cp "_temp/SUPER MARIO 64#A4B86DC8#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_f1b3185b9215ccc5_5$EXT"
cp "_temp/SUPER MARIO 64#BD8C842F#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_f2d27f8e44c66670_5$EXT"
cp "_temp/SUPER MARIO 64#B55E9B94#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_f3fd6e33265086f2_5$EXT"
cp "_temp/SUPER MARIO 64#32BEB053#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/tex1_32x32_fb521cb2e33d66a1_5$EXT"

cp "_temp/SUPER MARIO 64#3D244F64#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_0e155baad1880254_5$EXT"
cp "_temp/SUPER MARIO 64#48BC2FC8#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_0e23838a443e3840_5$EXT"
cp "_temp/SUPER MARIO 64#5A2FA13A#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_14e36c914c1c093e_5$EXT"
cp "_temp/SUPER MARIO 64#3AADB102#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_17aeca30ead668bb_5$EXT"
cp "_temp/SUPER MARIO 64#6ACA7D17#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_1d899e2db05ef965_5$EXT"
cp "_temp/SUPER MARIO 64#112C8257#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_25212cf4838cec1d_5$EXT"
cp "_temp/SUPER MARIO 64#B8755755#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_26eaa875e6a7022a_5$EXT"
cp "_temp/SUPER MARIO 64#E8F6FFF7#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_2e95bfe35776108f_5$EXT"
cp "_temp/SUPER MARIO 64#3AE6BEC9#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_2ec99e490b7a97da_5$EXT"
cp "_temp/SUPER MARIO 64#08170B98#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_2fef15f8005e2dab_5$EXT"
cp "_temp/SUPER MARIO 64#C3EB2FC6#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_320cbff688914164_5$EXT"
cp "_temp/SUPER MARIO 64#3D354167#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_3643f16c03e2d324_5$EXT"
cp "_temp/SUPER MARIO 64#4089D798#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_38d0653dabbed35a_5$EXT"
cp "_temp/SUPER MARIO 64#A9DE87A8#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_417ea71d817404a2_5$EXT"
cp "_temp/SUPER MARIO 64#24D27245#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_430e5c0590514d28_5$EXT"
cp "_temp/SUPER MARIO 64#208F2137#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_4475d9781d51aa13_5$EXT"
cp "_temp/SUPER MARIO 64#1A66C67F#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_4889ba6f82e3e6ae_5$EXT"
cp "_temp/SUPER MARIO 64#B8E3120B#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_49acdf7c28296e12_5$EXT"
cp "_temp/SUPER MARIO 64#8AF0E7BE#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_4b843fd346115bf3_5$EXT"
cp "_temp/SUPER MARIO 64#E04EF9FC#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_4cec86ffe0295619_5$EXT"
cp "_temp/SUPER MARIO 64#DB3EDFED#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_506c4076a1583da3_5$EXT"
cp "_temp/SUPER MARIO 64#29904548#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_546199c038356c3f_5$EXT"
cp "_temp/SUPER MARIO 64#87C25FE2#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_559a037614431132_5$EXT"
cp "_temp/SUPER MARIO 64#EF35DA31#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_5910130fc3d963b3_5$EXT"
cp "_temp/SUPER MARIO 64#60DD861C#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_5ad0b0be74abb765_5$EXT"
cp "_temp/SUPER MARIO 64#4BCAE8D6#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_5bec11a20ced0e38_5$EXT"
cp "_temp/SUPER MARIO 64#8E58D68A#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_5ce7c6af7868263c_5$EXT"
cp "_temp/SUPER MARIO 64#7D23E625#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_608e5436821bae3b_5$EXT"
cp "_temp/SUPER MARIO 64#19132BCC#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_61c630ae995eaf50_5$EXT"
cp "_temp/SUPER MARIO 64#933976B9#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_6e52c42ce781bb9e_5$EXT"
cp "_temp/SUPER MARIO 64#1096C02E#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_75701986f183ea03_5$EXT"
cp "_temp/SUPER MARIO 64#599DA7CB#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_77c1bc75d2612d93_5$EXT"
cp "_temp/SUPER MARIO 64#4D606A9B#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_79aac6ff0525e6d2_5$EXT"
cp "_temp/SUPER MARIO 64#21DD7803#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_7cd9593c6306fccd_5$EXT"
cp "_temp/SUPER MARIO 64#942949F4#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_7fd3aff5257fcb9d_5$EXT"
cp "_temp/SUPER MARIO 64#1CA18F8F#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_8529103651622ade_5$EXT"
cp "_temp/SUPER MARIO 64#DBC08093#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_85dfef6b8e3db838_5$EXT"
cp "_temp/SUPER MARIO 64#2499CE37#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_8941dc46e6966a8c_5$EXT"
cp "_temp/SUPER MARIO 64#FC489936#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_8ec555ed6fc48246_5$EXT"
cp "_temp/SUPER MARIO 64#2E5DD16D#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_92e758d4f49ccf4f_5$EXT"
cp "_temp/SUPER MARIO 64#258A8627#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_94d2ef92c8868f95_5$EXT"
cp "_temp/SUPER MARIO 64#96A88F3B#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_98fdf35ace55d658_5$EXT"
cp "_temp/SUPER MARIO 64#6F146752#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_9d3ea829667f2244_5$EXT"
cp "_temp/SUPER MARIO 64#45F63AE1#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_a024b13c511ffb13_5$EXT"
cp "_temp/SUPER MARIO 64#1465E49F#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_a30e1e771a40f016_5$EXT"
cp "_temp/SUPER MARIO 64#0DDC6F87#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_a38f26f86c4abeb9_5$EXT"
cp "_temp/SUPER MARIO 64#EDFF0BD2#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_aa28e68e7bc6ddfb_5$EXT"
cp "_temp/SUPER MARIO 64#7CB09E26#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_b74adabdef3ff001_5$EXT"
cp "_temp/SUPER MARIO 64#53CBF3E0#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_b794aabe549b8462_5$EXT"
cp "_temp/SUPER MARIO 64#B6CEC061#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_bdb19ae376a60e68_5$EXT"
cp "_temp/SUPER MARIO 64#E447E6B0#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_beb57058186e3bd0_5$EXT"
cp "_temp/SUPER MARIO 64#011C8C77#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_bf0059081b4745df_5$EXT"
cp "_temp/SUPER MARIO 64#1E940DB1#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_bf3d0db1b649cf6c_5$EXT"
cp "_temp/SUPER MARIO 64#65ABBFE9#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_c742f70d629576ba_5$EXT"
cp "_temp/SUPER MARIO 64#9D13156E#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_cebac0f7c47e557a_5$EXT"
cp "_temp/SUPER MARIO 64#5643908B#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_d87638ac8765d480_5$EXT"
cp "_temp/SUPER MARIO 64#E169C3BF#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_d8c1358db21b9e50_5$EXT"
cp "_temp/SUPER MARIO 64#5730FAAA#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_e0a9e6699eb36a5e_5$EXT"
cp "_temp/SUPER MARIO 64#F10816C6#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_eb0a1e8d1fa41337_5$EXT"
cp "_temp/SUPER MARIO 64#3D21394E#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_f343da17b17e112b_5$EXT"
cp "_temp/SUPER MARIO 64#A608942F#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_f3523ada1b8f31da_5$EXT"
cp "_temp/SUPER MARIO 64#8F92529C#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_f6194acfe35c12fd_5$EXT"
cp "_temp/SUPER MARIO 64#DDE2C14F#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_f726940eed9a1f32_5$EXT"
cp "_temp/SUPER MARIO 64#1EED9296#0#2_all$EXT" "$PORT/Skybox/Water/tex1_32x32_f911fbfeb9622094_5$EXT"

cp "_temp/SUPER MARIO 64#DA83E7AB#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_02ccacd0043c41c4_5$EXT"
cp "_temp/SUPER MARIO 64#385055F4#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_030e9a9ea7722069_5$EXT"
cp "_temp/SUPER MARIO 64#F8CAB46C#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_055c170ddc4398a1_5$EXT"
cp "_temp/SUPER MARIO 64#F2EDE87D#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_0636369de909ddc2_5$EXT"
cp "_temp/SUPER MARIO 64#1B1FA1C6#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_078e3b800ef089fa_5$EXT"
cp "_temp/SUPER MARIO 64#0731BEEA#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_0988fa7b1248feba_5$EXT"
cp "_temp/SUPER MARIO 64#F861446C#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_0be47f12d36c2c91_5$EXT"
cp "_temp/SUPER MARIO 64#DE5450B9#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_1011177d6bdc1250_5$EXT"
cp "_temp/SUPER MARIO 64#8853B016#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_161e8741e2dd9e2b_5$EXT"
cp "_temp/SUPER MARIO 64#16733B9A#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_1a4e7f3b17d8773e_5$EXT"
cp "_temp/SUPER MARIO 64#A6C56AA3#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_1ab19baad6b04f52_5$EXT"
cp "_temp/SUPER MARIO 64#2B8359BB#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_2093e9aaa29de3ef_5$EXT"
cp "_temp/SUPER MARIO 64#F566B5FA#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_2119ac446f487105_5$EXT"
cp "_temp/SUPER MARIO 64#0374425D#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_25df8517bbd1ae0f_5$EXT"
cp "_temp/SUPER MARIO 64#12C0F052#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_27f6e6ae422dc90b_5$EXT"
cp "_temp/SUPER MARIO 64#A554538A#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_2b1eb22b6f0c5675_5$EXT"
cp "_temp/SUPER MARIO 64#A84756AE#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_2dde40ead88083c2_5$EXT"
cp "_temp/SUPER MARIO 64#940954AC#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_310548a7a7051837_5$EXT"
cp "_temp/SUPER MARIO 64#397F1DA4#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_31a78999e851e26f_5$EXT"
cp "_temp/SUPER MARIO 64#CBAB007A#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_3e91370a811c5596_5$EXT"
cp "_temp/SUPER MARIO 64#0E1E7EB2#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_42f176250028ae96_5$EXT"
cp "_temp/SUPER MARIO 64#6A8BF6A8#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_44df0dcc60b49b82_5$EXT"
cp "_temp/SUPER MARIO 64#F5013C4A#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_495acdbc768fdcda_5$EXT"
cp "_temp/SUPER MARIO 64#19D0A651#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_4a9a6d1b01e56982_5$EXT"
cp "_temp/SUPER MARIO 64#DB4B54D5#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_4b7c2f4156dc2e7d_5$EXT"
cp "_temp/SUPER MARIO 64#D4C2DC38#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_4c43c44ea152ba5c_5$EXT"
cp "_temp/SUPER MARIO 64#98DAF219#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_51b2594533499030_5$EXT"
cp "_temp/SUPER MARIO 64#CD56C1F2#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_51b85ecdc913aae2_5$EXT"
cp "_temp/SUPER MARIO 64#5A1A4FBF#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_51d4e1b1137e0df4_5$EXT"
cp "_temp/SUPER MARIO 64#A3936EE4#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_569d5acbef969acc_5$EXT"
cp "_temp/SUPER MARIO 64#4F3ECE62#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_58ce620ce17cbbba_5$EXT"
cp "_temp/SUPER MARIO 64#8675F075#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_66834a25e5d9d6d1_5$EXT"
cp "_temp/SUPER MARIO 64#3EC818DE#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_67397085bcaf944f_5$EXT"
cp "_temp/SUPER MARIO 64#6D1039D9#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_68a329c6ea455cdc_5$EXT"
cp "_temp/SUPER MARIO 64#F37A7379#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_73c471ffb478d143_5$EXT"
cp "_temp/SUPER MARIO 64#BFC9A9DD#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_7879416f8adc0b15_5$EXT"
cp "_temp/SUPER MARIO 64#B3B76BCE#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_85bc9d977300c365_5$EXT"
cp "_temp/SUPER MARIO 64#0A45EF5B#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_8a02189a269dd1f7_5$EXT"
cp "_temp/SUPER MARIO 64#DDE6049E#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_8a7cec55930fa23a_5$EXT"
cp "_temp/SUPER MARIO 64#0BE35913#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_9adf076bfd702136_5$EXT"
cp "_temp/SUPER MARIO 64#F0EDEA43#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_9b19f66ce26c2849_5$EXT"
cp "_temp/SUPER MARIO 64#7889781A#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_9c3e3a8e94cb3aa8_5$EXT"
cp "_temp/SUPER MARIO 64#D13A97C9#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_9c4a8da6edfc1a39_5$EXT"
cp "_temp/SUPER MARIO 64#D8F79383#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_a0fda7a2d877d545_5$EXT"
cp "_temp/SUPER MARIO 64#465F9B72#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_a2bbcab560d960a8_5$EXT"
cp "_temp/SUPER MARIO 64#FEB13915#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_a3c85c02ccc50025_5$EXT"
cp "_temp/SUPER MARIO 64#A72C7C50#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_abeea5d6d29f90f4_5$EXT"
cp "_temp/SUPER MARIO 64#5E2B9C03#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_b6d168bfd734212f_5$EXT"
cp "_temp/SUPER MARIO 64#006A1516#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_d06ff1f060c393c2_5$EXT"
cp "_temp/SUPER MARIO 64#56450E91#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_d0bbe14be90ff109_5$EXT"
cp "_temp/SUPER MARIO 64#D3EA4D38#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_d1bcdb242a0a1640_5$EXT"
cp "_temp/SUPER MARIO 64#07059F23#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_d36b801b743a56a9_5$EXT"
cp "_temp/SUPER MARIO 64#E01B30F4#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_d411c5dbe75a864a_5$EXT"
cp "_temp/SUPER MARIO 64#92E17E06#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_d8e7dd3bbb4f5f23_5$EXT"
cp "_temp/SUPER MARIO 64#41590B79#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_e678e50a36622972_5$EXT"
cp "_temp/SUPER MARIO 64#A6592F52#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_e85e12b718865c67_5$EXT"
cp "_temp/SUPER MARIO 64#0FF0D650#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_ea8710b93d566209_5$EXT"
cp "_temp/SUPER MARIO 64#A742C5E3#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_f401d292ae20b1e8_5$EXT"
cp "_temp/SUPER MARIO 64#158AA64C#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_f67b658338fa0c1a_5$EXT"
cp "_temp/SUPER MARIO 64#3CFBA273#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_f6f822ad98fa06f8_5$EXT"
cp "_temp/SUPER MARIO 64#E075472A#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_f8910b34da19589d_5$EXT"
cp "_temp/SUPER MARIO 64#6DF82BBE#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_fc025e2623284c16_5$EXT"
cp "_temp/SUPER MARIO 64#0391EE74#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_fee273b674cf8380_5$EXT"
cp "_temp/SUPER MARIO 64#CFB45CAF#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/tex1_32x32_ffaa33aa2a26615f_5$EXT"

cp "_temp/SUPER MARIO 64#45667AED#0#2_all$EXT" "$PORT/Skybox/tex1_32x32_e47c0382663d3c1c_5$EXT"
cp "_temp/SUPER MARIO 64#211EDF33#0#2_all$EXT" "$PORT/Skybox/tex1_32x32_c2cca2d514a1c237_5$EXT"
